/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.netherrocks;

import mod.alexndr.netherrocks.config.NetherrocksConfig;
import mod.alexndr.netherrocks.content.FyritePressurePlateBlock;
import mod.alexndr.netherrocks.content.NetherrocksArmorMaterial;
import mod.alexndr.netherrocks.helpers.NetherrocksInjectionLookup;
import mod.alexndr.simplecorelib.api.helpers.ArmorUtils;
import mod.alexndr.simplecorelib.api.helpers.InjectionTableLookup;
import mod.alexndr.simplecorelib.api.helpers.LootUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="netherrocks", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger((String)"netherrocks Forge Event Subscriber");
    private static final NetherrocksInjectionLookup lootLookupMap = new NetherrocksInjectionLookup();

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            LOGGER.debug("caught LivingAttackEvent");
            if (event.getSource() == DamageSource.f_19315_ && ArmorUtils.isPlayerWearingFullSet((Player)player, (ArmorMaterial)NetherrocksArmorMaterial.ILLUMENITE)) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                LOGGER.debug("Canceled fall damage because of illumenite");
            } else if (event.getSource().m_19384_() && ArmorUtils.isPlayerWearingFullSet((Player)player, (ArmorMaterial)NetherrocksArmorMaterial.FYRITE)) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                LOGGER.debug("Canceled fire damage because of fyrite");
            }
        }
    }

    @SubscribeEvent
    public static void LootLoad(LootTableLoadEvent event) {
        if (NetherrocksConfig.addModLootToChests) {
            LootUtils.LootLoadHandler((String)"netherrocks", (LootTableLoadEvent)event, (InjectionTableLookup)lootLookupMap);
        }
    }

    @SubscribeEvent
    public static void onVanillaGameEvent(VanillaGameEvent event) {
        if (event.getVanillaEvent() == GameEvent.f_223702_) {
            BlockPos bpos = new BlockPos(event.getEventPosition());
            BlockState bs = event.getLevel().m_8055_(bpos);
            if (bs == null) {
                return;
            }
            if (!(bs.m_60734_() instanceof FyritePressurePlateBlock)) {
                return;
            }
            Entity entity = event.getCause();
            if (entity == null) {
                return;
            }
            if (!entity.m_5825_()) {
                entity.m_20254_(10);
            }
        }
    }
}

