/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.EquipmentItem;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public abstract class GlassMeter
extends EquipmentItem {
    protected final Map<ItemStack, Entity> carriers = new ConcurrentHashMap<ItemStack, Entity>();
    private final ChatFormatting nameColor;

    public GlassMeter(UnitConfig config, Properties<?> props) {
        super(config, (EquipmentItem.Properties<?>)props);
        this.nameColor = props.nameColor;
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof GlassMeter) {
            BlockState state;
            GlassMeter meter = (GlassMeter)item;
            if (!player.f_20911_ && (state = event.getLevel().m_8055_(event.getPos())).m_60767_().m_76333_()) {
                meter.onHit(stack, player);
            }
        }
    }

    protected void onHit(ItemStack stack, Player player) {
        if (player instanceof ServerPlayer && GlassMeter.notBroken(stack)) {
            GlassMeter.damageItem(1, stack, false, player, damager -> {
                player.m_21166_(EquipmentSlot.MAINHAND);
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
            });
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        this.onHit(stack, player);
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        this.onHit(stack, player);
        return super.onDroppedByPlayer(stack, player);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public ChatFormatting getNameColor() {
        return this.nameColor;
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237115_((String)this.m_5671_(stack)).m_130940_(this.getNameColor());
    }

    public static class Properties<T extends Properties<T>>
    extends EquipmentItem.Properties<T> {
        public ChatFormatting nameColor = ChatFormatting.WHITE;

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
            this.repairMaterial = UnitId.from("#forge:glass_panes");
            this.equipSound = SoundEvents.f_11985_;
        }

        public T nameColor(ChatFormatting nameColor) {
            this.nameColor = nameColor;
            return (T)((Properties)this.self);
        }
    }
}

