/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.core;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonString;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.data.Namespace;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.network.Connection;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractForgeMod {
    protected final List<Runnable> postInitRunnables = new ArrayList<Runnable>();
    protected final DeferredRegister<ArgumentTypeInfo<?, ?>> commandArgumentTypes;
    private final Logger logger;
    private final Connection connection;
    private final Namespace namespace;

    public abstract String getId();

    protected AbstractForgeMod() {
        IEventBus modEventBus = this.getModEventBus();
        IEventBus forgeEventBus = this.getForgeEventBus();
        this.logger = LoggerFactory.getLogger((String)this.getId());
        this.connection = new Connection(this.getId(), this.getRequiredSide());
        this.namespace = Namespace.of(this.getId());
        this.commandArgumentTypes = DeferredRegister.create((IForgeRegistry)ForgeRegistries.COMMAND_ARGUMENT_TYPES, (String)this.getId());
        this.commandArgumentTypes.register(modEventBus);
        modEventBus.addListener(event -> this.commonInit());
        modEventBus.addListener(event -> event.enqueueWork(this::commonPostInit));
        modEventBus.addListener(event -> this.configUpdated(event.getConfig()));
        forgeEventBus.addListener(event -> this.tagsUpdated());
        forgeEventBus.addListener(event -> this.serverAboutToStart(event.getServer()));
        forgeEventBus.addListener(event -> this.serverStarting(event.getServer()));
        forgeEventBus.addListener(event -> this.serverStopped(event.getServer()));
        forgeEventBus.addListener(event -> this.registerCommands(ServerCommand.create(this, (CommandDispatcher<CommandSourceStack>)event.getDispatcher()), event.getBuildContext()));
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(event -> this.clientInit());
            modEventBus.addListener(event -> this.clientReplaceModels(new ItemModel.RegistryWrapper(event.getModels())));
            modEventBus.addListener(this::clientRegisterParticleProviders);
            modEventBus.addListener(event -> event.enqueueWork(() -> this.clientRegisterItemModelProperties(ItemModel.Properties.of(this))));
            modEventBus.addListener(event -> this.clientAddRenderLayers());
            modEventBus.addListener(event -> this.clientRegisterRenderers());
            modEventBus.addListener(this::clientRegisterGuiOverlays);
            modEventBus.addListener(this::clientRegisterKeyMappings);
        }
    }

    public IEventBus getModEventBus() {
        return FMLJavaModLoadingContext.get().getModEventBus();
    }

    public IEventBus getForgeEventBus() {
        return MinecraftForge.EVENT_BUS;
    }

    public abstract void commonInit();

    public void commonPostInit() {
        this.postInitRunnables.forEach(action -> action.run());
    }

    public void commonConfigInit(ConfigValueBuilder value) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientConfigInit(ConfigValueBuilder value) {
    }

    public void configUpdated(ModConfig config) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientAddRenderLayers() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterRenderers() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterParticleProviders(RegisterParticleProvidersEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterItemModelProperties(ItemModel.Properties<?> props) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterKeyMappings(RegisterKeyMappingsEvent event) {
    }

    public void registerCommands(ServerCommand command, CommandBuildContext buildContext) {
    }

    public void tagsUpdated() {
    }

    protected void serverAboutToStart(MinecraftServer server) {
    }

    protected void serverStarting(MinecraftServer server) {
    }

    protected void serverStopped(MinecraftServer server) {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public RequiredSide getRequiredSide() {
        return RequiredSide.BOTH;
    }

    public void runDuringPostInit(Runnable method) {
        this.postInitRunnables.add(method);
    }

    protected <MSG extends ForgeNetMsg<MSG>> void registerNetMessage(Supplier<MSG> factory) {
        this.getConnection().registerNetMessage((ForgeNetMsg)factory.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <T extends Entity> void registerEntityRender(EntityType<T> entityType, EntityRendererProvider<? super T> rendererProvider) {
        EntityRenderers.m_174036_(entityType, rendererProvider);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <T extends BlockEntity> void registerTileRenderer(BlockEntityType<T> tileEntityType, BlockEntityRendererProvider<? super T> rendererProvider) {
        BlockEntityRenderers.m_173590_(tileEntityType, rendererProvider);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <M extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(MenuType<? extends M> type, MenuScreens.ScreenConstructor<M, U> factory) {
        MenuScreens.m_96206_(type, factory);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderLayer(Block block, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderLayer(Fluid fluid, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addPlayerRenderLayer(Function<PlayerRenderer, RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>> renderLayerFactory) {
        Collection renderers = Minecraft.m_91087_().m_91290_().getSkinMap().values();
        renderers.forEach(renderer -> {
            if (renderer instanceof PlayerRenderer) {
                PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
                playerRenderer.m_115326_((RenderLayer)renderLayerFactory.apply(playerRenderer));
            }
        });
    }

    public static boolean isLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public Path getConfigsDir() {
        return FMLPaths.CONFIGDIR.get().resolve(this.getId());
    }

    protected void registerCommonConfig() {
        this.registerConfig(ModConfig.Type.COMMON, this::commonConfigInit, null);
    }

    protected void registerClientConfig() {
        if (FMLEnvironment.dist.isClient()) {
            this.registerConfig(ModConfig.Type.CLIENT, this::clientConfigInit, null);
        }
    }

    protected void registerConfig(ModConfig.Type type, Consumer<ConfigValueBuilder> init, @Nullable String fileName) {
        ConfigValueBuilder value = new ConfigValueBuilder();
        init.accept(value);
        ForgeConfigSpec spec = value.builder.build();
        ModLoadingContext context = ModLoadingContext.get();
        if (CommonString.isNullOrEmpty(fileName)) {
            context.registerConfig(type, (IConfigSpec)spec);
        } else {
            context.registerConfig(type, (IConfigSpec)spec, fileName);
        }
    }

    protected <A extends ArgumentType<?>> void registerCommandArgumentType(String name, Class<A> clazz, Supplier<A> supplier) {
        this.commandArgumentTypes.register(name, () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass((Class)clazz, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_((Supplier)supplier)));
    }

    public static enum RequiredSide {
        SERVER,
        CLIENT,
        BOTH;

    }

    public static class ConfigValueBuilder {
        public final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();

        public ConfigValueBuilder push(String path) {
            this.builder.push(path);
            return this;
        }

        public ConfigValueBuilder pop() {
            this.builder.pop();
            return this;
        }

        public ConfigValueBuilder worldRestart() {
            this.builder.worldRestart();
            return this;
        }

        public ConfigValueBuilder comment(String comment) {
            this.builder.comment(comment);
            return this;
        }

        public ForgeConfigSpec.ConfigValue<Boolean> define(String path, boolean defaultValue) {
            return this.builder.define(path, defaultValue);
        }

        public ForgeConfigSpec.ConfigValue<Integer> define(String path, ColorARGB defaultValue) {
            return this.builder.define(path, (Object)defaultValue.getARGB());
        }

        public ForgeConfigSpec.ConfigValue<Integer> defineInRange(String path, int defaultValue, IntBounds bounds) {
            return this.builder.defineInRange(path, defaultValue, bounds.getMin().intValue(), bounds.getMax().intValue());
        }

        public ForgeConfigSpec.ConfigValue<Double> defineInRange(String path, float defaultValue, FloatBounds bounds) {
            int fractDigits = 6;
            return this.builder.defineInRange(path, CommonMath.roundTo(defaultValue, fractDigits), CommonMath.roundTo(bounds.getMin().floatValue(), fractDigits), CommonMath.roundTo(bounds.getMax().floatValue(), fractDigits));
        }

        public <T extends Enum<T>> ForgeConfigSpec.ConfigValue<T> defineEnum(String path, T defaultValue) {
            return this.builder.defineEnum(path, defaultValue);
        }

        public ForgeConfigSpec.ConfigValue<Double> defineFactor(String path, float defaultValue) {
            return this.defineInRange(path, defaultValue, GameBounds.FACTOR.getFloatBounds());
        }

        public ForgeConfigSpec.ConfigValue<List<? extends String>> defineList(String path, String[] defaultValues, Predicate<String> validator) {
            return this.builder.defineListAllowEmpty(List.of(path), () -> List.of(defaultValues), object -> {
                String string;
                return object instanceof String && validator.test(string = (String)object);
            });
        }
    }
}

