/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.loot;

import com.autovw.advancednetherite.config.Config;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class CropDropsLootModifier
extends LootModifier {
    public static final Codec<CropDropsLootModifier> CODEC = RecordCodecBuilder.create(instance -> CropDropsLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CropDropsLootModifier::new));

    public CropDropsLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        CropBlock cropBlock;
        Block block;
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (tool != null && blockState != null && ((Boolean)Config.AdditionalDropsConfig.enableAdditionalCropDrops.get()).booleanValue() && (block = blockState.m_60734_()) instanceof CropBlock && (cropBlock = (CropBlock)block).m_52307_(blockState)) {
            RandomSource random = context.m_230907_();
            if (cropBlock == Blocks.f_50092_ && (double)random.m_188501_() <= (Double)Config.AdditionalDropProperties.additionalWheatDropChance.get()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42405_, random.m_216332_(0, 2)));
            }
            if (cropBlock == Blocks.f_50249_ && (double)random.m_188501_() <= (Double)Config.AdditionalDropProperties.additionalCarrotsDropChance.get()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42619_, random.m_216332_(0, 2)));
            }
            if (cropBlock == Blocks.f_50250_ && (double)random.m_188501_() <= (Double)Config.AdditionalDropProperties.additionalPotatoesDropChance.get()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42620_, random.m_216332_(0, 1)));
            }
            if (cropBlock == Blocks.f_50444_ && (double)random.m_188501_() <= (Double)Config.AdditionalDropProperties.additionalBeetrootsDropChance.get()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42732_, random.m_216332_(1, 2)));
            }
        }
        return generatedLoot;
    }

    public Codec<CropDropsLootModifier> codec() {
        return CODEC;
    }
}

