/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common;

import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.api.impl.IAdvancedHooks;
import com.autovw.advancednetherite.common.item.AdvancedArmorItem;
import com.autovw.advancednetherite.config.Config;
import com.autovw.advancednetherite.core.util.ModToolTiers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="advancednetherite", bus=Mod.EventBusSubscriber.Bus.FORGE)
@Internal
public class EventHandler {
    @SubscribeEvent
    public static void onEnderManAngerEvent(EnderManAngerEvent event) {
        Player player = event.getPlayer();
        EnderMan enderMan = event.getEntity();
        if (player.m_7500_()) {
            return;
        }
        for (ItemStack stack : player.m_6168_()) {
            Item item = stack.m_41720_();
            if ((!(item instanceof AdvancedArmorItem) || !((AdvancedArmorItem)item).pacifiesEndermen()) && (!(item instanceof IAdvancedHooks) || !((IAdvancedHooks)item).pacifyEndermen(stack))) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingChangeTargetEvent(LivingChangeTargetEvent event) {
        LivingEntity target = event.getOriginalTarget();
        LivingEntity attacker = event.getEntity();
        if (target == null) {
            return;
        }
        if (attacker.m_21188_() == target) {
            return;
        }
        if (attacker instanceof Phantom) {
            Phantom phantom = (Phantom)attacker;
            for (ItemStack stack : target.m_6168_()) {
                Item item = stack.m_41720_();
                if ((!(item instanceof AdvancedArmorItem) || !((AdvancedArmorItem)item).pacifiesPhantoms()) && (!(item instanceof IAdvancedHooks) || !((IAdvancedHooks)item).pacifyPhantoms(stack))) continue;
                event.setNewTarget(null);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerEventBreakSpeed(PlayerEvent.BreakSpeed event) {
        BlockState state = event.getState();
        Player player = event.getEntity();
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = stack.m_41720_();
        if (!(item instanceof DiggerItem)) {
            return;
        }
        DiggerItem diggerItem = (DiggerItem)item;
        if (state == null) {
            return;
        }
        if (diggerItem.isCorrectToolForDrops(stack, state)) {
            Tier tier = diggerItem.m_43314_();
            float speed = event.getOriginalSpeed();
            if (tier == ModToolTiers.NETHERITE_IRON) {
                speed *= (float)((Integer)Config.ToolProperties.ironBreakingSpeedMultiplier.get()).intValue();
            }
            if (tier == ModToolTiers.NETHERITE_GOLD) {
                speed *= (float)((Integer)Config.ToolProperties.goldBreakingSpeedMultiplier.get()).intValue();
            }
            if (tier == ModToolTiers.NETHERITE_EMERALD) {
                speed *= (float)((Integer)Config.ToolProperties.emeraldBreakingSpeedMultiplier.get()).intValue();
            }
            if (tier == ModToolTiers.NETHERITE_DIAMOND) {
                speed *= (float)((Integer)Config.ToolProperties.diamondBreakingSpeedMultiplier.get()).intValue();
            }
            event.setNewSpeed(speed);
        }
    }
}

