/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module;

import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.base.world.config.BiomeTypeConfig;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.config.EntitySpawnConfig;
import vazkii.quark.world.client.render.StonelingRenderer;
import vazkii.quark.world.entity.StonelingEntity;
import vazkii.quark.world.item.DiamondHeartItem;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class StonelingsModule
extends Module {
    public static EntityType<StonelingEntity> stonelingType;
    @Config
    public static int maxYLevel;
    @Config
    public static DimensionConfig dimensions;
    @Config
    public static EntitySpawnConfig spawnConfig;
    @Config(flag="stoneling_drop_diamond_heart")
    public static boolean enableDiamondHeart;
    @Config
    public static boolean cautiousStonelings;
    @Config
    public static boolean tamableStonelings;
    public static Item diamondHeart;

    @Override
    public void construct() {
        diamondHeart = new DiamondHeartItem("diamond_heart", this, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        stonelingType = EntityType.Builder.func_220322_a(StonelingEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.5f, 0.9f).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).setCustomClientFactory((spawnEntity, world) -> new StonelingEntity((EntityType<? extends StonelingEntity>)stonelingType, (World)world)).func_206830_a("stoneling");
        RegistryHelper.register(stonelingType, (String)"stoneling");
        EntitySpawnHandler.registerSpawn(this, stonelingType, EntityClassification.MONSTER, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, StonelingEntity::spawnPredicate, spawnConfig);
        EntitySpawnHandler.addEgg(stonelingType, 0xA1A1A1, 0x505050, spawnConfig);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(StonelingEntity.class, StonelingRenderer::new);
    }

    static {
        maxYLevel = 24;
        dimensions = DimensionConfig.overworld(false);
        spawnConfig = new EntitySpawnConfig(80, 1, 1, new BiomeTypeConfig(true, BiomeDictionary.Type.VOID));
        enableDiamondHeart = true;
        cautiousStonelings = true;
        tamableStonelings = true;
    }
}

