/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module;

import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.effect.QuarkEffect;
import vazkii.quark.base.handler.BrewingHandler;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.recipe.FlagIngredient;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.base.world.config.BiomeTypeConfig;
import vazkii.quark.base.world.config.ConditionalEntitySpawnConfig;
import vazkii.quark.world.client.render.CrabRenderer;
import vazkii.quark.world.client.render.FrogRenderer;
import vazkii.quark.world.entity.CrabEntity;
import vazkii.quark.world.entity.FrogEntity;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class PassiveCreaturesModule
extends Module {
    public static EntityType<FrogEntity> frogType;
    public static EntityType<CrabEntity> crabType;
    @Config(name="frogs")
    public static ConditionalEntitySpawnConfig frogConfig;
    @Config(name="crabs")
    public static ConditionalEntitySpawnConfig crabConfig;
    @Config(flag="passive_creatures_brewing")
    public static boolean enableBrewing;
    @Config
    public static boolean enableJokes;

    @Override
    public void construct() {
        new QuarkItem("frog_leg", this, new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221451_a().func_221456_a(2).func_221454_a(0.3f).func_221453_d())).setCondition(() -> PassiveCreaturesModule.frogConfig.enabled);
        new QuarkItem("cooked_frog_leg", this, new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221451_a().func_221456_a(4).func_221454_a(1.25f).func_221453_d())).setCondition(() -> PassiveCreaturesModule.frogConfig.enabled);
        QuarkItem goldenLeg = new QuarkItem("golden_frog_leg", this, new Item.Properties().func_200916_a(ItemGroup.field_78038_k).func_221540_a(new Food.Builder().func_221451_a().func_221456_a(4).func_221454_a(2.5f).func_221453_d())).setCondition(() -> PassiveCreaturesModule.frogConfig.enabled && enableBrewing);
        new QuarkItem("crab_leg", this, new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221451_a().func_221456_a(1).func_221454_a(0.3f).func_221453_d())).setCondition(() -> PassiveCreaturesModule.crabConfig.enabled);
        new QuarkItem("cooked_crab_leg", this, new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221451_a().func_221456_a(8).func_221454_a(0.8f).func_221453_d())).setCondition(() -> PassiveCreaturesModule.crabConfig.enabled);
        QuarkItem shell = new QuarkItem("crab_shell", this, new Item.Properties().func_200916_a(ItemGroup.field_78038_k)).setCondition(() -> PassiveCreaturesModule.crabConfig.enabled && enableBrewing);
        QuarkEffect resilience = new QuarkEffect("resilience", EffectType.BENEFICIAL, 5970436);
        resilience.func_220304_a(SharedMonsterAttributes.field_111266_c, "2ddf3f0a-f386-47b6-aeb0-6bd32851f215", 0.5, AttributeModifier.Operation.ADDITION);
        BrewingHandler.addPotionMix("passive_creatures_brewing", () -> PassiveCreaturesModule.lambda$construct$6((Item)goldenLeg), Potions.field_185238_j, Potions.field_185239_k, Potions.field_185240_l);
        BrewingHandler.addPotionMix("passive_creatures_brewing", () -> PassiveCreaturesModule.lambda$construct$7((Item)shell), resilience);
        frogType = EntityType.Builder.func_220322_a(FrogEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.65f, 0.5f).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).setCustomClientFactory((spawnEntity, world) -> new FrogEntity((EntityType<? extends FrogEntity>)frogType, (World)world)).func_206830_a("frog");
        RegistryHelper.register(frogType, (String)"frog");
        EntitySpawnHandler.registerSpawn(this, frogType, EntityClassification.CREATURE, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b, frogConfig);
        EntitySpawnHandler.addEgg(frogType, 12359785, 16770733, frogConfig);
        crabType = EntityType.Builder.func_220322_a(CrabEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 0.5f).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).setCustomClientFactory((spawnEntity, world) -> new CrabEntity((EntityType<? extends CrabEntity>)crabType, (World)world)).func_206830_a("crab");
        RegistryHelper.register(crabType, (String)"crab");
        EntitySpawnHandler.registerSpawn(this, crabType, EntityClassification.CREATURE, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, CrabEntity::spawnPredicate, crabConfig);
        EntitySpawnHandler.addEgg(crabType, 8993826, 9528648, crabConfig);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(FrogEntity.class, FrogRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(CrabEntity.class, CrabRenderer::new);
    }

    private static /* synthetic */ Ingredient lambda$construct$7(Item shell) {
        return new FlagIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{shell}), "crabs");
    }

    private static /* synthetic */ Ingredient lambda$construct$6(Item goldenLeg) {
        return new FlagIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{goldenLeg}), "frogs");
    }

    static {
        frogConfig = new ConditionalEntitySpawnConfig("frogs", 40, 1, 3, new BiomeTypeConfig(false, BiomeDictionary.Type.SWAMP));
        crabConfig = new ConditionalEntitySpawnConfig("crabs", 5, 1, 3, new BiomeTypeConfig(false, BiomeDictionary.Type.BEACH));
        enableBrewing = true;
        enableJokes = false;
    }
}

