/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module;

import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.world.block.MonsterBoxBlock;
import vazkii.quark.world.gen.MonsterBoxGenerator;
import vazkii.quark.world.tile.MonsterBoxTileEntity;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class MonsterBoxModule
extends Module {
    public static final String TAG_MONSTER_BOX_SPAWNED = "quark:monster_box_spawned";
    public static final ResourceLocation MONSTER_BOX_LOOT_TABLE = new ResourceLocation("quark", "misc/monster_box");
    public static TileEntityType<MonsterBoxTileEntity> tileEntityType;
    @Config(description="The chance for the monster box generator to try and place one in a chunk, 1 is 100%\nThis can be higher than 100% if you want multiple per chunk, , 0 is 0%")
    public static double chancePerChunk;
    @Config
    public static int minY;
    @Config
    public static int maxY;
    @Config
    public static int minMobCount;
    @Config
    public static int maxMobCount;
    @Config
    public static DimensionConfig dimensions;
    @Config
    public static boolean enableExtraLootTable;
    public static Block monster_box;

    @Override
    public void construct() {
        monster_box = new MonsterBoxBlock(this);
        tileEntityType = TileEntityType.Builder.func_223042_a(MonsterBoxTileEntity::new, (Block[])new Block[]{monster_box}).func_206865_a(null);
        RegistryHelper.register(tileEntityType, (String)"monster_box");
    }

    @Override
    public void setup() {
        WorldGenHandler.addGenerator(this, new MonsterBoxGenerator(dimensions), GenerationStage.Decoration.UNDERGROUND_DECORATION, 4);
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        LootTable loot;
        LivingEntity entity = event.getEntityLiving();
        if (enableExtraLootTable && entity.func_130014_f_() instanceof ServerWorld && entity.getPersistentData().func_74767_n(TAG_MONSTER_BOX_SPAWNED) && entity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e) && (loot = ((ServerWorld)entity.func_130014_f_()).func_73046_m().func_200249_aQ().func_186521_a(MONSTER_BOX_LOOT_TABLE)) != null) {
            loot.func_216120_b(new LootContext.Builder((ServerWorld)entity.func_130014_f_()).func_216022_a(LootParameterSets.field_216260_a), arg_0 -> ((LivingEntity)entity).func_199701_a_(arg_0));
        }
    }

    static {
        chancePerChunk = 0.8;
        minY = 5;
        maxY = 30;
        minMobCount = 5;
        maxMobCount = 8;
        dimensions = DimensionConfig.overworld(false);
        enableExtraLootTable = true;
        monster_box = null;
    }
}

