/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.entity;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.extensions.IForgeWorldServer;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.quark.base.ai.IfFlagGoal;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.ai.ActWaryGoal;
import vazkii.quark.world.ai.FavorBlockGoal;
import vazkii.quark.world.ai.RunAndPoofGoal;
import vazkii.quark.world.entity.EnumStonelingVariant;
import vazkii.quark.world.entity.FrogEntity;
import vazkii.quark.world.module.PassiveCreaturesModule;
import vazkii.quark.world.module.StonelingsModule;

public class StonelingEntity
extends CreatureEntity {
    public static final ResourceLocation CARRY_LOOT_TABLE = new ResourceLocation("quark", "entities/stoneling_carry");
    private static final DataParameter<ItemStack> CARRYING_ITEM = EntityDataManager.func_187226_a(StonelingEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Byte> VARIANT = EntityDataManager.func_187226_a(StonelingEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> HOLD_ANGLE = EntityDataManager.func_187226_a(StonelingEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final String TAG_CARRYING_ITEM = "carryingItem";
    private static final String TAG_VARIANT = "variant";
    private static final String TAG_HOLD_ANGLE = "itemAngle";
    private static final String TAG_PLAYER_MADE = "playerMade";
    private ActWaryGoal waryGoal;
    private boolean isTame;

    public StonelingEntity(EntityType<? extends StonelingEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.DAMAGE_CACTUS, 1.0f);
        this.func_184644_a(PathNodeType.DANGER_CACTUS, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRYING_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(HOLD_ANGLE, (Object)Float.valueOf(0.0f));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.2, 0.98f));
        this.field_70714_bg.func_75776_a(4, (Goal)new FavorBlockGoal((CreatureEntity)this, 0.2, (Tag<Block>)Tags.Blocks.ORES_DIAMOND));
        this.field_70714_bg.func_75776_a(3, (Goal)new IfFlagGoal((Goal)new TemptGoal((CreatureEntity)this, 0.6, Ingredient.func_199805_a((Tag)Tags.Items.GEMS_DIAMOND), false), () -> StonelingsModule.enableDiamondHeart && !StonelingsModule.tamableStonelings));
        this.field_70714_bg.func_75776_a(2, new RunAndPoofGoal<PlayerEntity>(this, PlayerEntity.class, 4.0f, 0.5, 0.5));
        this.waryGoal = new ActWaryGoal(this, 0.1, 6.0, () -> StonelingsModule.cautiousStonelings);
        this.field_70714_bg.func_75776_a(1, (Goal)this.waryGoal);
        this.field_70714_bg.func_75776_a(0, (Goal)new IfFlagGoal((Goal)new TemptGoal((CreatureEntity)this, 0.6, Ingredient.func_199805_a((Tag)Tags.Items.GEMS_DIAMOND), false), () -> StonelingsModule.tamableStonelings));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70138_W = this.field_70171_ac ? 1.0f : 0.6f;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && !this.isTame) {
            this.func_70106_y();
            for (Entity passenger : this.func_184182_bu()) {
                if (passenger instanceof PlayerEntity) continue;
                passenger.func_70106_y();
            }
        }
        this.field_70760_ar = this.field_70126_B;
        this.field_70761_aq = this.field_70177_z;
    }

    public EntityClassification getClassification(boolean forSpawnCount) {
        if (this.isTame) {
            return EntityClassification.CREATURE;
        }
        return EntityClassification.MONSTER;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.isTame;
    }

    protected void func_70623_bb() {
        boolean wasAlive = this.func_70089_S();
        super.func_70623_bb();
        if (!this.func_70089_S() && wasAlive) {
            for (Entity passenger : this.func_184182_bu()) {
                if (passenger instanceof PlayerEntity) continue;
                passenger.func_70106_y();
            }
        }
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151057_cb) {
            stack.func_111282_a(player, (LivingEntity)this, hand);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Nonnull
    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec, Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            ItemStack playerItem = player.func_184586_b(hand);
            if (!this.field_70170_p.field_72995_K) {
                if (this.isPlayerMade()) {
                    if (!player.func_70093_af() && !playerItem.func_190926_b()) {
                        EnumStonelingVariant currentVariant = this.getVariant();
                        EnumStonelingVariant targetVariant = null;
                        Block targetBlock = null;
                        block0: for (EnumStonelingVariant variant : EnumStonelingVariant.values()) {
                            for (Block block : variant.getBlocks()) {
                                if (block.func_199767_j() != playerItem.func_77973_b()) continue;
                                targetVariant = variant;
                                targetBlock = block;
                                break block0;
                            }
                        }
                        if (targetVariant != null) {
                            if (this.field_70170_p instanceof ServerWorld) {
                                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, this.field_70165_t, this.field_70163_u + (double)this.func_213302_cg(), this.field_70161_v, 1, 0.1, 0.1, 0.1, 0.1);
                                if (targetVariant != currentVariant) {
                                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, targetBlock.func_176223_P()), this.field_70165_t, this.field_70163_u + (double)(this.func_213302_cg() / 2.0f), this.field_70161_v, 16, 0.1, 0.1, 0.1, 0.25);
                                }
                            }
                            if (targetVariant != currentVariant) {
                                this.func_184185_a(QuarkSounds.ENTITY_STONELING_EAT, 1.0f, 1.0f);
                                this.field_70180_af.func_187227_b(VARIANT, (Object)targetVariant.getIndex());
                            }
                            this.func_184185_a(QuarkSounds.ENTITY_STONELING_PURR, 1.0f, 1.0f + this.field_70170_p.field_73012_v.nextFloat() * 1.0f);
                            this.func_70691_i(1.0f);
                            if (!player.field_71075_bZ.field_75098_d) {
                                playerItem.func_190918_g(1);
                            }
                            return ActionResultType.SUCCESS;
                        }
                        return ActionResultType.PASS;
                    }
                    ItemStack stonelingItem = (ItemStack)this.field_70180_af.func_187225_a(CARRYING_ITEM);
                    if (!stonelingItem.func_190926_b() || !playerItem.func_190926_b()) {
                        player.func_184611_a(hand, stonelingItem.func_77946_l());
                        this.field_70180_af.func_187227_b(CARRYING_ITEM, (Object)playerItem.func_77946_l());
                        if (playerItem.func_190926_b()) {
                            this.func_184185_a(QuarkSounds.ENTITY_STONELING_GIVE, 1.0f, 1.0f);
                        } else {
                            this.func_184185_a(QuarkSounds.ENTITY_STONELING_TAKE, 1.0f, 1.0f);
                        }
                    }
                } else if (StonelingsModule.tamableStonelings && playerItem.func_77973_b().func_206844_a(Tags.Items.GEMS_DIAMOND)) {
                    this.func_70691_i(8.0f);
                    this.setPlayerMade(true);
                    this.func_184185_a(QuarkSounds.ENTITY_STONELING_PURR, 1.0f, 1.0f + this.field_70170_p.field_73012_v.nextFloat() * 1.0f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        playerItem.func_190918_g(1);
                    }
                    if (this.field_70170_p instanceof ServerWorld) {
                        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, this.field_70165_t, this.field_70163_u + (double)this.func_213302_cg(), this.field_70161_v, 4, 0.1, 0.1, 0.1, 0.1);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData data, @Nullable CompoundNBT compound) {
        byte variant = data instanceof EnumStonelingVariant ? ((EnumStonelingVariant)data).getIndex() : (byte)world.func_201674_k().nextInt(EnumStonelingVariant.values().length);
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.field_70180_af.func_187227_b(HOLD_ANGLE, (Object)Float.valueOf(world.func_201674_k().nextFloat() * 90.0f - 45.0f));
        if (!this.isTame && !world.func_201670_d() && world instanceof IForgeWorldServer) {
            if (ModuleLoader.INSTANCE.isModuleEnabled(PassiveCreaturesModule.class) && PassiveCreaturesModule.frogConfig.enabled && this.field_70146_Z.nextDouble() < 0.01) {
                FrogEntity frog = new FrogEntity(PassiveCreaturesModule.frogType, world.func_201672_e(), 0.25f);
                frog.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                world.func_217376_c((Entity)frog);
                frog.func_184220_m((Entity)this);
            } else {
                List items = ((IForgeWorldServer)world).getWorldServer().func_73046_m().func_200249_aQ().func_186521_a(CARRY_LOOT_TABLE).func_216113_a(new LootContext.Builder((ServerWorld)world).func_216022_a(LootParameterSets.field_216260_a));
                if (!items.isEmpty()) {
                    this.field_70180_af.func_187227_b(CARRYING_ITEM, items.get(0));
                }
            }
        }
        return super.func_213386_a(world, difficulty, spawnReason, data, compound);
    }

    public boolean func_180431_b(@Nonnull DamageSource source) {
        return source == DamageSource.field_76367_g || source.func_76352_a() || super.func_180431_b(source);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_205019_a(IWorldReader worldReader) {
        return worldReader.func_217346_i((Entity)this);
    }

    public double func_70042_X() {
        return this.func_213302_cg();
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_70665_d(@Nonnull DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        if (!this.isPlayerMade() && damageSrc.func_76346_g() instanceof PlayerEntity) {
            this.startle();
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(16.0))) {
                StonelingEntity stoneling;
                if (!(entity instanceof StonelingEntity) || (stoneling = (StonelingEntity)entity).isPlayerMade() || !stoneling.func_70635_at().func_75522_a((Entity)this)) continue;
                this.startle();
            }
        }
    }

    public boolean isStartled() {
        return this.waryGoal.isStartled();
    }

    public void startle() {
        this.waryGoal.startle();
        HashSet entries = Sets.newHashSet((Iterable)this.field_70714_bg.field_220892_d);
        for (PrioritizedGoal task : entries) {
            if (!(task.func_220772_j() instanceof TemptGoal)) continue;
            this.field_70714_bg.func_85156_a(task.func_220772_j());
        }
    }

    protected void func_213333_a(DamageSource damage, int looting, boolean wasRecentlyHit) {
        super.func_213333_a(damage, looting, wasRecentlyHit);
        ItemStack stack = this.getCarryingItem();
        if (!stack.func_190926_b()) {
            this.func_70099_a(stack, 0.0f);
        }
    }

    public void setPlayerMade(boolean value) {
        this.isTame = value;
    }

    public ItemStack getCarryingItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(CARRYING_ITEM);
    }

    public EnumStonelingVariant getVariant() {
        return EnumStonelingVariant.byIndex((Byte)this.field_70180_af.func_187225_a(VARIANT));
    }

    public float getItemAngle() {
        return ((Float)this.field_70180_af.func_187225_a(HOLD_ANGLE)).floatValue();
    }

    public boolean isPlayerMade() {
        return this.isTame;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b(TAG_CARRYING_ITEM, 10)) {
            CompoundNBT itemCmp = compound.func_74775_l(TAG_CARRYING_ITEM);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)itemCmp);
            this.field_70180_af.func_187227_b(CARRYING_ITEM, (Object)stack);
        }
        this.field_70180_af.func_187227_b(VARIANT, (Object)compound.func_74771_c(TAG_VARIANT));
        this.field_70180_af.func_187227_b(HOLD_ANGLE, (Object)Float.valueOf(compound.func_74760_g(TAG_HOLD_ANGLE)));
        this.setPlayerMade(compound.func_74767_n(TAG_PLAYER_MADE));
    }

    public boolean func_70685_l(Entity entityIn) {
        Vec3d origin = new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
        Vec3d targetBase = new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v);
        float otherEyes = entityIn.func_70047_e();
        for (float height = 0.0f; height <= otherEyes; height += otherEyes / 8.0f) {
            if (this.field_70170_p.func_217299_a(new RayTraceContext(origin, targetBase.func_72441_c(0.0, (double)height, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS) continue;
            return true;
        }
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a(TAG_CARRYING_ITEM, (INBT)this.getCarryingItem().serializeNBT());
        compound.func_74774_a(TAG_VARIANT, this.getVariant().getIndex());
        compound.func_74776_a(TAG_HOLD_ANGLE, this.getItemAngle());
        compound.func_74757_a(TAG_PLAYER_MADE, this.isPlayerMade());
    }

    public static boolean validLight(IWorld world, BlockPos pos, Random rand) {
        if (world.func_175642_b(LightType.SKY, pos) > rand.nextInt(32)) {
            return false;
        }
        int light = world.func_201672_e().func_72911_I() ? world.func_205049_d(pos, 10) : world.func_201696_r(pos);
        return light <= rand.nextInt(8);
    }

    public static boolean spawnPredicate(EntityType<? extends StonelingEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && pos.func_177956_o() <= StonelingsModule.maxYLevel && StonelingEntity.validLight(world, pos, rand) && StonelingEntity.validLocation(type, world, reason, pos);
    }

    public static boolean validLocation(@Nonnull EntityType<? extends MobEntity> type, @Nonnull IWorld world, SpawnReason reason, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        if (reason == SpawnReason.SPAWNER) {
            return true;
        }
        BlockState state = world.func_180495_p(below);
        return state.func_185904_a() == Material.field_151576_e && state.func_215688_a((IBlockReader)world, below, type);
    }

    public boolean func_213380_a(@Nonnull IWorld world, SpawnReason reason) {
        BlockState state = world.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        if (state.func_185904_a() != Material.field_151576_e) {
            return false;
        }
        return StonelingsModule.dimensions.canSpawnHere(world) && super.func_213380_a(world, reason);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return QuarkSounds.ENTITY_STONELING_CRY;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return QuarkSounds.ENTITY_STONELING_DIE;
    }

    public int func_70627_aG() {
        return 1200;
    }

    public void func_70642_aH() {
        SoundEvent sound = this.func_184639_G();
        if (sound != null) {
            this.func_184185_a(sound, this.func_70599_aP(), 1.0f);
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        String customName;
        if (this.func_145818_k_() && ((customName = this.func_200200_C_().getString()).equalsIgnoreCase("michael stevens") || customName.equalsIgnoreCase("vsauce"))) {
            return QuarkSounds.ENTITY_STONELING_MICHAEL;
        }
        return null;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float func_205022_a(BlockPos pos, IWorldReader world) {
        return 0.5f - world.func_205052_D(pos);
    }
}

