/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.client.model;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.util.math.MathHelper;
import vazkii.quark.world.entity.CrabEntity;

public class CrabModel
extends EntityModel<CrabEntity> {
    public RendererModel group;
    public RendererModel body;
    public RendererModel rightClaw;
    public RendererModel leftClaw;
    public RendererModel rightLeg1;
    public RendererModel rightLeg2;
    public RendererModel rightLeg3;
    public RendererModel rightLeg4;
    public RendererModel leftLeg1;
    public RendererModel leftLeg2;
    public RendererModel leftLeg3;
    public RendererModel leftLeg4;
    public RendererModel rightEye;
    public RendererModel leftEye;
    private final List<Runnable> resetFunctions = new ArrayList<Runnable>();
    private final Set<RendererModel> leftLegs;
    private final Set<RendererModel> rightLegs;

    public CrabModel() {
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.group = new RendererModel((Model)this);
        this.group.func_78793_a(0.0f, 0.0f, 0.0f);
        this.setRotationAngle(this.group, 0.0f, 0.0f, 0.0f);
        this.leftLeg4 = new RendererModel((Model)this, 0, 19);
        this.leftLeg4.field_78809_i = true;
        this.leftLeg4.func_78793_a(3.0f, 20.0f, -1.0f);
        this.leftLeg4.func_78790_a(0.0f, -0.5f, -0.5f, 6, 1, 1, 0.0f);
        this.setRotateAngle(this.leftLeg4, 0.0f, 0.43633232f, 0.7853982f);
        this.leftLeg3 = new RendererModel((Model)this, 0, 19);
        this.leftLeg3.field_78809_i = true;
        this.leftLeg3.func_78793_a(3.0f, 20.0f, 0.0f);
        this.leftLeg3.func_78790_a(0.0f, -0.5f, -0.5f, 6, 1, 1, 0.0f);
        this.setRotateAngle(this.leftLeg3, 0.0f, 0.21816616f, 0.7853982f);
        this.rightEye = new RendererModel((Model)this, 0, 11);
        this.rightEye.func_78793_a(0.0f, 0.0f, 0.0f);
        this.rightEye.func_78790_a(-3.0f, -3.5f, -2.85f, 1, 3, 1, 0.0f);
        this.setRotateAngle(this.rightEye, -0.3926991f, 0.0f, 0.0f);
        this.rightLeg4 = new RendererModel((Model)this, 0, 19);
        this.rightLeg4.func_78793_a(-3.0f, 20.0f, -1.0f);
        this.rightLeg4.func_78790_a(-6.0f, -0.5f, -0.5f, 6, 1, 1, 0.0f);
        this.setRotateAngle(this.rightLeg4, 0.0f, -0.43633232f, -0.7853982f);
        this.rightClaw = new RendererModel((Model)this, 14, 11);
        this.rightClaw.func_78793_a(-3.0f, 20.0f, -4.0f);
        this.rightClaw.func_78790_a(-3.0f, -2.5f, -6.0f, 3, 5, 6, 0.0f);
        this.setRotateAngle(this.rightClaw, 0.0f, 0.3926991f, -0.3926991f);
        this.leftLeg1 = new RendererModel((Model)this, 0, 19);
        this.leftLeg1.field_78809_i = true;
        this.leftLeg1.func_78793_a(3.0f, 20.0f, 2.0f);
        this.leftLeg1.func_78790_a(0.0f, -0.5f, -0.5f, 6, 1, 1, 0.0f);
        this.setRotateAngle(this.leftLeg1, 0.0f, -0.43633232f, 0.7853982f);
        this.rightLeg2 = new RendererModel((Model)this, 0, 19);
        this.rightLeg2.func_78793_a(-3.0f, 20.0f, 0.9f);
        this.rightLeg2.func_78790_a(-6.0f, -0.5f, -0.5f, 6, 1, 1, 0.0f);
        this.setRotateAngle(this.rightLeg2, 0.0f, 0.21816616f, -0.7853982f);
        this.leftClaw = new RendererModel((Model)this, 14, 11);
        this.leftClaw.field_78809_i = true;
        this.leftClaw.func_78793_a(3.0f, 20.0f, -4.0f);
        this.leftClaw.func_78790_a(0.0f, -2.5f, -6.0f, 3, 5, 6, 0.0f);
        this.setRotateAngle(this.leftClaw, 0.0f, -0.3926991f, 0.3926991f);
        this.rightLeg1 = new RendererModel((Model)this, 0, 19);
        this.rightLeg1.func_78793_a(-3.0f, 20.0f, 2.0f);
        this.rightLeg1.func_78790_a(-6.0f, -0.5f, -0.5f, 6, 1, 1, 0.0f);
        this.setRotateAngle(this.rightLeg1, 0.0f, 0.43633232f, -0.7853982f);
        this.body = new RendererModel((Model)this, 0, 0);
        this.body.func_78793_a(0.0f, 20.0f, 0.0f);
        this.body.func_78790_a(-4.0f, -2.5f, -3.0f, 8, 5, 6, 0.0f);
        this.leftEye = new RendererModel((Model)this, 0, 11);
        this.leftEye.func_78793_a(0.0f, 0.0f, 0.0f);
        this.leftEye.func_78790_a(2.0f, -3.5f, -2.85f, 1, 3, 1, 0.0f);
        this.setRotateAngle(this.leftEye, -0.3926991f, 0.0f, 0.0f);
        this.leftLeg2 = new RendererModel((Model)this, 0, 19);
        this.leftLeg2.field_78809_i = true;
        this.leftLeg2.func_78793_a(3.0f, 20.0f, 0.9f);
        this.leftLeg2.func_78790_a(0.0f, -0.5f, -0.5f, 6, 1, 1, 0.0f);
        this.setRotateAngle(this.leftLeg2, 0.0f, -0.21816616f, 0.7853982f);
        this.rightLeg3 = new RendererModel((Model)this, 0, 19);
        this.rightLeg3.func_78793_a(-3.0f, 20.0f, 0.0f);
        this.rightLeg3.func_78790_a(-6.0f, -0.5f, -0.5f, 6, 1, 1, 0.0f);
        this.setRotateAngle(this.rightLeg3, 0.0f, -0.21816616f, -0.7853982f);
        this.body.func_78792_a(this.rightEye);
        this.body.func_78792_a(this.leftEye);
        this.group.func_78792_a(this.body);
        this.group.func_78792_a(this.rightLeg1);
        this.group.func_78792_a(this.rightLeg2);
        this.group.func_78792_a(this.rightLeg3);
        this.group.func_78792_a(this.rightLeg4);
        this.group.func_78792_a(this.leftLeg1);
        this.group.func_78792_a(this.leftLeg2);
        this.group.func_78792_a(this.leftLeg3);
        this.group.func_78792_a(this.leftLeg4);
        this.group.func_78792_a(this.rightClaw);
        this.group.func_78792_a(this.leftClaw);
        this.leftLegs = ImmutableSet.of((Object)this.leftLeg1, (Object)this.leftLeg2, (Object)this.leftLeg3, (Object)this.leftLeg4);
        this.rightLegs = ImmutableSet.of((Object)this.rightLeg1, (Object)this.rightLeg2, (Object)this.rightLeg3, (Object)this.rightLeg4);
    }

    public void setRotateAngle(RendererModel modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void setRotationAngles(CrabEntity crab, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        this.resetModel();
        this.rightLeg1.field_78808_h = -0.2618f + (-1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.rightLeg2.field_78808_h = -0.5236f + (-1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.rightLeg3.field_78808_h = -0.5236f + (-1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.rightLeg4.field_78808_h = -0.2618f + (-1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.leftLeg1.field_78808_h = 0.2618f + (1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.leftLeg2.field_78808_h = 0.5236f + (1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.leftLeg3.field_78808_h = 0.5236f + (1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI))) * 0.7f * limbSwingAmount;
        this.leftLeg4.field_78808_h = 0.2618f + (1.0f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f))) * 0.7f * limbSwingAmount;
        this.leftClaw.field_78795_f = 0.0f;
        this.rightClaw.field_78795_f = 0.0f;
        this.group.field_82906_o = 0.0f;
        this.group.field_82908_p = 0.0f;
        if (crab.isRaving()) {
            float armRot;
            float crabRaveBPM = 31.25f;
            float freq = 20.0f / crabRaveBPM;
            float tick = ageInTicks * freq;
            float sin = (float)(Math.sin(tick) * 0.5 + 0.5);
            float legRot = sin * 0.8f + 0.6f;
            this.leftLegs.forEach(l -> {
                l.field_78808_h = legRot;
            });
            this.rightLegs.forEach(l -> {
                l.field_78808_h = -legRot;
            });
            float maxHeight = -0.05f;
            float horizontalOff = 0.2f;
            this.group.field_82908_p = (sin - 0.5f) * 2.0f * maxHeight + maxHeight / 2.0f;
            float slowSin = (float)Math.sin(tick / 2.0f);
            this.group.field_82906_o = slowSin * horizontalOff;
            this.leftClaw.field_78795_f = armRot = sin * 0.5f - 1.2f;
            this.rightClaw.field_78795_f = armRot;
        }
    }

    public void render(CrabEntity crab, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        GlStateManager.pushMatrix();
        float sizeModifier = crab.getSizeModifier();
        if (this.field_217114_e) {
            sizeModifier /= 2.0f;
        }
        GlStateManager.translated((double)0.0, (double)(1.5 - (double)sizeModifier * 1.5), (double)0.0);
        GlStateManager.scalef((float)sizeModifier, (float)sizeModifier, (float)sizeModifier);
        GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.group.func_78785_a(scaleFactor);
        GlStateManager.popMatrix();
    }

    private void setRotationAngle(RendererModel modelRenderer, float x, float y, float z) {
        float offX = modelRenderer.field_82906_o;
        float offY = modelRenderer.field_82908_p;
        float offZ = modelRenderer.field_82907_q;
        this.resetFunctions.add(() -> {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
            modelRenderer.field_82906_o = offX;
            modelRenderer.field_82908_p = offY;
            modelRenderer.field_82907_q = offZ;
        });
    }

    private void resetModel() {
        this.resetFunctions.forEach(Runnable::run);
    }
}

