/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import vazkii.quark.base.block.QuarkGlassBlock;
import vazkii.quark.base.module.Module;
import vazkii.quark.world.module.underground.CaveCrystalUndergroundBiomeModule;

public class CaveCrystalBlock
extends QuarkGlassBlock {
    private final float[] colorComponents;
    private final Vec3d colorVector;

    public CaveCrystalBlock(String regname, int color, Module module, MaterialColor materialColor) {
        super(regname, module, ItemGroup.field_78031_c, Block.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)materialColor).func_200948_a(0.3f, 0.0f).func_200947_a(SoundType.field_185853_f).func_200951_a(11).harvestTool(ToolType.PICKAXE).harvestLevel(0).func_200944_c());
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.colorComponents = new float[]{r, g, b};
        this.colorVector = new Vec3d((double)r, (double)g, (double)b);
    }

    private boolean canGrow(World world, BlockPos pos) {
        if (CaveCrystalUndergroundBiomeModule.caveCrystalGrowthChance >= 1 && pos.func_177956_o() < 24 && world.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (world.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            return i < 4;
        }
        return false;
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (this.canGrow(worldIn, pos) && random.nextInt(CaveCrystalUndergroundBiomeModule.caveCrystalGrowthChance) == 0) {
            worldIn.func_175656_a(pos.func_177984_a(), state);
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.canGrow(worldIn, pos)) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble();
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197608_a, d0, d1, d2, (double)this.colorComponents[0], (double)this.colorComponents[1], (double)this.colorComponents[2]);
        }
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        return this.colorComponents;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d getFogColor(BlockState state, IWorldReader world, BlockPos pos, Entity entity, Vec3d originalColor, float partialTicks) {
        return this.colorVector;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }
}

