/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.world.entity.StonelingEntity;

public class RunAndPoofGoal<T extends Entity>
extends Goal {
    private final Predicate<Entity> canBeSeenSelector = target -> target != null && target.func_70089_S() && entity.func_70635_at().func_75522_a(target) && !entity.func_184191_r((Entity)target);
    protected StonelingEntity entity;
    private final double farSpeed;
    private final double nearSpeed;
    protected T closestLivingEntity;
    private final float avoidDistance;
    private Path path;
    private final PathNavigator navigation;
    private final Class<T> classToAvoid;
    private final Predicate<T> avoidTargetSelector;

    public RunAndPoofGoal(StonelingEntity entity, Class<T> classToAvoid, float avoidDistance, double farSpeed, double nearSpeed) {
        this(entity, classToAvoid, t -> true, avoidDistance, farSpeed, nearSpeed);
    }

    public RunAndPoofGoal(StonelingEntity entity, Class<T> classToAvoid, Predicate<T> avoidTargetSelector, float avoidDistance, double farSpeed, double nearSpeed) {
        this.entity = entity;
        this.classToAvoid = classToAvoid;
        this.avoidTargetSelector = avoidTargetSelector;
        this.avoidDistance = avoidDistance;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        this.navigation = entity.func_70661_as();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (this.entity.isPlayerMade() || !this.entity.isStartled()) {
            return false;
        }
        List entities = this.entity.field_70170_p.func_175647_a(this.classToAvoid, this.entity.func_174813_aQ().func_72314_b((double)this.avoidDistance, 3.0, (double)this.avoidDistance), entity -> EntityPredicates.field_188444_d.test(entity) && this.canBeSeenSelector.test((Entity)entity) && this.avoidTargetSelector.test((Entity)entity));
        if (entities.isEmpty()) {
            return false;
        }
        this.closestLivingEntity = (Entity)entities.get(0);
        Vec3d target = RandomPositionGenerator.func_75461_b((CreatureEntity)this.entity, (int)16, (int)7, (Vec3d)this.closestLivingEntity.func_174791_d());
        if (target != null && this.closestLivingEntity.func_70092_e(target.field_72450_a, target.field_72448_b, target.field_72449_c) < this.closestLivingEntity.func_70068_e((Entity)this.entity)) {
            return false;
        }
        if (target != null) {
            this.path = this.navigation.func_225466_a(target.field_72450_a, target.field_72448_b, target.field_72449_c, 0);
        }
        return target == null || this.path != null;
    }

    public boolean func_75253_b() {
        if (this.path == null || this.navigation.func_75500_f()) {
            return false;
        }
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int i = 0; i < 8; ++i) {
            int j = MathHelper.func_76128_c((double)(this.entity.field_70163_u + (double)(((float)(i % 2) - 0.5f) * 0.1f) + (double)this.entity.func_70047_e()));
            int k = MathHelper.func_76128_c((double)(this.entity.field_70165_t + (double)(((float)((i >> 1) % 2) - 0.5f) * this.entity.func_213311_cf() * 0.8f)));
            int l = MathHelper.func_76128_c((double)(this.entity.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * this.entity.func_213311_cf() * 0.8f)));
            if (pos.func_177958_n() == k && pos.func_177956_o() == j && pos.func_177952_p() == l) continue;
            pos.func_181079_c(k, j, l);
            if (!this.entity.field_70170_p.func_180495_p((BlockPos)pos).func_185904_a().func_76230_c()) continue;
            pos.close();
            return false;
        }
        pos.close();
        return true;
    }

    public void func_75249_e() {
        if (this.path != null) {
            this.navigation.func_75484_a(this.path, this.farSpeed);
        }
        this.entity.field_70170_p.func_184148_a(null, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, QuarkSounds.ENTITY_STONELING_MEEP, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public void func_75251_c() {
        this.closestLivingEntity = null;
        World world = this.entity.field_70170_p;
        if (world instanceof ServerWorld) {
            ServerWorld ws = (ServerWorld)world;
            ws.func_195598_a((IParticleData)ParticleTypes.field_197613_f, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 40, 0.5, 0.5, 0.5, 0.1);
            ws.func_195598_a((IParticleData)ParticleTypes.field_197627_t, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 20, 0.5, 0.5, 0.5, 0.0);
        }
        for (Entity passenger : this.entity.func_184182_bu()) {
            if (passenger instanceof PlayerEntity) continue;
            passenger.func_70106_y();
        }
        this.entity.func_70106_y();
    }

    public void func_75246_d() {
        if (this.entity.func_70068_e((Entity)this.closestLivingEntity) < 49.0) {
            this.entity.func_70661_as().func_75489_a(this.nearSpeed);
        } else {
            this.entity.func_70661_as().func_75489_a(this.farSpeed);
        }
    }
}

