/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.proxy;

import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.base.capability.CapabilityHandler;
import vazkii.quark.base.handler.BrewingHandler;
import vazkii.quark.base.handler.ContributorRewardHandler;
import vazkii.quark.base.handler.FuelHandler;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.handler.StonecutterShiftClickHandler;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.recipe.ExclusionRecipe;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.base.world.WorldGenHandler;

public class CommonProxy {
    private int lastConfigChange = 0;

    public void start() {
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)ExclusionRecipe.SERIALIZER);
        QuarkSounds.start();
        ModuleLoader.INSTANCE.start();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        this.registerListeners(bus);
    }

    public void registerListeners(IEventBus bus) {
        bus.addListener(this::setup);
        bus.addListener(this::loadComplete);
        bus.addListener(this::configChanged);
    }

    public void setup(FMLCommonSetupEvent event) {
        QuarkNetwork.setup();
        BrewingHandler.setup();
        CapabilityHandler.setup();
        EntitySpawnHandler.refresh();
        ModuleLoader.INSTANCE.setup();
        this.initContributorRewards();
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        ModuleLoader.INSTANCE.loadComplete();
        WorldGenHandler.loadComplete();
        FuelHandler.addAllWoods();
    }

    public void configChanged(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getModId().equals("quark") && ClientTicker.ticksInGame - this.lastConfigChange > 10) {
            this.lastConfigChange = ClientTicker.ticksInGame;
            this.handleQuarkConfigChange();
            EntitySpawnHandler.refresh();
            StonecutterShiftClickHandler.configReload();
        }
    }

    public void handleQuarkConfigChange() {
        ModuleLoader.INSTANCE.configChanged();
    }

    protected void initContributorRewards() {
        ContributorRewardHandler.init();
    }
}

