/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.MiscUtil;

public final class OverrideRegistryHandler {
    public static void registerBlock(Block block, String baseName) {
        OverrideRegistryHandler.register(block, Blocks.class, baseName);
    }

    public static void registerItem(Item item, String baseName) {
        OverrideRegistryHandler.register(item, Items.class, baseName);
    }

    public static void registerBiome(Biome item, String baseName) {
        OverrideRegistryHandler.register(item, Biomes.class, baseName);
    }

    public static <T extends ForgeRegistryEntry<T>> void register(T obj, Class<?> registryType, String baseName) {
        ResourceLocation regName = new ResourceLocation("minecraft", baseName);
        try {
            Field field = ForgeRegistryEntry.class.getDeclaredField("registryName");
            field.setAccessible(true);
            field.set(obj, regName);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            obj.setRegistryName(regName);
        }
        RegistryHelper.register(obj);
        for (Field declared : registryType.getDeclaredFields()) {
            if (!Modifier.isStatic(declared.getModifiers()) || !obj.getClass().isAssignableFrom(declared.getType())) continue;
            try {
                Map itemMap;
                IForgeRegistryEntry fieldVal = (IForgeRegistryEntry)declared.get(null);
                if (!regName.equals((Object)fieldVal.getRegistryName())) continue;
                if (obj instanceof Block && fieldVal instanceof Block) {
                    itemMap = GameData.getBlockItemMap();
                    itemMap.put((Block)obj, itemMap.get(fieldVal));
                } else if (obj instanceof BlockItem) {
                    itemMap = GameData.getBlockItemMap();
                    itemMap.put(((BlockItem)obj).func_179223_d(), (Item)obj);
                }
                MiscUtil.editFinalField(declared, null, obj);
            }
            catch (IllegalAccessException e) {
                Quark.LOG.warn("Was unable to replace registry entry for " + regName + ", may cause issues", (Throwable)e);
            }
        }
    }
}

