/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import vazkii.quark.base.client.screen.QButtonInfoScreen;
import vazkii.quark.base.handler.ContributorRewardHandler;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.handler.MiscUtil;

@Mod.EventBusSubscriber(modid="quark", value={Dist.CLIENT})
public class QButtonHandler {
    @SubscribeEvent
    public static void onGuiInit(GuiScreenEvent.InitGuiEvent event) {
        Screen gui = event.getGui();
        if (GeneralConfig.enableQButton && (gui instanceof MainMenuScreen || gui instanceof IngameMenuScreen)) {
            ImmutableSet targets = GeneralConfig.qButtonOnRight ? ImmutableSet.of((Object)I18n.func_135052_a((String)"fml.menu.modoptions", (Object[])new Object[0]), (Object)I18n.func_135052_a((String)"menu.online", (Object[])new Object[0]).replace("Minecraft", "").trim()) : ImmutableSet.of((Object)I18n.func_135052_a((String)"menu.options", (Object[])new Object[0]), (Object)I18n.func_135052_a((String)"fml.menu.mods", (Object[])new Object[0]));
            List widgets = event.getWidgetList();
            for (Widget b : widgets) {
                if (!targets.contains((Object)b.getMessage())) continue;
                QButton qButton = new QButton(b.x + (GeneralConfig.qButtonOnRight ? 103 : -24), b.y);
                event.addWidget((Widget)qButton);
                return;
            }
        }
    }

    public static void openFile() {
        Util.func_110647_a().func_195641_a(FMLPaths.CONFIGDIR.get().toFile());
    }

    private static class QButton
    extends Button {
        public QButton(int x, int y) {
            super(x, y, 20, 20, "q", QButton::click);
        }

        public int getFGColor() {
            return 4775356;
        }

        public void renderButton(int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            super.renderButton(p_renderButton_1_, p_renderButton_2_, p_renderButton_3_);
            if (ContributorRewardHandler.localPatronTier > 0) {
                GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                int tier = Math.min(4, ContributorRewardHandler.localPatronTier);
                int u = 256 - tier * 9;
                int v = 26;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(MiscUtil.GENERAL_ICONS);
                this.blit(this.x - 2, this.y - 2, u, v, 9, 9);
            }
        }

        public static void click(Button b) {
            Minecraft.func_71410_x().func_147108_a((Screen)new QButtonInfoScreen(Minecraft.func_71410_x().field_71462_r));
        }
    }
}

