/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.block;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.module.Module;

public class QuarkStairsBlock
extends StairsBlock
implements IQuarkBlock,
IBlockColorProvider {
    private final IQuarkBlock parent;
    private BooleanSupplier enabledSupplier = () -> true;

    public QuarkStairsBlock(IQuarkBlock parent) {
        super(() -> ((Block)parent.getBlock()).func_176223_P(), Block.Properties.func_200950_a((Block)parent.getBlock()));
        this.parent = parent;
        RegistryHelper.registerBlock((Block)this, (String)(Objects.toString(parent.getBlock().getRegistryName()) + "_stairs"));
        RegistryHelper.setCreativeTab((Block)this, (ItemGroup)ItemGroup.field_78030_b);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78027_g || this.isEnabled()) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.parent.getModule();
    }

    @Override
    public QuarkStairsBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        return this.parent.getBlock().getBeaconColorMultiplier(this.parent.getBlock().func_176223_P(), world, pos, beaconPos);
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return this.parent.getBlock().func_180664_k();
    }

    public int func_220058_a(BlockState state, IEnviromentBlockReader worldIn, BlockPos pos) {
        return this.parent.getBlock().func_220058_a(state, worldIn, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBlockColor getBlockColor() {
        return this.parent instanceof IBlockColorProvider ? ((IBlockColorProvider)this.parent).getBlockColor() : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IItemColor getItemColor() {
        return this.parent instanceof IItemColorProvider ? ((IItemColorProvider)this.parent).getItemColor() : null;
    }
}

