/*
 * Decompiled with CFR 0.152.
 */
package com.cscot.basicnetherores.util.handler;

import com.cscot.basicnetherores.BasicNetherOres;
import com.cscot.basicnetherores.lists.BlockList;
import com.cscot.basicnetherores.lists.BlockOreList;
import com.cscot.basicnetherores.lists.IngotList;
import com.cscot.basicnetherores.lists.ItemList;
import com.cscot.basicnetherores.util.helpers.BlockListHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegisteryHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"bno");

    public static void ProtectedListInit() {
        BlockListHelper.initProtectedBlocks();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onOreRegistry(RegistryEvent.Register<Block> oreRegistryEvent) {
            for (Block block : BlockOreList.blockores) {
                oreRegistryEvent.getRegistry().register((IForgeRegistryEntry)block);
            }
            LOGGER.info("Ore Blocks Registered");
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> itemRegisterEvent) {
            for (Item item : ItemList.items) {
                itemRegisterEvent.getRegistry().register((IForgeRegistryEntry)item);
            }
            LOGGER.info("ItemBlocks Registered");
        }

        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            for (Block block : BlockList.blocks) {
                blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)block);
            }
            LOGGER.info("Blocks Registered");
        }

        @SubscribeEvent
        public static void onIngotRegistry(RegistryEvent.Register<Item> ingotRegistryEvent) {
            ingotRegistryEvent.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{IngotList.aluminum_ingot = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("aluminum_ingot")), IngotList.copper_ingot = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("copper_ingot")), IngotList.lead_ingot = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("lead_ingot")), IngotList.nickel_ingot = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("nickel_ingot")), IngotList.silver_ingot = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("silver_ingot")), IngotList.tin_ingot = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("tin_ingot")), IngotList.uranium_ingot = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("uranium_ingot")), IngotList.aluminum_nugget = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("aluminum_nugget")), IngotList.copper_nugget = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("copper_nugget")), IngotList.lead_nugget = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("lead_nugget")), IngotList.nickel_nugget = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("nickel_nugget")), IngotList.silver_nugget = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("silver_nugget")), IngotList.tin_nugget = (Item)new Item(new Item.Properties().func_200916_a(BasicNetherOres.bnoItemGroup)).setRegistryName(RegistryEvents.location("tin_nugget"))});
            LOGGER.info("Ingots Registered");
        }

        public static ResourceLocation location(String name) {
            return new ResourceLocation("bno", name);
        }
    }
}

