/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoulJarItem
extends BaseItem {
    public SoulJarItem(Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.func_200917_a(1)));
        this.func_185043_a(new ResourceLocation("fill"), (stack, world, entity) -> {
            double souls;
            IMobSoulType type = MobSoulUtils.getType(stack);
            if (type != null && (souls = MobSoulUtils.getSouls(stack)) > 0.0) {
                return (int)(souls / type.getSoulRequirement() * 9.0);
            }
            return 0.0f;
        });
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            MobSoulTypeRegistry.getInstance().getMobSoulTypes().forEach(type -> items.add((Object)MobSoulUtils.getFilledSoulJar(type)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        IMobSoulType type = MobSoulUtils.getType(stack);
        if (type != null) {
            ITextComponent entityName = type.getEntityDisplayName();
            double souls = MobSoulUtils.getSouls(stack);
            tooltip.add(ModTooltips.SOUL_JAR.args(new Object[]{entityName, souls, type.getSoulRequirement()}).build());
        }
    }
}

