/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.handler;

import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.block.InfusedFarmlandBlock;
import com.blakebr0.mysticalagriculture.item.ModItems;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.util.IItemProvider;

public class ColorHandler {
    public static void onClientSetup() {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockColors blockColors = minecraft.func_184125_al();
        ItemColors itemColors = minecraft.getItemColors();
        ColorHandler.onBlockColors(blockColors);
        ColorHandler.onItemColors(itemColors);
    }

    private static void onBlockColors(BlockColors colors) {
        colors.func_186722_a((IBlockColor)new IColored.BlockColors(), (Block[])InfusedFarmlandBlock.FARMLANDS.toArray(new InfusedFarmlandBlock[0]));
        CropRegistry.getInstance().getCrops().forEach(crop -> {
            if (crop.isFlowerColored() && crop.getCrop() != null) {
                colors.func_186722_a((state, world, pos, tint) -> crop.getFlowerColor(), new Block[]{crop.getCrop()});
            }
        });
    }

    private static void onItemColors(ItemColors colors) {
        colors.func_199877_a((IItemColor)new IColored.ItemBlockColors(), (IItemProvider[])InfusedFarmlandBlock.FARMLANDS.toArray(new InfusedFarmlandBlock[0]));
        colors.func_199877_a((stack, tint) -> {
            float damage = (float)(stack.func_77958_k() - stack.func_77952_i()) / (float)stack.func_77958_k();
            return Utils.saturate((int)55769, (float)damage);
        }, new IItemProvider[]{(IItemProvider)ModItems.INFUSION_CRYSTAL.get()});
        colors.func_199877_a((stack, tint) -> ModCrops.AIR.getEssenceColor(), new IItemProvider[]{(IItemProvider)ModItems.AIR_AGGLOMERATIO.get()});
        colors.func_199877_a((stack, tint) -> ModCrops.EARTH.getEssenceColor(), new IItemProvider[]{(IItemProvider)ModItems.EARTH_AGGLOMERATIO.get()});
        colors.func_199877_a((stack, tint) -> ModCrops.WATER.getEssenceColor(), new IItemProvider[]{(IItemProvider)ModItems.WATER_AGGLOMERATIO.get()});
        colors.func_199877_a((stack, tint) -> ModCrops.FIRE.getEssenceColor(), new IItemProvider[]{(IItemProvider)ModItems.FIRE_AGGLOMERATIO.get()});
        colors.func_199877_a((stack, tint) -> {
            IMobSoulType type = MobSoulUtils.getType(stack);
            return tint == 1 && type != null ? type.getColor() : -1;
        }, new IItemProvider[]{(IItemProvider)ModItems.SOUL_JAR.get()});
        CropRegistry.getInstance().getCrops().forEach(crop -> {
            if (crop.isEssenceColored() && crop.getEssence() != null) {
                colors.func_199877_a((stack, tint) -> crop.getEssenceColor(), new IItemProvider[]{crop.getEssence()});
            }
            if (crop.isSeedColored() && crop.getSeeds() != null) {
                colors.func_199877_a((stack, tint) -> crop.getSeedColor(), new IItemProvider[]{crop.getSeeds()});
            }
        });
        AugmentRegistry.getInstance().getAugments().forEach(augment -> {
            if (augment.getItem() != null) {
                colors.func_199877_a((stack, tint) -> tint == 0 ? augment.getSecondaryColor() : (tint == 1 ? augment.getPrimaryColor() : -1), new IItemProvider[]{augment.getItem()});
            }
        });
    }
}

