/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client;

import com.blakebr0.cucumber.model.RetextureableBlockModelWrapper;
import com.blakebr0.cucumber.model.RetextureableItemModelWrapper;
import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModelHandler {
    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent event) {
        for (int i = 0; i < 8; ++i) {
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", "block/mystical_resource_crop_" + i));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", "block/mystical_mob_crop_" + i));
        }
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", "item/mystical_essence"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", "item/mystical_seeds"));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        Map registry = event.getModelRegistry();
        IBakedModel[] resourceCropModels = new IBakedModel[8];
        IBakedModel[] mobCropModels = new IBakedModel[8];
        for (int i = 0; i < 7; ++i) {
            resourceCropModels[i] = (IBakedModel)registry.get(new ResourceLocation("mysticalagriculture", "block/mystical_resource_crop_" + i));
            mobCropModels[i] = (IBakedModel)registry.get(new ResourceLocation("mysticalagriculture", "block/mystical_mob_crop_" + i));
        }
        ModelLoader bakery = event.getModelLoader();
        Function<ResourceLocation, TextureAtlasSprite> getSprite = arg_0 -> ((AtlasTexture)Minecraft.func_71410_x().func_147117_R()).func_195424_a(arg_0);
        ItemModelGenerator generator = new ItemModelGenerator();
        IUnbakedModel resourceCropModel = bakery.func_209597_a(new ResourceLocation("mysticalagriculture", "block/mystical_resource_crop_7"));
        RetextureableBlockModelWrapper resourceCropModelWrapper = new RetextureableBlockModelWrapper((BlockModel)resourceCropModel);
        IUnbakedModel mobCropModel = bakery.func_209597_a(new ResourceLocation("mysticalagriculture", "block/mystical_mob_crop_7"));
        RetextureableBlockModelWrapper mobCropModelWrapper = new RetextureableBlockModelWrapper((BlockModel)mobCropModel);
        IUnbakedModel essenceModel = bakery.func_209597_a(new ResourceLocation("mysticalagriculture", "item/mystical_essence"));
        RetextureableItemModelWrapper essenceModelWrapper = new RetextureableItemModelWrapper((BlockModel)essenceModel);
        IUnbakedModel seedsModel = bakery.func_209597_a(new ResourceLocation("mysticalagriculture", "item/mystical_seeds"));
        RetextureableItemModelWrapper seedsModelWrapper = new RetextureableItemModelWrapper((BlockModel)seedsModel);
        registry.forEach((arg_0, arg_1) -> ModelHandler.lambda$onModelBake$0((IUnbakedModel)mobCropModelWrapper, (IUnbakedModel)resourceCropModelWrapper, (ModelBakery)bakery, getSprite, registry, mobCropModels, resourceCropModels, (IUnbakedModel)essenceModelWrapper, generator, (IUnbakedModel)seedsModelWrapper, arg_0, arg_1));
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().getBasePath().equals("textures")) {
            CropRegistry.getInstance().getCrops().forEach(crop -> {
                CropTextures textures = crop.getTextures();
                event.addSprite(textures.getFlowerTexture());
                event.addSprite(textures.getEssenceTexture());
                event.addSprite(textures.getSeedTexture());
            });
        }
    }

    private static /* synthetic */ void lambda$onModelBake$0(IUnbakedModel mobCropModelWrapper, IUnbakedModel resourceCropModelWrapper, ModelBakery bakery, Function getSprite, Map registry, IBakedModel[] mobCropModels, IBakedModel[] resourceCropModels, IUnbakedModel essenceModelWrapper, ItemModelGenerator generator, IUnbakedModel seedsModelWrapper, ResourceLocation location, IBakedModel model) {
        if (location.func_110624_b().equals("mysticalagriculture")) {
            ResourceLocation texture;
            ICrop crop;
            if (location.func_110623_a().endsWith("_crop")) {
                try {
                    int i = Integer.parseInt(((ModelResourceLocation)location).func_177518_c().substring(4));
                    String name = location.func_110623_a().replace("_crop", "");
                    ICrop crop2 = CropRegistry.getInstance().getCropByName(name);
                    if (crop2 != null) {
                        if (i == 7) {
                            ResourceLocation texture2 = crop2.getTextures().getFlowerTexture();
                            IUnbakedModel cropRetexturedModel = crop2.getType() == CropType.MOB ? (IUnbakedModel)mobCropModelWrapper.retexture(ImmutableMap.of((Object)"flower", (Object)texture2.toString())) : (IUnbakedModel)resourceCropModelWrapper.retexture(ImmutableMap.of((Object)"flower", (Object)texture2.toString()));
                            IBakedModel cropBakedModel = cropRetexturedModel.bake(bakery, getSprite, (ISprite)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b);
                            registry.replace(location, cropBakedModel);
                        } else if (crop2.getType() == CropType.MOB) {
                            registry.replace(location, mobCropModels[i]);
                        } else {
                            registry.replace(location, resourceCropModels[i]);
                        }
                    }
                }
                catch (NumberFormatException i) {
                    // empty catch block
                }
            }
            if (location.func_110623_a().endsWith("_essence") && !location.func_110623_a().contains("ium")) {
                String name = location.func_110623_a().replace("_essence", "");
                crop = CropRegistry.getInstance().getCropByName(name);
                if (crop != null) {
                    texture = crop.getTextures().getEssenceTexture();
                    IUnbakedModel essenceRetexturedModel = (IUnbakedModel)essenceModelWrapper.retexture(ImmutableMap.of((Object)"layer0", (Object)texture.toString()));
                    BlockModel essenceUnbakedModel = generator.func_209579_a(getSprite, (BlockModel)essenceRetexturedModel);
                    IBakedModel essenceBakedModel = essenceUnbakedModel.bake(bakery, getSprite, (ISprite)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b);
                    registry.replace(location, essenceBakedModel);
                }
            }
            if (location.func_110623_a().endsWith("_seeds")) {
                String name = location.func_110623_a().replace("_seeds", "");
                crop = CropRegistry.getInstance().getCropByName(name);
                if (crop != null) {
                    texture = crop.getTextures().getSeedTexture();
                    IUnbakedModel seedsRetexturedModel = (IUnbakedModel)seedsModelWrapper.retexture(ImmutableMap.of((Object)"layer0", (Object)texture.toString()));
                    BlockModel seedsUnbakedModel = generator.func_209579_a(getSprite, (BlockModel)seedsRetexturedModel);
                    IBakedModel seedsBakedModel = seedsUnbakedModel.bake(bakery, getSprite, (ISprite)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b);
                    registry.replace(location, seedsBakedModel);
                }
            }
        }
    }
}

