/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.crop;

import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.CropsBlock;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public class Crop
implements ICrop {
    private final ResourceLocation id;
    private CropTier tier;
    private CropType type;
    private int flowerColor;
    private int essenceColor;
    private int seedColor;
    private CropTextures textures;
    private Supplier<? extends CropsBlock> crop;
    private Supplier<? extends Item> essence;
    private Supplier<? extends BlockNamedItem> seeds;
    private Supplier<? extends Block> crux;
    private LazyIngredient craftingMaterial;
    private boolean enabled;
    private boolean registerCropBlock;
    private boolean registerEssenceItem;
    private boolean registerSeedsItem;

    public Crop(ResourceLocation id, CropTier tier, CropType type, LazyIngredient craftingMaterial) {
        this(id, tier, type, new CropTextures(), craftingMaterial);
    }

    public Crop(ResourceLocation id, CropTier tier, CropType type, int color, LazyIngredient craftingMaterial) {
        this(id, tier, type, new CropTextures(), color, craftingMaterial);
    }

    public Crop(ResourceLocation id, CropTier tier, CropType type, CropTextures textures, LazyIngredient craftingMaterial) {
        this(id, tier, type, textures, -1, craftingMaterial);
    }

    public Crop(ResourceLocation id, CropTier tier, CropType type, CropTextures textures, int color, LazyIngredient craftingMaterial) {
        this.id = id;
        this.tier = tier;
        this.type = type;
        this.textures = textures.init(id);
        this.setColor(color);
        this.craftingMaterial = craftingMaterial;
        this.enabled = true;
        this.registerCropBlock = true;
        this.registerEssenceItem = true;
        this.registerSeedsItem = true;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public CropTier getTier() {
        return this.tier;
    }

    @Override
    public CropType getType() {
        return this.type;
    }

    @Override
    public int getFlowerColor() {
        return this.flowerColor;
    }

    public Crop setFlowerColor(int color) {
        this.flowerColor = color;
        return this;
    }

    @Override
    public CropTextures getTextures() {
        return this.textures;
    }

    @Override
    public int getEssenceColor() {
        return this.essenceColor;
    }

    public Crop setEssenceColor(int color) {
        this.essenceColor = color;
        return this;
    }

    @Override
    public int getSeedColor() {
        return this.seedColor;
    }

    public Crop setSeedColor(int color) {
        this.seedColor = color;
        return this;
    }

    public Crop setColor(int color) {
        this.setFlowerColor(color);
        this.setEssenceColor(color);
        this.setSeedColor(color);
        return this;
    }

    @Override
    public CropsBlock getCrop() {
        return this.crop == null ? null : this.crop.get();
    }

    @Override
    public ICrop setCrop(Supplier<? extends CropsBlock> crop, boolean register) {
        this.crop = crop;
        this.registerCropBlock = register;
        return this;
    }

    @Override
    public boolean getRegisterCropBlock() {
        return this.registerCropBlock;
    }

    @Override
    public Item getEssence() {
        return this.essence == null ? null : this.essence.get();
    }

    @Override
    public ICrop setEssence(Supplier<? extends Item> essence, boolean register) {
        this.essence = essence;
        this.registerEssenceItem = register;
        return this;
    }

    @Override
    public boolean getRegisterEssenceItem() {
        return this.registerEssenceItem;
    }

    @Override
    public BlockNamedItem getSeeds() {
        return this.seeds == null ? null : this.seeds.get();
    }

    @Override
    public ICrop setSeeds(Supplier<? extends BlockNamedItem> seeds, boolean register) {
        this.seeds = seeds;
        this.registerSeedsItem = register;
        return this;
    }

    @Override
    public boolean getRegisterSeedsItem() {
        return this.registerSeedsItem;
    }

    @Override
    public Ingredient getCraftingMaterial() {
        return this.craftingMaterial.getIngredient();
    }

    @Override
    public ICrop setCraftingMaterial(LazyIngredient ingredient) {
        this.craftingMaterial = ingredient;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Block getCrux() {
        return this.crux == null ? null : this.crux.get();
    }

    @Override
    public ICrop setCrux(Supplier<? extends Block> crux) {
        this.crux = crux;
        return this;
    }
}

