/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods;

import com.endertech.common.CommonString;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.ore.Deposit;
import com.endertech.minecraft.mods.adlods.ore.DepositGenResult;
import com.endertech.minecraft.mods.adlods.ore.Stripper;
import com.endertech.minecraft.mods.adlods.world.WorldData;
import java.io.File;
import java.nio.file.Path;
import java.util.StringJoiner;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public final class Commands {
    public static void listDeposits(ServerCommand.Context context) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Deposit deposit : AdLods.getGenerator().getDeposits()) {
            joiner.add(deposit.getName());
        }
        context.sendMessage(joiner.toString());
    }

    public static void listGenerated(ServerCommand.Context context) {
        Logger logger = AdLods.getInstance().getLogger();
        logger.info("Deposits: {");
        for (DepositGenResult result : WorldData.getData((IWorld)context.getWorld()).getGeneratedDeposits().values()) {
            logger.info("\t" + result);
        }
        logger.info("}");
        context.sendMessage("List of generated deposits was written to the log");
    }

    public static void addDeposit(ServerCommand.Context context) {
        String name;
        Path baseDir = AdLods.getGenerator().getConfigsDir();
        File configFile = UnitConfig.buildPath((Path)baseDir, (String)(name = Commands.getDepositName(context))).toFile();
        if (configFile.isFile()) {
            context.sendMessage("Config file <" + configFile.getName() + "> already exists!");
            return;
        }
        Deposit deposit = AdLods.getGenerator().findDepositBy(name);
        if (deposit != null) {
            String fileName = deposit.getConfig().getConfigFile().getName();
            context.sendMessage("Deposit with this name already defined in: " + fileName);
            return;
        }
        int rarity = (Integer)context.getArgument("rarity", Integer.TYPE);
        Deposit.Size size = Deposit.Size.from((IntBounds)context.getArgument("size", IntBounds.class));
        Deposit.Altitude altitude = Deposit.Altitude.from((IntBounds)context.getArgument("altitude", IntBounds.class));
        Deposit deposit2 = AdLods.getGenerator().createDeposit(baseDir, name, size, altitude, rarity);
        context.sendMessage("Deposit config created");
        if (!deposit2.isValid()) {
            context.sendMessage("Deposit is not valid! Check its parameters");
        }
        if (AdLods.getGenerator().addDeposit(deposit2)) {
            context.sendMessage("Deposit definition successfully added");
        }
    }

    public static void removeDeposit(ServerCommand.Context context) {
        Path baseDir = AdLods.getGenerator().getConfigsDir();
        String name = Commands.getDepositName(context);
        File configFile = UnitConfig.buildPath((Path)baseDir, (String)name).toFile();
        Deposit deposit = AdLods.getGenerator().findDepositBy(name);
        if (deposit != null) {
            if (AdLods.getGenerator().removeDeposit(deposit)) {
                context.sendMessage("Deposit definition removed");
            }
            configFile = deposit.getConfig().getConfigFile();
        }
        if (configFile.delete()) {
            context.sendMessage("Deposit config removed");
        }
    }

    public static void generateDeposit(ServerCommand.Context context) {
        BlockPos startPos = context.getBlockPos();
        ChunkPos chunkPos = new ChunkPos(startPos);
        Commands.generateDepositAt(context, chunkPos);
    }

    public static void generateDepositAt(ServerCommand.Context context) {
        int x = (Integer)context.getArgument("chunkX", Integer.TYPE);
        int z = (Integer)context.getArgument("chunkZ", Integer.TYPE);
        ChunkPos chunkPos = new ChunkPos(x, z);
        Commands.generateDepositAt(context, chunkPos);
    }

    static void generateDepositAt(ServerCommand.Context context, ChunkPos chunkPos) {
        String name = Commands.getDepositName(context);
        Deposit deposit = AdLods.getGenerator().findDepositBy(name);
        if (deposit != null) {
            if (context.getWorld().func_217354_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
                DepositGenResult result = deposit.generateAt((IWorld)context.getWorld(), chunkPos);
                context.sendMessage(result.toString());
            } else {
                context.sendMessage(BlockPosArgument.field_197278_b.toString());
            }
        } else {
            context.sendMessage(Commands.depositNotFoundMsg(name));
        }
    }

    public static void testDeposit(ServerCommand.Context context) {
        String name = Commands.getDepositName(context);
        Deposit deposit = AdLods.getGenerator().findDepositBy(name);
        if (deposit != null) {
            BlockPos startPos = context.getBlockPos();
            int amount = (Integer)context.getArgument("amount", Integer.TYPE);
            DepositGenResult result = deposit.generateAt((IWorld)context.getWorld(), startPos, amount, true);
            context.sendMessage(result.toString());
        } else {
            context.sendMessage(Commands.depositNotFoundMsg(name));
        }
    }

    public static void reloadConfigs(ServerCommand.Context context) {
        AdLods.getGenerator().loadDeposits();
        AdLods.getController().loadOres();
        context.sendMessage("Configs reloaded");
    }

    public static void stripChunk(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        Stripper stripper = Stripper.getFor((World)context.getWorld());
        stripper.stripChunk((World)context.getWorld(), centerPos, AdLods.getGenerator()::isOreBlock);
        context.sendMessage("Chunk at " + centerPos + " stripped");
    }

    public static void stripChunksAround(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        Stripper stripper = Stripper.getFor((World)context.getWorld());
        stripper.stripChunksAround((World)context.getWorld(), centerPos, AdLods.getGenerator()::isOreBlock);
        context.sendMessage("Chunks around " + centerPos + " stripped");
    }

    public static void dressChunk(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        Stripper stripper = Stripper.getFor((World)context.getWorld());
        stripper.dressChunk((World)context.getWorld(), centerPos);
        context.sendMessage("Chunk at " + centerPos + " dressed");
    }

    public static void dressChunksAround(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        Stripper stripper = Stripper.getFor((World)context.getWorld());
        stripper.dressChunksAround((World)context.getWorld(), centerPos);
        context.sendMessage("Chunks around " + centerPos + " dressed");
    }

    public static void dressAllChunks(ServerCommand.Context context) {
        Stripper stripper = Stripper.getFor((World)context.getWorld());
        stripper.dressAllChunks((World)context.getWorld());
        context.sendMessage("All stripped chunks dressed");
    }

    static String getDepositName(ServerCommand.Context context) {
        return (String)context.getArgument("deposit", String.class);
    }

    static String depositNotFoundMsg(String name) {
        return "Deposit with name " + CommonString.quoted((String)name) + " not found! Use </lods list> command.";
    }
}

