/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.mods.adlods.Commands;
import com.endertech.minecraft.mods.adlods.ore.Deposit;
import com.endertech.minecraft.mods.adlods.ore.Generator;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaGen;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="adlods")
public class AdLods
extends ForgeMod {
    public static final String ID = "adlods";
    public static final String NAME = "Large Ore Deposits";
    private static AdLods instance;
    private final Generator generator;
    private final VanillaGen controller;

    public AdLods() {
        instance = this;
        this.generator = new Generator(this);
        this.controller = new VanillaGen(this);
    }

    public static AdLods getInstance() {
        return instance;
    }

    public static Generator getGenerator() {
        return AdLods.getInstance().generator;
    }

    public static VanillaGen getController() {
        return AdLods.getInstance().controller;
    }

    public String getId() {
        return ID;
    }

    public void commonInit() {
        ForgeRegistries.BIOMES.forEach(this.generator::addToBiome);
    }

    public void commonPostInit() {
    }

    public void commonConfigInit(ForgeMod.ConfigValueBuilder value) {
    }

    public void clientConfigInit(ForgeMod.ConfigValueBuilder value) {
    }

    protected void serverStarting(MinecraftServer server) {
    }

    public void updateReloadedTags() {
        if (EffectiveSide.get().isServer()) {
            this.generator.loadDeposits();
            this.controller.loadOres();
        }
    }

    public void registerCommands(ServerCommand command) {
        String deposit = "deposit";
        command.requires(ServerCommand.OpLevel.NORMAL);
        command.task("list").executes(Commands::listDeposits, "deposits").executes(Commands::listGenerated, "generated");
        command.task("add").executes(Commands::addDeposit, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit"), ServerCommand.Arg.integer((String)"rarity", (IntBounds)Deposit.Rarity.BOUNDS), ServerCommand.Arg.bounds((String)"size", (IntBounds)Deposit.Size.BOUNDS), ServerCommand.Arg.bounds((String)"altitude", (IntBounds)Deposit.Altitude.BOUNDS)});
        command.task("remove").executes(Commands::removeDeposit, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit")});
        command.task("gen").executes(Commands::generateDeposit, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit")}).executes(Commands::generateDepositAt, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit"), ServerCommand.Arg.integer((String)"chunkX", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.integer((String)"chunkZ", (IntBounds)IntBounds.INTEGER)});
        command.task("test").executes(Commands::testDeposit, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit"), ServerCommand.Arg.integer((String)"amount", (IntBounds)Deposit.Size.BOUNDS)});
        command.task("reload").executes(Commands::reloadConfigs, new ServerCommand.Arg[0]);
        command.task("strip").executes(Commands::stripChunk, "chunk").executes(Commands::stripChunksAround, "around");
        command.task("dress").executes(Commands::dressChunk, "chunk").executes(Commands::dressChunksAround, "around").executes(Commands::dressAllChunks, "all");
        command.register();
    }

    public void registerBlocks() {
    }

    public void registerItems() {
    }

    public void registerEntities() {
    }

    public void registerTiles() {
    }
}

