/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.items;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeCacheCleaner;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.GlassMeter;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adfinders.AdFinders;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Renderer;
import com.endertech.minecraft.mods.adfinders.finder.Target;
import com.endertech.minecraft.mods.adfinders.init.FinderType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Finder
extends GlassMeter {
    public static final CommonTime.Interval UPDATE_INTERVAL = CommonTime.Interval.seconds((double)1.0);
    public static final CommonTime.Interval STATE_TTL = UPDATE_INTERVAL.mult(5.0);
    public static final IntBounds SEARCH_BOUNDS = new IntBounds(Integer.valueOf(1), Integer.valueOf(64));
    public static final int VERT_RANGE = 2;
    public static final float THICKNESS = 0.08f;
    protected final Map<Entity, FinderState> finderStates = new ConcurrentHashMap<Entity, FinderState>();
    protected final Map<String, List<Target>> targetGroups = new ConcurrentHashMap<String, List<Target>>();
    protected final List<Target> allTargets = new ArrayList<Target>();
    protected int scanRadius;
    protected int pingDepth;
    protected int veinMinSize;
    protected int depositMinSize;
    private Cleaner cleaner;

    public Finder(ForgeMod mod, UnitConfig config, String name, int scanRadius, int pingDepth, int veinMinSize, int depositMinSize, TextFormatting textFormatting) {
        super(mod, config, name, new Item.Properties().func_200916_a(ItemGroup.field_78040_i).setTEISR(() -> Renderer::new), 8, EquipmentSlotType.HEAD, textFormatting);
        this.scanRadius = UnitConfig.getInt((UnitConfig)config, (String)this.getUnitCategory(), (String)"scanRadius", (int)scanRadius, (IntBounds)SEARCH_BOUNDS, (String)"Defines how far from a player in horizontal plane the targets can be found.");
        this.pingDepth = UnitConfig.getInt((UnitConfig)config, (String)this.getUnitCategory(), (String)"pingDepth", (int)pingDepth, (IntBounds)SEARCH_BOUNDS, (String)"Defines how far from a player in vertical plane the ore vein can be found.");
        this.veinMinSize = UnitConfig.getInt((UnitConfig)config, (String)this.getUnitCategory(), (String)"veinMinSize", (int)veinMinSize, (IntBounds)SEARCH_BOUNDS, (String)"Defines the minimal size of an ore vein to be found.");
        this.depositMinSize = UnitConfig.getInt((UnitConfig)config, (String)this.getUnitCategory(), (String)"depositMinSize", (int)depositMinSize, (IntBounds)SEARCH_BOUNDS, (String)"Defines the minimal size of an ore deposit to get alarm.");
        this.func_185043_a(new ResourceLocation("broken"), (stack, world, entity) -> Finder.isBroken((ItemStack)stack) ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("alarmed"), (stack, world, entity) -> {
            FinderState state;
            if (Finder.notBroken((ItemStack)stack) && (state = Finder.findStateFor(stack)) != null && state.isDepositFound()) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    public static boolean stackHasFinder(ItemStack stack) {
        return stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof Finder;
    }

    protected void addTargets(Target ... targets) {
        for (Target target : targets) {
            this.addTarget(target);
        }
    }

    protected void addTarget(Target target) {
        if (target.exists()) {
            String name = target.getName();
            List<Target> group = this.targetGroups.get(name);
            if (group != null) {
                group.add(target);
            } else {
                group = new ArrayList<Target>();
                group.add(target);
                this.targetGroups.put(name, group);
            }
            this.allTargets.add(target);
        }
    }

    protected void addTargets(Collection<Target> targets) {
        for (Target target : targets) {
            this.addTarget(target);
        }
    }

    public void syncTargetsWith(String[] definitions) {
        this.allTargets.clear();
        this.targetGroups.clear();
        for (String definition : definitions) {
            Target target = Target.from(definition);
            this.addTarget(target);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        Hand hand = null;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (stack.equals(living.func_184614_ca())) {
                hand = Hand.MAIN_HAND;
            }
            if (stack.equals(living.func_184592_cb())) {
                hand = Hand.OFF_HAND;
            }
        }
        this.updateState(stack, entity, hand);
    }

    public void updateState(ItemStack stack, Entity entity, @Nullable Hand hand) {
        if (this.isClientSide((IWorldReader)entity.field_70170_p) && Finder.stackHasFinder(stack)) {
            if (Finder.notBroken((ItemStack)stack)) {
                FinderState state = Finder.findStateFor(stack);
                if (state == null) {
                    state = this.createStateFor(stack, entity);
                }
                if (state != null && state.needsUpdate()) {
                    state.update(entity);
                    if (hand != null && entity instanceof LivingEntity) {
                        FinderState.UpdateMsg message = new FinderState.UpdateMsg((LivingEntity)entity, hand);
                        AdFinders.getInstance().getConnection().sendToServer((Object)message);
                    }
                }
            }
            this.cleanOutdatedStates();
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        this.updateState(stack, (Entity)entity, null);
        return super.onEntityItemUpdate(stack, entity);
    }

    protected FinderState createStateFor(ItemStack stack, Entity carrier) {
        this.carriers.put(stack, carrier);
        FinderState state = new FinderState(Finder.getFinderItem(stack), carrier);
        this.finderStates.put(carrier, state);
        return state;
    }

    @Nullable
    public static FinderState findStateFor(ItemStack stack) {
        if (Finder.stackHasFinder(stack)) {
            Finder finder = Finder.getFinderItem(stack);
            Entity entity = (Entity)finder.carriers.get(stack);
            if (entity != null) {
                return finder.finderStates.get(entity);
            }
        }
        return null;
    }

    public static Finder getFinderItem(ItemStack stack) {
        return (Finder)stack.func_77973_b();
    }

    public int getScanRadius() {
        return this.scanRadius;
    }

    public int getPingDepth() {
        return this.pingDepth;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag flag) {
        FinderState state = Finder.findStateFor(stack);
        if (state != null) {
            GameSettings gs = GameKeys.getGameSettings();
            Tooltip tip = Tooltip.of((ForgeMod)AdFinders.getInstance(), (String)"finder", lines);
            if (GameKeys.isDown((KeyBinding)gs.field_151444_V)) {
                tip.add("needles", new Object[]{TextFormatting.RESET, TextFormatting.GREEN});
                tip.add("arrows", new Object[]{TextFormatting.RESET, TextFormatting.YELLOW});
                tip.add("red_lights", new Object[]{TextFormatting.RESET, TextFormatting.RED});
            } else {
                Finder finder = state.getFinder();
                tip.add(TextFormatting.GREEN, "scan_radius", (Object)finder.getScanRadius());
                tip.add(TextFormatting.YELLOW, "ping_depth", (Object)finder.getPingDepth());
                tip.add("more_info", new Object[]{TextFormatting.GRAY, TextFormatting.DARK_PURPLE, gs.field_151444_V.func_197978_k()});
            }
        }
        super.func_77624_a(stack, world, lines, flag);
    }

    public Map<String, List<Target>> getTargetGroups() {
        return Collections.unmodifiableMap(this.targetGroups);
    }

    public List<Target> getAllTargets() {
        return Collections.unmodifiableList(this.allTargets);
    }

    public Map<Entity, FinderState> getFinderStates() {
        return Collections.unmodifiableMap(this.finderStates);
    }

    public int getVeinMinSize() {
        return this.veinMinSize;
    }

    private void cleanOutdatedStates() {
        if (this.cleaner == null || this.cleaner.isTimeToRun()) {
            this.cleaner = new Cleaner(UPDATE_INTERVAL.mult(5.0));
        }
    }

    public int getDepositMinSize() {
        return this.depositMinSize;
    }

    public class Cleaner
    extends ForgeCacheCleaner {
        public Cleaner(CommonTime.Interval runInterval) {
            super(runInterval);
        }

        public void run() {
            Iterator<Object> iterator = Finder.this.finderStates.values().iterator();
            while (iterator.hasNext()) {
                FinderState state = iterator.next();
                if (state.isActual()) continue;
                iterator.remove();
            }
            iterator = Finder.this.carriers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ItemStack stack = (ItemStack)entry.getKey();
                Entity entity = (Entity)entry.getValue();
                if (!stack.func_190926_b() && ForgeEntity.hasStack((Entity)entity, (ItemStack)stack)) continue;
                iterator.remove();
            }
            iterator = Finder.this.carriers.values().iterator();
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                if (Finder.this.finderStates.get(entity) != null) continue;
                iterator.remove();
            }
        }
    }

    public static class SyncClientMsg
    extends ForgeNetMsg<SyncClientMsg> {
        private static final String KEY_DEFINITIONS = "Definitions";
        public FinderType type;
        public int scanRadius;
        public int pingDepth;
        public int veinMinSize;
        public int depositMinSize;
        public CompoundNBT compound;

        public SyncClientMsg() {
        }

        public SyncClientMsg(FinderType type) {
            this.type = type;
            this.scanRadius = type.finder.getScanRadius();
            this.pingDepth = type.finder.getPingDepth();
            this.veinMinSize = type.finder.getVeinMinSize();
            this.depositMinSize = type.finder.getDepositMinSize();
            this.compound = new CompoundNBT();
            ForgeNBT.putStringArray((CompoundNBT)this.compound, (String)KEY_DEFINITIONS, (String[])type.definitions.toArray());
        }

        public SyncClientMsg create() {
            return new SyncClientMsg();
        }

        public void handle(World world, PlayerEntity player) {
            Finder finder = this.type.finder;
            String[] definitions = ForgeNBT.getStringArray((CompoundNBT)this.compound, (String)KEY_DEFINITIONS);
            finder.syncTargetsWith(definitions);
            finder.scanRadius = this.scanRadius;
            finder.pingDepth = this.pingDepth;
            finder.veinMinSize = this.veinMinSize;
            finder.depositMinSize = this.depositMinSize;
        }
    }

    static enum Tags {
        FINDER,
        SCAN_RADIUS,
        PING_DEPTH,
        VEIN_MIN_SIZE,
        DEPOSIT_MIN_SIZE;

    }
}

