/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;

public class TargetLocation
implements Comparable<TargetLocation> {
    public static final TargetLocation EMPTY = TargetLocation.from(null, 0.0);
    @Nullable
    private final BlockPos pos;
    private final double distance;

    protected TargetLocation(@Nullable BlockPos pos, double distance) {
        this.pos = pos;
        this.distance = distance;
    }

    public static TargetLocation from(@Nullable BlockPos pos, double distance) {
        return new TargetLocation(pos, distance);
    }

    public boolean exists() {
        return this.getPos() != null;
    }

    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TargetLocation) {
            TargetLocation location = (TargetLocation)obj;
            if (this.exists()) {
                return this.getPos().equals((Object)location.getPos());
            }
            return !location.exists();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.exists() ? this.getPos().hashCode() : 0;
    }

    @Override
    public int compareTo(TargetLocation o) {
        return this.equals(o) ? 0 : -Double.compare(this.getDistance(), o.getDistance());
    }
}

