/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib;

import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Borders;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;

public class Constraints {
    public static void bind(ConstrainedGeometry<?> element, ConstrainedGeometry<?> reference) {
        Constraints.bind(element, reference, 0.0);
    }

    public static void bind(ConstrainedGeometry<?> element, ConstrainedGeometry<?> reference, double borders) {
        Constraints.bind(element, reference, borders, borders, borders, borders);
    }

    public static void bind(ConstrainedGeometry<?> element, ConstrainedGeometry<?> reference, double top, double left, double bottom, double right) {
        element.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.TOP), top));
        element.constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.LEFT), left));
        element.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.BOTTOM), -bottom));
        element.constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.RIGHT), -right));
    }

    public static void bind(ConstrainedGeometry<?> element, ConstrainedGeometry<?> reference, Borders borders) {
        element.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.TOP), borders::top));
        element.constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.LEFT), borders::left));
        element.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.BOTTOM), () -> -borders.bottom()));
        element.constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.RIGHT), () -> -borders.right()));
    }

    public static void size(ConstrainedGeometry<?> element, double width, double height) {
        element.constrain(GeoParam.WIDTH, Constraint.literal(width));
        element.constrain(GeoParam.HEIGHT, Constraint.literal(height));
    }

    public static void size(ConstrainedGeometry<?> element, Supplier<Double> width, Supplier<Double> height) {
        element.constrain(GeoParam.WIDTH, Constraint.dynamic(width));
        element.constrain(GeoParam.HEIGHT, Constraint.dynamic(height));
    }

    public static void pos(ConstrainedGeometry<?> element, double left, double top) {
        element.constrain(GeoParam.LEFT, Constraint.literal(left));
        element.constrain(GeoParam.TOP, Constraint.literal(top));
    }

    public static void pos(ConstrainedGeometry<?> element, Supplier<Double> left, Supplier<Double> top) {
        element.constrain(GeoParam.LEFT, Constraint.dynamic(left));
        element.constrain(GeoParam.TOP, Constraint.dynamic(top));
    }

    public static void center(ConstrainedGeometry<?> element, ConstrainedGeometry<?> centerOn) {
        element.constrain(GeoParam.TOP, Constraint.midPoint(centerOn.get(GeoParam.TOP), centerOn.get(GeoParam.BOTTOM), () -> element.ySize() / -2.0));
        element.constrain(GeoParam.LEFT, Constraint.midPoint(centerOn.get(GeoParam.LEFT), centerOn.get(GeoParam.RIGHT), () -> element.xSize() / -2.0));
    }

    public static void placeInside(ConstrainedGeometry<?> target, ConstrainedGeometry<?> reference, LayoutPos position) {
        Constraints.placeInside(target, reference, position, 0.0, 0.0);
    }

    public static void placeInside(ConstrainedGeometry<?> target, ConstrainedGeometry<?> reference, LayoutPos position, double xOffset, double yOffset) {
        switch (position.ordinal()) {
            case 0: {
                ((ConstrainedGeometry)target.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.TOP), yOffset))).constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.LEFT), xOffset));
                break;
            }
            case 1: {
                ((ConstrainedGeometry)target.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.TOP), yOffset))).constrain(GeoParam.LEFT, Constraint.midPoint(reference.get(GeoParam.LEFT), reference.get(GeoParam.RIGHT), () -> target.xSize() / -2.0 + xOffset));
                break;
            }
            case 2: {
                ((ConstrainedGeometry)target.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.TOP), yOffset))).constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.RIGHT), xOffset));
                break;
            }
            case 3: {
                ((ConstrainedGeometry)target.constrain(GeoParam.TOP, Constraint.midPoint(reference.get(GeoParam.TOP), reference.get(GeoParam.BOTTOM), () -> target.ySize() / -2.0 + yOffset))).constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.RIGHT), xOffset));
                break;
            }
            case 5: {
                ((ConstrainedGeometry)target.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.BOTTOM), yOffset))).constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.RIGHT), xOffset));
                break;
            }
            case 6: {
                ((ConstrainedGeometry)target.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.BOTTOM), yOffset))).constrain(GeoParam.LEFT, Constraint.midPoint(reference.get(GeoParam.LEFT), reference.get(GeoParam.RIGHT), () -> target.xSize() / -2.0 + xOffset));
                break;
            }
            case 7: {
                ((ConstrainedGeometry)target.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.BOTTOM), yOffset))).constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.LEFT), xOffset));
                break;
            }
            case 4: {
                ((ConstrainedGeometry)target.constrain(GeoParam.TOP, Constraint.midPoint(reference.get(GeoParam.TOP), reference.get(GeoParam.BOTTOM), () -> target.ySize() / -2.0 + yOffset))).constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.LEFT), xOffset));
            }
        }
    }

    public static void placeOutside(ConstrainedGeometry<?> target, ConstrainedGeometry<?> reference, LayoutPos position) {
        Constraints.placeOutside(target, reference, position, 0.0, 0.0);
    }

    public static void placeOutside(ConstrainedGeometry<?> target, ConstrainedGeometry<?> reference, LayoutPos position, double xOffset, double yOffset) {
        switch (position.ordinal()) {
            case 0: {
                ((ConstrainedGeometry)target.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.TOP), yOffset))).constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.LEFT), xOffset));
                break;
            }
            case 1: {
                ((ConstrainedGeometry)target.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.TOP), yOffset))).constrain(GeoParam.LEFT, Constraint.midPoint(reference.get(GeoParam.LEFT), reference.get(GeoParam.RIGHT), () -> target.xSize() / -2.0 + xOffset));
                break;
            }
            case 2: {
                ((ConstrainedGeometry)target.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.TOP), yOffset))).constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.RIGHT), xOffset));
                break;
            }
            case 3: {
                ((ConstrainedGeometry)target.constrain(GeoParam.TOP, Constraint.midPoint(reference.get(GeoParam.TOP), reference.get(GeoParam.BOTTOM), () -> target.ySize() / -2.0 + yOffset))).constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.RIGHT), xOffset));
                break;
            }
            case 5: {
                ((ConstrainedGeometry)target.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.BOTTOM), yOffset))).constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.RIGHT), xOffset));
                break;
            }
            case 6: {
                ((ConstrainedGeometry)target.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.BOTTOM), yOffset))).constrain(GeoParam.LEFT, Constraint.midPoint(reference.get(GeoParam.LEFT), reference.get(GeoParam.RIGHT), () -> target.xSize() / -2.0 + xOffset));
                break;
            }
            case 7: {
                ((ConstrainedGeometry)target.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.BOTTOM), yOffset))).constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.LEFT), xOffset));
                break;
            }
            case 4: {
                ((ConstrainedGeometry)target.constrain(GeoParam.TOP, Constraint.midPoint(reference.get(GeoParam.TOP), reference.get(GeoParam.BOTTOM), () -> target.ySize() / -2.0 + yOffset))).constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.LEFT), xOffset));
            }
        }
    }

    public static enum LayoutPos {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        MIDDLE_RIGHT,
        MIDDLE_LEFT,
        BOTTOM_RIGHT,
        BOTTOM_CENTER,
        BOTTOM_LEFT;

    }
}

