/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.utils;

import com.hypherionmc.craterlib.core.platform.CommonPlatform;
import com.hypherionmc.craterlib.core.platform.ModloaderEnvironment;
import com.hypherionmc.craterlib.nojang.resources.ResourceIdentifier;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import shadow.hypherionmc.mcdiscordformatter.discord.DiscordSerializer;
import shadow.hypherionmc.mcdiscordformatter.minecraft.MinecraftSerializer;
import shadow.kyori.adventure.text.format.NamedTextColor;
import shadow.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import shadow.kyori.adventure.text.serializer.json.JSONOptions;

public class ChatUtils {
    private static final GsonComponentSerializer adventureSerializer = GsonComponentSerializer.builder().options(JSONOptions.byDataVersion().at(SharedConstants.getCurrentVersion().getDataVersion().getVersion())).build();

    public static Component adventureToMojang(shadow.kyori.adventure.text.Component inComponent) {
        String serialised = (String)adventureSerializer.serialize(inComponent);
        return Component.Serializer.fromJson((String)serialised, (HolderLookup.Provider)ChatUtils.getRegistryLookup());
    }

    public static shadow.kyori.adventure.text.Component mojangToAdventure(Component inComponent) {
        String serialised = Component.Serializer.toJson((Component)inComponent, (HolderLookup.Provider)ChatUtils.getRegistryLookup());
        return adventureSerializer.deserialize(serialised);
    }

    private static HolderLookup.Provider getRegistryLookup() {
        if (ModloaderEnvironment.INSTANCE.getEnvironment().isClient() && Minecraft.getInstance().level != null) {
            return Minecraft.getInstance().level.registryAccess();
        }
        if (ModloaderEnvironment.INSTANCE.getEnvironment().isServer() && CommonPlatform.INSTANCE.getMCServer() != null) {
            return CommonPlatform.INSTANCE.getMCServer().toMojang().registryAccess();
        }
        return RegistryAccess.EMPTY;
    }

    public static Component safeCopy(Component inComponent) {
        String value = inComponent.getString();
        Style style = inComponent.getStyle();
        return Component.literal((String)value).withStyle(style);
    }

    public static String strip(String inString, String ... toStrip) {
        String finalString = inString;
        for (String strip : toStrip) {
            if (finalString.startsWith(strip)) {
                finalString = finalString.replaceFirst(strip, "");
            }
            if (!finalString.startsWith(" ")) continue;
            finalString = finalString.replaceFirst(" ", "");
        }
        return finalString;
    }

    public static String resolve(shadow.kyori.adventure.text.Component component, boolean formatted) {
        Component c = ChatUtils.adventureToMojang(component);
        String returnVal = ChatFormatting.stripFormatting((String)c.getString());
        if (formatted) {
            returnVal = DiscordSerializer.INSTANCE.serialize(ChatUtils.safeCopy(c).copy());
        }
        return returnVal;
    }

    public static shadow.kyori.adventure.text.Component resolve(String component, boolean formatted) {
        MutableComponent returnVal = Component.literal((String)component);
        if (formatted) {
            returnVal = MinecraftSerializer.INSTANCE.serialize(component);
        }
        return ChatUtils.mojangToAdventure((Component)returnVal);
    }

    public static shadow.kyori.adventure.text.Component getTooltipTitle(String key) {
        return shadow.kyori.adventure.text.Component.text(String.valueOf(NamedTextColor.YELLOW) + shadow.kyori.adventure.text.Component.translatable(key).key());
    }

    public static String resolveTranslation(String key) {
        return shadow.kyori.adventure.text.Component.translatable(key).key();
    }

    public static shadow.kyori.adventure.text.Component getTranslation(String key) {
        return shadow.kyori.adventure.text.Component.translatable(key);
    }

    public static shadow.kyori.adventure.text.Component makeComponent(String text) {
        return shadow.kyori.adventure.text.Component.translatable(text);
    }

    public static shadow.kyori.adventure.text.Component getBiomeName(ResourceIdentifier identifier) {
        if (identifier == null) {
            return shadow.kyori.adventure.text.Component.text("Unknown");
        }
        return ChatUtils.mojangToAdventure((Component)Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)identifier.toMojang())));
    }
}

