/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.nojang.commands;

import com.hypherionmc.craterlib.api.commands.CraterCommand;
import com.hypherionmc.craterlib.nojang.authlib.BridgedGameProfile;
import com.hypherionmc.craterlib.nojang.commands.BridgedCommandSourceStack;
import com.hypherionmc.craterlib.nojang.world.entity.player.BridgedPlayer;
import com.hypherionmc.craterlib.utils.TriConsumer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.world.entity.player.Player;

public class CommandsRegistry {
    public static final CommandsRegistry INSTANCE = new CommandsRegistry();
    private final List<CraterCommand> commands = new ArrayList<CraterCommand>();

    public void registerCommand(CraterCommand cmd) {
        this.commands.add(cmd);
    }

    public void registerCommands(CommandDispatcher<CommandSourceStack> stack) {
        this.commands.forEach(cmd -> {
            if (cmd.hasArguments()) {
                CommandWithArguments.register(cmd, stack);
            } else {
                CommandWithoutArguments.register(cmd, stack);
            }
        });
    }

    private CommandsRegistry() {
    }

    static class CommandWithArguments {
        CommandWithArguments() {
        }

        public static void register(CraterCommand cmd, CommandDispatcher<CommandSourceStack> dispatcher) {
            LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)cmd.getCommandName()).requires(source -> source.hasPermission(cmd.getPermissionLevel()));
            cmd.getArguments().forEach((key, pair) -> command.then(Commands.argument((String)key, (ArgumentType)((ArgumentType)pair.getLeft())).executes(context -> {
                if (pair.getLeft() instanceof GameProfileArgument) {
                    Collection profiles = GameProfileArgument.getGameProfiles((CommandContext)context, (String)key);
                    ArrayList bridgedGameProfiles = new ArrayList();
                    profiles.forEach(p -> bridgedGameProfiles.add(BridgedGameProfile.of(p)));
                    ((TriConsumer)pair.getRight()).accept(BridgedPlayer.of((Player)((CommandSourceStack)context.getSource()).getPlayer()), bridgedGameProfiles, BridgedCommandSourceStack.of((CommandSourceStack)context.getSource()));
                    return 1;
                }
                return 1;
            })));
            dispatcher.register(command);
        }
    }

    static class CommandWithoutArguments {
        CommandWithoutArguments() {
        }

        public static void register(CraterCommand cmd, CommandDispatcher<CommandSourceStack> dispatcher) {
            LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)cmd.getCommandName()).requires(source -> source.hasPermission(cmd.getPermissionLevel()))).executes(context -> {
                cmd.getExecutor().accept(BridgedCommandSourceStack.of((CommandSourceStack)context.getSource()));
                return 1;
            });
            dispatcher.register(command);
        }
    }
}

