/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.core.config;

import com.hypherionmc.craterlib.core.config.ConfigController;
import java.io.File;
import shadow.hypherionmc.moonconfig.core.CommentedConfig;
import shadow.hypherionmc.moonconfig.core.Config;
import shadow.hypherionmc.moonconfig.core.UnmodifiableConfig;
import shadow.hypherionmc.moonconfig.core.conversion.ObjectConverter;
import shadow.hypherionmc.moonconfig.core.file.CommentedFileConfig;

public class ModuleConfig {
    private final transient File configPath;
    private final transient String networkID;
    private final transient String configName;
    private final transient String modId;
    private transient boolean isSaveCalled = false;

    public ModuleConfig(String modId, String configName) {
        this(modId, "", configName);
    }

    public ModuleConfig(String modId, String subFolder, String configName) {
        Config.setInsertionOrderPreserved(true);
        File configDir = new File("config" + (String)(subFolder.isEmpty() ? "" : File.separator + subFolder));
        this.configPath = new File(String.valueOf(configDir) + File.separator + configName + ".toml");
        this.networkID = modId + ":conf_" + configName.replace("-", "_");
        this.modId = modId;
        this.configName = configName;
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
    }

    public void registerAndSetup(ModuleConfig config) {
        if (!this.configPath.exists() || this.configPath.length() < 2L) {
            this.saveConfig(config);
        } else {
            this.migrateConfig(config);
        }
        ConfigController.register_config(this);
        this.configReloaded();
    }

    public void saveConfig(ModuleConfig conf) {
        this.isSaveCalled = true;
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath).build();
        converter.toConfig((Object)conf, (Config)config);
        config.save();
        this.configReloaded();
        this.isSaveCalled = false;
    }

    public <T> T loadConfig(Object conf) {
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath).build();
        config.load();
        converter.toObject((UnmodifiableConfig)config, conf);
        return (T)conf;
    }

    public void migrateConfig(ModuleConfig conf) {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath).build();
        CommentedFileConfig newConfig = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath).build();
        config.load();
        new ObjectConverter().toConfig((Object)conf, (Config)newConfig);
        this.updateConfigValues(config, newConfig, newConfig, "");
        newConfig.save();
        config.close();
        newConfig.close();
    }

    public void updateConfigValues(CommentedConfig oldConfig, CommentedConfig newConfig, CommentedConfig outputConfig, String subKey) {
        newConfig.valueMap().forEach((key, value) -> {
            String finalKey = subKey + (subKey.isEmpty() ? "" : ".") + key;
            if (value instanceof CommentedConfig) {
                CommentedConfig commentedConfig = (CommentedConfig)value;
                this.updateConfigValues(oldConfig, commentedConfig, outputConfig, finalKey);
            } else {
                outputConfig.set(finalKey, oldConfig.contains(finalKey) ? oldConfig.get(finalKey) : value);
            }
        });
    }

    public File getConfigPath() {
        return this.configPath;
    }

    public String getNetworkID() {
        return this.networkID;
    }

    public void configReloaded() {
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean isSaveCalled() {
        return this.isSaveCalled;
    }
}

