/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.immediate;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.embeddedt.embeddium.api.render.clouds.ModifyCloudRenderingEvent;
import org.embeddedt.embeddium.api.util.ColorABGR;
import org.embeddedt.embeddium.api.util.ColorARGB;
import org.embeddedt.embeddium.api.util.ColorMixer;
import org.embeddedt.embeddium.api.vertex.buffer.VertexBufferWriter;
import org.embeddedt.embeddium.api.vertex.format.common.ColorVertex;
import org.embeddedt.embeddium.impl.render.ShaderModBridge;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.system.MemoryStack;

public class CloudRenderer {
    private static final ResourceLocation CLOUDS_TEXTURE_ID = ResourceLocation.withDefaultNamespace((String)"textures/environment/clouds.png");
    private static final int CLOUD_COLOR_NEG_Y = ColorABGR.pack(0.7f, 0.7f, 0.7f, 1.0f);
    private static final int CLOUD_COLOR_POS_Y = ColorABGR.pack(1.0f, 1.0f, 1.0f, 1.0f);
    private static final int CLOUD_COLOR_NEG_X = ColorABGR.pack(0.9f, 0.9f, 0.9f, 1.0f);
    private static final int CLOUD_COLOR_POS_X = ColorABGR.pack(0.9f, 0.9f, 0.9f, 1.0f);
    private static final int CLOUD_COLOR_NEG_Z = ColorABGR.pack(0.8f, 0.8f, 0.8f, 1.0f);
    private static final int CLOUD_COLOR_POS_Z = ColorABGR.pack(0.8f, 0.8f, 0.8f, 1.0f);
    private static final int DIR_NEG_Y = 1;
    private static final int DIR_POS_Y = 2;
    private static final int DIR_NEG_X = 4;
    private static final int DIR_POS_X = 8;
    private static final int DIR_NEG_Z = 16;
    private static final int DIR_POS_Z = 32;
    private static final int MAX_SINGLE_CLOUD_SIZE = 3072;
    private static final int CLOUD_PIXELS_TO_FOG_DISTANCE = 2048;
    private static final float CLOUD_PIXELS_TO_MINIMUM_RENDER_DISTANCE = 0.125f;
    private static final float CLOUD_PIXELS_TO_MAXIMUM_RENDER_DISTANCE = 0.0078125f;
    private VertexBuffer vertexBuffer;
    private CloudEdges edges;
    private ShaderInstance shader;
    private final FogRenderer.FogData fogData = new FogRenderer.FogData(FogRenderer.FogMode.FOG_TERRAIN);
    private int prevCenterCellX;
    private int prevCenterCellY;
    private int cachedRenderDistance;
    private float cloudSizeX;
    private float cloudSizeZ;
    private float fogDistanceMultiplier;
    private int cloudDistanceMinimum;
    private int cloudDistanceMaximum;
    private CloudStatus cloudRenderMode;

    public CloudRenderer(ResourceProvider factory) {
        this.reloadTextures(factory);
    }

    private static int fireModifyCloudRenderDistanceEvent(int distance) {
        ModifyCloudRenderingEvent event = new ModifyCloudRenderingEvent(distance);
        ModifyCloudRenderingEvent.BUS.post(event);
        return event.getCloudRenderDistance();
    }

    public void render(@Nullable ClientLevel world, LocalPlayer player, PoseStack stack, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float ticks, float tickDelta, double cameraX, double cameraY, double cameraZ) {
        boolean fastClouds;
        if (world == null) {
            return;
        }
        float cloudHeight = world.effects().getCloudHeight();
        if (Float.isNaN(cloudHeight)) {
            return;
        }
        Vec3 color = world.getCloudColor(tickDelta);
        double cloudTime = (ticks + tickDelta) * 0.03f;
        double cloudCenterX = cameraX + cloudTime;
        double cloudCenterZ = cameraZ + 3.96;
        int renderDistance = CloudRenderer.fireModifyCloudRenderDistanceEvent(Minecraft.getInstance().options.getEffectiveRenderDistance());
        int cloudDistance = Math.max(this.cloudDistanceMinimum, renderDistance * this.cloudDistanceMaximum + 9);
        int centerCellX = (int)Math.floor(cloudCenterX / (double)this.cloudSizeX);
        int centerCellZ = (int)Math.floor(cloudCenterZ / (double)this.cloudSizeZ);
        if (this.vertexBuffer == null || this.prevCenterCellX != centerCellX || this.prevCenterCellY != centerCellZ || this.cachedRenderDistance != renderDistance || this.cloudRenderMode != Minecraft.getInstance().options.getCloudsType()) {
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            this.cloudRenderMode = Minecraft.getInstance().options.getCloudsType();
            this.rebuildGeometry(bufferBuilder, cloudDistance, centerCellX, centerCellZ);
            if (this.vertexBuffer == null) {
                this.vertexBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
            }
            this.vertexBuffer.bind();
            this.vertexBuffer.upload(bufferBuilder.buildOrThrow());
            VertexBuffer.unbind();
            this.prevCenterCellX = centerCellX;
            this.prevCenterCellY = centerCellZ;
            this.cachedRenderDistance = renderDistance;
        }
        float previousEnd = RenderSystem.getShaderFogEnd();
        float previousStart = RenderSystem.getShaderFogStart();
        this.fogData.end = (float)cloudDistance * this.fogDistanceMultiplier;
        this.fogData.start = (float)cloudDistance * this.fogDistanceMultiplier - 16.0f;
        this.applyFogModifiers(world, this.fogData, player, (int)((float)cloudDistance * this.fogDistanceMultiplier), tickDelta);
        RenderSystem.setShaderFogEnd((float)this.fogData.end);
        RenderSystem.setShaderFogStart((float)this.fogData.start);
        float translateX = (float)(cloudCenterX - (double)((float)centerCellX * this.cloudSizeX));
        float translateZ = (float)(cloudCenterZ - (double)((float)centerCellZ * this.cloudSizeZ));
        RenderSystem.enableDepthTest();
        this.vertexBuffer.bind();
        boolean insideClouds = cameraY < (double)(cloudHeight + 4.5f) && cameraY > (double)(cloudHeight - 0.5f);
        boolean bl = fastClouds = this.cloudRenderMode == CloudStatus.FAST;
        if (insideClouds || fastClouds) {
            RenderSystem.disableCull();
        } else {
            RenderSystem.enableCull();
        }
        RenderSystem.setShaderColor((float)((float)color.x), (float)((float)color.y), (float)((float)color.z), (float)0.8f);
        modelViewMatrix = new Matrix4f((Matrix4fc)modelViewMatrix);
        modelViewMatrix.translate(-translateX, cloudHeight - (float)cameraY + 0.33f, -translateZ);
        RenderType.cloudsDepthOnly().setupRenderState();
        this.vertexBuffer.drawWithShader(modelViewMatrix, projectionMatrix, this.shader);
        RenderType.cloudsDepthOnly().clearRenderState();
        RenderType.clouds().setupRenderState();
        this.vertexBuffer.drawWithShader(modelViewMatrix, projectionMatrix, this.shader);
        RenderType.clouds().clearRenderState();
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderFogEnd((float)previousEnd);
        RenderSystem.setShaderFogStart((float)previousStart);
    }

    private void applyFogModifiers(ClientLevel world, FogRenderer.FogData fogData, LocalPlayer player, int cloudDistance, float tickDelta) {
        MobEffectInstance statusEffectInstance;
        if (Minecraft.getInstance().gameRenderer == null || Minecraft.getInstance().gameRenderer.getMainCamera() == null) {
            return;
        }
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        FogType cameraSubmersionType = camera.getFluidInCamera();
        if (cameraSubmersionType == FogType.LAVA) {
            if (player.isSpectator()) {
                fogData.start = -8.0f;
                fogData.end = (float)cloudDistance * 0.5f;
            } else if (player.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                fogData.start = 0.0f;
                fogData.end = 3.0f;
            } else {
                fogData.start = 0.25f;
                fogData.end = 1.0f;
            }
        } else if (cameraSubmersionType == FogType.POWDER_SNOW) {
            if (player.isSpectator()) {
                fogData.start = -8.0f;
                fogData.end = (float)cloudDistance * 0.5f;
            } else {
                fogData.start = 0.0f;
                fogData.end = 2.0f;
            }
        } else if (cameraSubmersionType == FogType.WATER) {
            fogData.start = -8.0f;
            fogData.end = 96.0f;
            fogData.end *= Math.max(0.25f, player.getWaterVision());
            if (fogData.end > (float)cloudDistance) {
                fogData.end = cloudDistance;
                fogData.shape = FogShape.CYLINDER;
            }
        } else if (world.effects().isFoggyAt(Mth.floor((double)camera.getPosition().x), Mth.floor((double)camera.getPosition().z)) || Minecraft.getInstance().gui.getBossOverlay().shouldCreateWorldFog()) {
            fogData.start = (float)cloudDistance * 0.05f;
            fogData.end = Math.min((float)cloudDistance, 192.0f) * 0.5f;
        }
        FogRenderer.MobEffectFogFunction fogModifier = FogRenderer.getPriorityFogFunction((Entity)player, (float)tickDelta);
        if (fogModifier != null && (statusEffectInstance = player.getEffect(fogModifier.getMobEffect())) != null) {
            fogModifier.setupFog(fogData, (LivingEntity)player, statusEffectInstance, (float)cloudDistance, tickDelta);
        }
    }

    private void rebuildGeometry(BufferBuilder bufferBuilder, int cloudDistance, int centerCellX, int centerCellZ) {
        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)bufferBuilder);
        boolean fastClouds = this.cloudRenderMode == CloudStatus.FAST;
        for (int offsetX = -cloudDistance; offsetX < cloudDistance; ++offsetX) {
            for (int offsetZ = -cloudDistance; offsetZ < cloudDistance; ++offsetZ) {
                int connectedEdges = this.edges.getEdges(centerCellX + offsetX, centerCellZ + offsetZ);
                if (connectedEdges == 0) continue;
                int texel = this.edges.getColor(centerCellX + offsetX, centerCellZ + offsetZ);
                float x = (float)offsetX * this.cloudSizeX;
                float z = (float)offsetZ * this.cloudSizeZ;
                try (MemoryStack stack = MemoryStack.stackPush();){
                    int mixedColor;
                    long buffer;
                    long ptr = buffer = stack.nmalloc((fastClouds ? 4 : 24) * 16);
                    int count = 0;
                    if ((connectedEdges & 1) != 0) {
                        mixedColor = ColorMixer.mul(texel, fastClouds ? CLOUD_COLOR_POS_Y : CLOUD_COLOR_NEG_Y);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 0.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 0.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if (fastClouds) {
                        writer.push(stack, buffer, count, ColorVertex.FORMAT);
                        continue;
                    }
                    if ((connectedEdges & 2) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_POS_Y);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 4.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 4.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if ((connectedEdges & 4) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_NEG_X);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if ((connectedEdges & 8) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_POS_X);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 4.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 0.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 0.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 4.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if ((connectedEdges & 0x10) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_NEG_Z);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 4.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 0.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if ((connectedEdges & 0x20) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_POS_Z);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 0.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 4.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + this.cloudSizeZ, mixedColor);
                        count += 4;
                    }
                    if (count <= 0) continue;
                    writer.push(stack, buffer, count, ColorVertex.FORMAT);
                    continue;
                }
            }
        }
    }

    private static long writeVertex(long buffer, float x, float y, float z, int color) {
        ColorVertex.put(buffer, x, y, z, color);
        return buffer + 16L;
    }

    public void reloadTextures(ResourceProvider factory) {
        this.destroy();
        this.edges = CloudRenderer.createCloudEdges();
        boolean shaderMod = ShaderModBridge.areShadersEnabled();
        float width = shaderMod ? 256.0f : (float)this.edges.width;
        float height = shaderMod ? 256.0f : (float)this.edges.height;
        this.cloudSizeX = 3072.0f / width;
        this.cloudSizeZ = 3072.0f / height;
        this.fogDistanceMultiplier = 2048.0f / width;
        this.cloudDistanceMinimum = (int)(width * 0.125f);
        this.cloudDistanceMaximum = (int)(width * 0.0078125f);
        try {
            this.shader = new ShaderInstance(factory, "clouds", DefaultVertexFormat.POSITION_COLOR);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        if (this.shader != null) {
            this.shader.close();
            this.shader = null;
        }
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static CloudEdges createCloudEdges() {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        Resource resource = (Resource)resourceManager.getResource(CLOUDS_TEXTURE_ID).orElseThrow();
        try (InputStream inputStream = resource.open();){
            CloudEdges cloudEdges;
            block14: {
                NativeImage nativeImage = NativeImage.read((InputStream)inputStream);
                try {
                    cloudEdges = new CloudEdges(nativeImage);
                    if (nativeImage == null) break block14;
                }
                catch (Throwable throwable) {
                    if (nativeImage != null) {
                        try {
                            nativeImage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                nativeImage.close();
            }
            return cloudEdges;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load texture data", ex);
        }
    }

    private static class CloudEdges {
        private final byte[] edges;
        private final int[] colors;
        private final int width;
        private final int height;

        public CloudEdges(NativeImage texture) {
            int width = texture.getWidth();
            int height = texture.getHeight();
            this.edges = new byte[width * height];
            this.colors = new int[width * height];
            this.width = width;
            this.height = height;
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < height; ++z) {
                    int cell;
                    int index = CloudEdges.index(x, z, width, height);
                    this.colors[index] = cell = texture.getPixelRGBA(x, z);
                    int edges = 0;
                    if (CloudEdges.isOpaqueCell(cell)) {
                        int posZ;
                        int negZ;
                        int posX;
                        edges |= 3;
                        int negX = texture.getPixelRGBA(CloudEdges.wrap(x - 1, width), CloudEdges.wrap(z, height));
                        if (cell != negX) {
                            edges |= 4;
                        }
                        if (!CloudEdges.isOpaqueCell(posX = texture.getPixelRGBA(CloudEdges.wrap(x + 1, width), CloudEdges.wrap(z, height))) && cell != posX) {
                            edges |= 8;
                        }
                        if (cell != (negZ = texture.getPixelRGBA(CloudEdges.wrap(x, width), CloudEdges.wrap(z - 1, height)))) {
                            edges |= 0x10;
                        }
                        if (!CloudEdges.isOpaqueCell(posZ = texture.getPixelRGBA(CloudEdges.wrap(x, width), CloudEdges.wrap(z + 1, height))) && cell != posZ) {
                            edges |= 0x20;
                        }
                    }
                    this.edges[index] = (byte)edges;
                }
            }
        }

        private static boolean isOpaqueCell(int color) {
            return ColorARGB.unpackAlpha(color) > 1;
        }

        public int getEdges(int x, int z) {
            return this.edges[CloudEdges.index(x, z, this.width, this.height)];
        }

        public int getColor(int x, int z) {
            return this.colors[CloudEdges.index(x, z, this.width, this.height)];
        }

        private static int index(int posX, int posZ, int width, int height) {
            return CloudEdges.wrap(posX, width) * height + CloudEdges.wrap(posZ, height);
        }

        private static int wrap(int pos, int dim) {
            return Math.floorMod(pos, dim);
        }
    }
}

