/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.frapi;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.embeddedt.embeddium.api.render.chunk.BlockRenderContext;
import org.embeddedt.embeddium.impl.model.light.data.LightDataAccess;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildBuffers;
import org.embeddedt.embeddium.impl.render.chunk.compile.buffers.ChunkModelVertexConsumer;
import org.embeddedt.embeddium.impl.render.chunk.compile.pipeline.BlockOcclusionCache;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.DefaultMaterials;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.frapi.FRAPIRenderHandler;
import org.jetbrains.annotations.Nullable;

public class IndigoBlockRenderContext
extends net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderContext
implements FRAPIRenderHandler {
    private BlockRenderContext currentContext;
    private ChunkBuildBuffers currentBuffers;
    private final BlockOcclusionCache occlusionCache;
    private final LightDataAccess lightDataAccess;
    private int cullChecked;
    private int cullValue;
    private static final MethodHandle FABRIC_RENDER_HANDLE;
    private static final MethodHandle FORGIFIED_RENDER_HANDLE;

    public IndigoBlockRenderContext(BlockOcclusionCache occlusionCache, LightDataAccess lightDataAccess) {
        this.occlusionCache = occlusionCache;
        this.lightDataAccess = lightDataAccess;
    }

    protected AoCalculator createAoCalc(BlockRenderInfo blockInfo) {
        return new AoCalculator(blockInfo){

            public int light(BlockPos pos, BlockState state) {
                int data = IndigoBlockRenderContext.this.lightDataAccess.get(pos);
                return LightDataAccess.getLightmap(data);
            }

            public float ao(BlockPos pos, BlockState state) {
                return LightDataAccess.unpackAO(IndigoBlockRenderContext.this.lightDataAccess.get(pos));
            }
        };
    }

    public boolean isFaceCulled(@Nullable Direction face) {
        boolean flag;
        if (face == null) {
            return false;
        }
        int fM = 1 << face.ordinal();
        if ((this.cullChecked & fM) != 0) {
            return (this.cullValue & fM) != 0;
        }
        BlockRenderContext ctx = this.currentContext;
        boolean bl = flag = !this.occlusionCache.shouldDrawSide(ctx.state(), (BlockGetter)ctx.localSlice(), ctx.pos(), face);
        if (flag) {
            this.cullValue |= fM;
        }
        this.cullChecked |= fM;
        return flag;
    }

    protected VertexConsumer getVertexConsumer(RenderType layer) {
        Material material = DefaultMaterials.forRenderLayer(layer);
        ChunkModelVertexConsumer consumer = this.currentBuffers.get(material).asVertexConsumer(material);
        consumer.embeddium$setOffset(this.currentContext.origin());
        return consumer;
    }

    protected void bufferQuad(MutableQuadViewImpl quad, VertexConsumer vertexConsumer) {
        super.bufferQuad(quad, vertexConsumer);
        if (vertexConsumer instanceof ChunkModelVertexConsumer) {
            ChunkModelVertexConsumer modelConsumer = (ChunkModelVertexConsumer)vertexConsumer;
            modelConsumer.close();
        }
    }

    @Override
    public void reset() {
        this.cullChecked = 0;
        this.cullValue = 0;
    }

    private RuntimeException processException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new IllegalStateException("Unexpected throwable", e);
    }

    @Override
    public void renderEmbeddium(BlockRenderContext ctx, ChunkBuildBuffers buffers, PoseStack mStack, RandomSource random) {
        this.currentContext = ctx;
        this.currentBuffers = buffers;
        mStack.pushPose();
        try {
            if (FABRIC_RENDER_HANDLE != null) {
                FABRIC_RENDER_HANDLE.invokeExact(this, ctx.localSlice(), ctx.model(), ctx.state(), ctx.pos(), mStack, null, true, random, ctx.seed(), OverlayTexture.NO_OVERLAY);
            } else if (FORGIFIED_RENDER_HANDLE != null) {
                FORGIFIED_RENDER_HANDLE.invokeExact(this, ctx.localSlice(), ctx.model(), ctx.state(), ctx.pos(), mStack, null, true, random, ctx.seed(), OverlayTexture.NO_OVERLAY, ctx.modelData(), ctx.renderLayer());
            }
        }
        catch (Throwable e) {
            throw this.processException(e);
        }
        finally {
            mStack.popPose();
            this.currentContext = null;
            this.currentBuffers = null;
        }
    }

    static {
        MethodHandle fabricHandle = null;
        MethodHandle forgeHandle = null;
        ReflectiveOperationException forgeException = null;
        ReflectiveOperationException fabricException = null;
        try {
            fabricHandle = MethodHandles.lookup().findVirtual(net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderContext.class, "render", MethodType.methodType(Void.TYPE, BlockAndTintGetter.class, BakedModel.class, BlockState.class, BlockPos.class, PoseStack.class, VertexConsumer.class, Boolean.TYPE, RandomSource.class, Long.TYPE, Integer.TYPE));
        }
        catch (ReflectiveOperationException e) {
            fabricException = e;
        }
        try {
            forgeHandle = MethodHandles.lookup().findVirtual(net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderContext.class, "render", MethodType.methodType(Void.TYPE, BlockAndTintGetter.class, BakedModel.class, BlockState.class, BlockPos.class, PoseStack.class, VertexConsumer.class, Boolean.TYPE, RandomSource.class, Long.TYPE, Integer.TYPE, ModelData.class, RenderType.class));
        }
        catch (ReflectiveOperationException e) {
            forgeException = e;
        }
        if (fabricHandle == null && forgeHandle == null) {
            IllegalStateException ex = new IllegalStateException("Failed to find render method on BlockRenderContext.");
            if (fabricException != null) {
                ex.addSuppressed(fabricException);
            }
            if (forgeException != null) {
                ex.addSuppressed(forgeException);
            }
            throw ex;
        }
        FABRIC_RENDER_HANDLE = fabricHandle;
        FORGIFIED_RENDER_HANDLE = forgeHandle;
    }
}

