/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile.pipeline;

import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockOcclusionCache {
    private static final byte UNCACHED_VALUE = 127;
    private final Object2ByteLinkedOpenHashMap<CachedOcclusionShapeTest> map;
    private final CachedOcclusionShapeTest cachedTest = new CachedOcclusionShapeTest();
    private final BlockPos.MutableBlockPos cpos = new BlockPos.MutableBlockPos();

    public BlockOcclusionCache() {
        this.map = new Object2ByteLinkedOpenHashMap(2048, 0.5f);
        this.map.defaultReturnValue((byte)127);
    }

    public boolean shouldDrawSide(BlockState selfState, BlockGetter view, BlockPos pos, Direction facing) {
        BlockPos.MutableBlockPos adjPos = this.cpos;
        adjPos.set(pos.getX() + facing.getStepX(), pos.getY() + facing.getStepY(), pos.getZ() + facing.getStepZ());
        BlockState adjState = view.getBlockState((BlockPos)adjPos);
        if (selfState.skipRendering(adjState, facing) || adjState.hidesNeighborFace(view, pos, selfState, facing.getOpposite()) && selfState.supportsExternalFaceHiding()) {
            return false;
        }
        if (adjState.canOcclude()) {
            VoxelShape selfShape = selfState.getFaceOcclusionShape(view, pos, facing);
            VoxelShape adjShape = adjState.getFaceOcclusionShape(view, (BlockPos)adjPos, facing.getOpposite());
            if (selfShape == Shapes.block() && adjShape == Shapes.block()) {
                return false;
            }
            if (selfShape.isEmpty()) {
                return true;
            }
            return this.calculate(selfShape, adjShape);
        }
        return true;
    }

    private boolean calculate(VoxelShape selfShape, VoxelShape adjShape) {
        CachedOcclusionShapeTest cache = this.cachedTest;
        cache.a = selfShape;
        cache.b = adjShape;
        cache.updateHash();
        byte cached = this.map.getByte((Object)cache);
        if (cached != 127) {
            return cached == 1;
        }
        boolean ret = Shapes.joinIsNotEmpty((VoxelShape)selfShape, (VoxelShape)adjShape, (BooleanOp)BooleanOp.ONLY_FIRST);
        this.map.put((Object)cache.copy(), (byte)(ret ? 1 : 0));
        if (this.map.size() > 2048) {
            this.map.removeFirstByte();
        }
        return ret;
    }

    private static final class CachedOcclusionShapeTest {
        private VoxelShape a;
        private VoxelShape b;
        private int hashCode;

        private CachedOcclusionShapeTest() {
        }

        private CachedOcclusionShapeTest(VoxelShape a, VoxelShape b, int hashCode) {
            this.a = a;
            this.b = b;
            this.hashCode = hashCode;
        }

        public void updateHash() {
            int result = System.identityHashCode(this.a);
            this.hashCode = result = 31 * result + System.identityHashCode(this.b);
        }

        public CachedOcclusionShapeTest copy() {
            return new CachedOcclusionShapeTest(this.a, this.b, this.hashCode);
        }

        public boolean equals(Object o) {
            if (o instanceof CachedOcclusionShapeTest) {
                CachedOcclusionShapeTest that = (CachedOcclusionShapeTest)o;
                return this.a == that.a && this.b == that.b;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

