/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile.buffers;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.render.chunk.compile.buffers.ChunkModelBuilder;
import org.embeddedt.embeddium.impl.render.chunk.compile.buffers.ChunkModelVertexConsumer;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionInfo;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.embeddedt.embeddium.impl.util.ModelQuadUtil;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BakedChunkModelBuilder
implements ChunkModelBuilder {
    private final ChunkMeshBufferBuilder[] vertexBuffers;
    private final boolean splitBySide;
    private final MojangVertexConsumer vertexConsumer = new MojangVertexConsumer();
    private BuiltSectionInfo.Builder renderData;

    public BakedChunkModelBuilder(ChunkMeshBufferBuilder[] vertexBuffers, boolean splitBySide) {
        this.vertexBuffers = vertexBuffers;
        this.splitBySide = splitBySide;
    }

    @Override
    public ChunkMeshBufferBuilder getVertexBuffer(ModelQuadFacing facing) {
        return this.splitBySide ? this.vertexBuffers[facing.ordinal()] : this.vertexBuffers[ModelQuadFacing.UNASSIGNED.ordinal()];
    }

    @Override
    public void addSprite(TextureAtlasSprite sprite) {
        this.renderData.addSprite(sprite);
    }

    @Override
    public ChunkModelVertexConsumer asVertexConsumer(Material material) {
        this.vertexConsumer.initialize(material);
        return this.vertexConsumer;
    }

    public void destroy() {
        for (ChunkMeshBufferBuilder builder : this.vertexBuffers) {
            if (builder == null) continue;
            builder.destroy();
        }
    }

    public void begin(BuiltSectionInfo.Builder renderData, int sectionIndex) {
        this.renderData = renderData;
        for (ChunkMeshBufferBuilder vertexBuffer : this.vertexBuffers) {
            if (vertexBuffer == null) continue;
            vertexBuffer.start(sectionIndex);
        }
    }

    class MojangVertexConsumer
    implements ChunkModelVertexConsumer {
        private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
        private ChunkVertexEncoder.Vertex currentVertexObj;
        private int currentIndex;
        private final Vector3f computedNormal = new Vector3f();
        private Material material;
        private float xOff;
        private float yOff;
        private float zOff;

        MojangVertexConsumer() {
        }

        private void initialize(Material material) {
            this.material = material;
            this.zOff = 0.0f;
            this.yOff = 0.0f;
            this.xOff = 0.0f;
            this.currentIndex = -1;
        }

        private void flushQuad() {
            Vector3f n = this.computedNormal;
            ModelQuadUtil.calculateNormal(this.vertices, n);
            ModelQuadFacing facing = ModelQuadUtil.findNormalFace(n.x, n.y, n.z);
            BakedChunkModelBuilder.this.getVertexBuffer(facing).push(this.vertices, this.material);
            this.currentIndex = -1;
        }

        private int flushLastVertex() {
            int nextIndex = this.currentIndex + 1;
            if (nextIndex == 4) {
                this.flushQuad();
                nextIndex = 0;
            }
            this.currentIndex = nextIndex;
            return nextIndex;
        }

        @Override
        public void embeddium$setOffset(Vector3fc offset) {
            this.xOff = offset.x();
            this.yOff = offset.y();
            this.zOff = offset.z();
        }

        @Override
        public void close() {
            if (this.currentIndex >= 0) {
                this.flushLastVertex();
                this.currentIndex = -1;
            }
        }

        public VertexConsumer addVertex(float x, float y, float z) {
            int index = this.flushLastVertex();
            ChunkVertexEncoder.Vertex vertex = this.vertices[index];
            vertex.x = this.xOff + x;
            vertex.y = this.yOff + y;
            vertex.z = this.zOff + z;
            this.currentVertexObj = vertex;
            return this;
        }

        public VertexConsumer setColor(int r, int g, int b, int a) {
            this.currentVertexObj.color = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
            return this;
        }

        public VertexConsumer setUv(float u, float v) {
            ChunkVertexEncoder.Vertex vertex = this.currentVertexObj;
            vertex.u = u;
            vertex.v = v;
            return this;
        }

        public VertexConsumer setUv1(int p_350815_, int p_350629_) {
            return this;
        }

        public VertexConsumer setUv2(int p_350859_, int p_351004_) {
            this.currentVertexObj.light = p_351004_ << 16 | p_350859_ & 0xFFFF;
            return this;
        }

        public VertexConsumer setNormal(float p_350429_, float p_350286_, float p_350836_) {
            return this;
        }
    }
}

