/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMaps;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ArrayUtils;
import org.embeddedt.embeddium.api.ChunkMeshEvent;
import org.embeddedt.embeddium.impl.Embeddium;
import org.embeddedt.embeddium.impl.gl.arena.GlBufferArena;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.render.chunk.ChunkRenderMatrices;
import org.embeddedt.embeddium.impl.render.chunk.ChunkRenderer;
import org.embeddedt.embeddium.impl.render.chunk.ChunkUpdateType;
import org.embeddedt.embeddium.impl.render.chunk.DefaultChunkRenderer;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkBuilder;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobCollector;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobResult;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkJobTyped;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderMeshingTask;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderSortTask;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderTask;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionInfo;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionMeshParts;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderList;
import org.embeddedt.embeddium.impl.render.chunk.lists.SortedRenderLists;
import org.embeddedt.embeddium.impl.render.chunk.lists.VisibleChunkCollector;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.GraphDirection;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.OcclusionCuller;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegionManager;
import org.embeddedt.embeddium.impl.render.chunk.sorting.TranslucentQuadAnalyzer;
import org.embeddedt.embeddium.impl.render.chunk.terrain.DefaultTerrainRenderPasses;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkMeshFormats;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;
import org.embeddedt.embeddium.impl.render.texture.SpriteUtil;
import org.embeddedt.embeddium.impl.render.viewport.CameraTransform;
import org.embeddedt.embeddium.impl.render.viewport.Viewport;
import org.embeddedt.embeddium.impl.util.MathUtil;
import org.embeddedt.embeddium.impl.util.iterator.ByteIterator;
import org.embeddedt.embeddium.impl.util.task.CancellationToken;
import org.embeddedt.embeddium.impl.world.WorldSlice;
import org.embeddedt.embeddium.impl.world.cloned.ChunkRenderContext;
import org.embeddedt.embeddium.impl.world.cloned.ClonedChunkSectionCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderSectionManager {
    private final ChunkBuilder builder;
    private final Thread renderThread = Thread.currentThread();
    private final RenderRegionManager regions;
    private final ClonedChunkSectionCache sectionCache;
    private final Long2ReferenceMap<RenderSection> sectionByPosition = new Long2ReferenceOpenHashMap();
    private final ConcurrentLinkedDeque<ChunkJobResult<ChunkBuildOutput>> buildResults = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<Runnable> asyncSubmittedTasks = new ConcurrentLinkedDeque();
    private final ChunkRenderer chunkRenderer;
    private final ClientLevel world;
    private final ReferenceSet<RenderSection> sectionsWithGlobalEntities = new ReferenceOpenHashSet();
    private final OcclusionCuller occlusionCuller;
    private final int renderDistance;
    private final ChunkVertexType vertexType;
    @NotNull
    private SortedRenderLists renderLists;
    @NotNull
    private Map<ChunkUpdateType, ArrayDeque<RenderSection>> rebuildLists;
    private int lastUpdatedFrame;
    private boolean needsUpdate;
    @Nullable
    private BlockPos lastCameraPosition;
    private Vec3 cameraPosition = Vec3.ZERO;
    private final boolean translucencySorting;
    private final int translucencyBlockRenderDistance;
    private static final float NEARBY_REBUILD_DISTANCE = Mth.square((float)16.0f);

    public RenderSectionManager(ClientLevel world, int renderDistance, CommandList commandList) {
        ChunkVertexType vertexType = Embeddium.canUseVanillaVertices() ? ChunkMeshFormats.VANILLA_LIKE : ChunkMeshFormats.COMPACT;
        this.chunkRenderer = new DefaultChunkRenderer(RenderDevice.INSTANCE, vertexType);
        this.vertexType = vertexType;
        this.world = world;
        this.builder = new ChunkBuilder(world, vertexType);
        this.needsUpdate = true;
        this.renderDistance = renderDistance;
        this.regions = new RenderRegionManager(commandList);
        this.sectionCache = new ClonedChunkSectionCache((Level)this.world);
        this.renderLists = SortedRenderLists.empty();
        this.occlusionCuller = new OcclusionCuller((Long2ReferenceMap<RenderSection>)Long2ReferenceMaps.unmodifiable(this.sectionByPosition), (Level)this.world);
        this.rebuildLists = new EnumMap<ChunkUpdateType, ArrayDeque<RenderSection>>(ChunkUpdateType.class);
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            this.rebuildLists.put(type, new ArrayDeque());
        }
        this.translucencySorting = Embeddium.canApplyTranslucencySorting();
        this.translucencyBlockRenderDistance = Math.min(9216, (renderDistance << 4) * (renderDistance << 4));
    }

    public void runAsyncTasks() {
        Runnable task;
        while ((task = this.asyncSubmittedTasks.poll()) != null) {
            task.run();
        }
    }

    public void update(Camera camera, Viewport viewport, int frame, boolean spectator) {
        this.lastCameraPosition = camera.getBlockPosition();
        this.cameraPosition = camera.getPosition();
        this.createTerrainRenderList(camera, viewport, frame, spectator);
        this.needsUpdate = false;
        this.lastUpdatedFrame = frame;
    }

    private void checkTranslucencyChange() {
        if (!this.translucencySorting || this.lastCameraPosition == null) {
            return;
        }
        int camSectionX = SectionPos.blockToSectionCoord((double)this.cameraPosition.x);
        int camSectionY = SectionPos.blockToSectionCoord((double)this.cameraPosition.y);
        int camSectionZ = SectionPos.blockToSectionCoord((double)this.cameraPosition.z);
        this.scheduleTranslucencyUpdates(camSectionX, camSectionY, camSectionZ);
    }

    private void scheduleTranslucencyUpdates(int camSectionX, int camSectionY, int camSectionZ) {
        ArrayDeque<RenderSection> sortRebuildList = this.rebuildLists.get((Object)ChunkUpdateType.SORT);
        ArrayDeque<RenderSection> importantSortRebuildList = this.rebuildLists.get((Object)ChunkUpdateType.IMPORTANT_SORT);
        boolean allowImportant = RenderSectionManager.allowImportantRebuilds();
        Iterator<ChunkRenderList> it = this.renderLists.iterator();
        while (it.hasNext()) {
            ChunkRenderList entry = it.next();
            RenderRegion region = entry.getRegion();
            ByteIterator sectionIterator = entry.sectionsWithGeometryIterator(false);
            if (sectionIterator == null) continue;
            while (sectionIterator.hasNext()) {
                boolean cameraChangedSection;
                double dz;
                double dy;
                double dx;
                double camDelta;
                ChunkUpdateType update;
                boolean hasTranslucentData;
                RenderSection section = region.getSection(sectionIterator.nextByteAsInt());
                if (section == null || !section.isBuilt()) continue;
                boolean bl = hasTranslucentData = section.containsTranslucentGeometry() && section.getSortState() != null && section.getSortState().requiresDynamicSorting();
                if (!hasTranslucentData || (update = ChunkUpdateType.getPromotionUpdateType(section.getPendingUpdate(), allowImportant && this.shouldPrioritizeRebuild(section) ? ChunkUpdateType.IMPORTANT_SORT : ChunkUpdateType.SORT)) == null || (camDelta = (dx = this.cameraPosition.x - section.lastCameraX) * dx + (dy = this.cameraPosition.y - section.lastCameraY) * dy + (dz = this.cameraPosition.z - section.lastCameraZ) * dz) < 1.0) continue;
                boolean bl2 = cameraChangedSection = camSectionX != SectionPos.blockToSectionCoord((double)section.lastCameraX) || camSectionY != SectionPos.blockToSectionCoord((double)section.lastCameraY) || camSectionZ != SectionPos.blockToSectionCoord((double)section.lastCameraZ);
                if (!cameraChangedSection && !section.isAlignedWithSectionOnGrid(camSectionX, camSectionY, camSectionZ)) continue;
                section.setPendingUpdate(update);
                (update == ChunkUpdateType.IMPORTANT_SORT ? importantSortRebuildList : sortRebuildList).add(section);
                section.lastCameraX = this.cameraPosition.x;
                section.lastCameraY = this.cameraPosition.y;
                section.lastCameraZ = this.cameraPosition.z;
            }
        }
    }

    private void createTerrainRenderList(Camera camera, Viewport viewport, int frame, boolean spectator) {
        this.resetRenderLists();
        float searchDistance = this.getSearchDistance();
        boolean useOcclusionCulling = this.shouldUseOcclusionCulling(camera, spectator);
        VisibleChunkCollector visitor = new VisibleChunkCollector(frame);
        this.occlusionCuller.findVisible(visitor, viewport, searchDistance, useOcclusionCulling, frame);
        this.renderLists = visitor.createRenderLists();
        this.rebuildLists = visitor.getRebuildLists();
        this.checkTranslucencyChange();
    }

    private float getSearchDistance() {
        float distance = Embeddium.options().performance.useFogOcclusion ? this.getEffectiveRenderDistance() : this.getRenderDistance();
        return distance;
    }

    private boolean shouldUseOcclusionCulling(Camera camera, boolean spectator) {
        BlockPos origin = camera.getBlockPosition();
        boolean useOcclusionCulling = spectator && this.world.getBlockState(origin).isSolidRender((BlockGetter)this.world, origin) ? false : Minecraft.getInstance().smartCull;
        return useOcclusionCulling;
    }

    private void resetRenderLists() {
        this.renderLists = SortedRenderLists.empty();
        for (ArrayDeque<RenderSection> list : this.rebuildLists.values()) {
            list.clear();
        }
    }

    public void onSectionAdded(int x, int y, int z) {
        boolean isEmpty;
        long key = SectionPos.asLong((int)x, (int)y, (int)z);
        if (this.sectionByPosition.containsKey(key)) {
            return;
        }
        RenderRegion region = this.regions.createForChunk(x, y, z);
        RenderSection renderSection = new RenderSection(region, x, y, z);
        region.addSection(renderSection);
        this.sectionByPosition.put(key, (Object)renderSection);
        LevelChunk chunk = this.world.getChunk(x, z);
        LevelChunkSection section = chunk.getSections()[this.world.getSectionIndexFromSectionY(y)];
        boolean bl = isEmpty = (section == null || section.hasOnlyAir()) && ChunkMeshEvent.post((Level)this.world, SectionPos.of((int)x, (int)y, (int)z)).isEmpty();
        if (isEmpty) {
            this.updateSectionInfo(renderSection, BuiltSectionInfo.EMPTY);
        } else {
            renderSection.setPendingUpdate(ChunkUpdateType.INITIAL_BUILD);
        }
        this.connectNeighborNodes(renderSection);
        this.needsUpdate = true;
    }

    public void onSectionRemoved(int x, int y, int z) {
        RenderSection section = (RenderSection)this.sectionByPosition.remove(SectionPos.asLong((int)x, (int)y, (int)z));
        if (section == null) {
            return;
        }
        RenderRegion region = section.getRegion();
        if (region != null) {
            region.removeSection(section);
        }
        this.disconnectNeighborNodes(section);
        this.updateSectionInfo(section, null);
        section.delete();
        this.needsUpdate = true;
    }

    public void renderLayer(ChunkRenderMatrices matrices, TerrainRenderPass pass, double x, double y, double z) {
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        this.chunkRenderer.render(matrices, commandList, this.renderLists, pass, new CameraTransform(x, y, z));
        commandList.flush();
    }

    public void tickVisibleRenders() {
        Iterator<ChunkRenderList> it = this.renderLists.iterator();
        while (it.hasNext()) {
            ChunkRenderList renderList = it.next();
            RenderRegion region = renderList.getRegion();
            ByteIterator iterator = renderList.sectionsWithSpritesIterator();
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                TextureAtlasSprite[] sprites;
                RenderSection section = region.getSection(iterator.nextByteAsInt());
                if (section == null || (sprites = section.getAnimatedSprites()) == null) continue;
                for (TextureAtlasSprite sprite : sprites) {
                    SpriteUtil.markSpriteActive(sprite);
                }
            }
        }
    }

    public boolean isSectionVisible(int x, int y, int z) {
        RenderSection render = this.getRenderSection(x, y, z);
        if (render == null) {
            return false;
        }
        return render.getLastVisibleFrame() == this.lastUpdatedFrame;
    }

    public void updateChunks(boolean updateImmediately) {
        this.sectionCache.cleanup();
        this.regions.update();
        ChunkJobCollector blockingRebuilds = new ChunkJobCollector(Integer.MAX_VALUE, this.buildResults::add);
        ChunkJobCollector deferredRebuilds = new ChunkJobCollector(this.builder.getSchedulingBudget(), this.buildResults::add);
        this.submitRebuildTasks(blockingRebuilds, ChunkUpdateType.IMPORTANT_REBUILD);
        this.submitRebuildTasks(blockingRebuilds, ChunkUpdateType.IMPORTANT_SORT);
        this.submitRebuildTasks(updateImmediately ? blockingRebuilds : deferredRebuilds, ChunkUpdateType.REBUILD);
        this.submitRebuildTasks(updateImmediately ? blockingRebuilds : deferredRebuilds, ChunkUpdateType.INITIAL_BUILD);
        ChunkJobCollector deferredSorts = new ChunkJobCollector(Math.max(4, this.builder.getSchedulingBudget() * 4), this.buildResults::add);
        this.submitRebuildTasks(updateImmediately ? blockingRebuilds : deferredSorts, ChunkUpdateType.SORT);
        blockingRebuilds.awaitCompletion(this.builder);
    }

    public void uploadChunks() {
        ArrayList<ChunkBuildOutput> results = this.collectChunkBuildResults();
        if (results.isEmpty()) {
            return;
        }
        this.processChunkBuildResults(results);
        for (ChunkBuildOutput result : results) {
            result.delete();
        }
        this.needsUpdate = true;
    }

    private void processChunkBuildResults(ArrayList<ChunkBuildOutput> results) {
        List<ChunkBuildOutput> filtered = RenderSectionManager.filterChunkBuildResults(results);
        this.regions.uploadMeshes(RenderDevice.INSTANCE.createCommandList(), filtered);
        for (ChunkBuildOutput result : filtered) {
            CancellationToken job;
            if (result.info != null) {
                this.updateSectionInfo(result.render, result.info);
                if (this.translucencySorting) {
                    this.updateTranslucencyInfo(result.render, result.meshes.get(DefaultTerrainRenderPasses.TRANSLUCENT));
                }
            }
            if ((job = result.render.getBuildCancellationToken()) != null && result.buildTime >= result.render.getLastSubmittedFrame()) {
                result.render.setBuildCancellationToken(null);
            }
            result.render.setLastBuiltFrame(result.buildTime);
        }
    }

    private void updateTranslucencyInfo(RenderSection render, BuiltSectionMeshParts translucencyMesh) {
        if (translucencyMesh == null) {
            return;
        }
        render.setSortState(translucencyMesh.getSortState());
    }

    private void updateSectionInfo(RenderSection render, BuiltSectionInfo info) {
        render.setInfo(info);
        if (info == null || ArrayUtils.isEmpty((Object[])info.globalBlockEntities)) {
            this.sectionsWithGlobalEntities.remove((Object)render);
        } else {
            this.sectionsWithGlobalEntities.add((Object)render);
        }
    }

    private static List<ChunkBuildOutput> filterChunkBuildResults(ArrayList<ChunkBuildOutput> outputs) {
        Reference2ReferenceLinkedOpenHashMap map = new Reference2ReferenceLinkedOpenHashMap();
        for (ChunkBuildOutput output : outputs) {
            RenderSection render;
            ChunkBuildOutput previous;
            if (output.render.isDisposed() || output.render.getLastBuiltFrame() > output.buildTime || (previous = (ChunkBuildOutput)map.get((Object)(render = output.render))) != null && previous.buildTime >= output.buildTime) continue;
            map.put((Object)render, (Object)output);
        }
        return new ArrayList<ChunkBuildOutput>((Collection<ChunkBuildOutput>)map.values());
    }

    private ArrayList<ChunkBuildOutput> collectChunkBuildResults() {
        ChunkJobResult<ChunkBuildOutput> result;
        ArrayList<ChunkBuildOutput> results = new ArrayList<ChunkBuildOutput>();
        while ((result = this.buildResults.poll()) != null) {
            results.add(result.unwrap());
        }
        return results;
    }

    private void submitRebuildTasks(ChunkJobCollector collector, ChunkUpdateType type) {
        ArrayDeque<RenderSection> queue = this.rebuildLists.get((Object)type);
        while (!queue.isEmpty() && collector.canOffer()) {
            ChunkBuilderTask task;
            RenderSection section = queue.remove();
            if (section.isDisposed() || section.getPendingUpdate() != type) continue;
            int frame = this.lastUpdatedFrame;
            ChunkBuilderTask chunkBuilderTask = task = type.isSort() ? this.createSortTask(section, frame) : this.createRebuildTask(section, frame);
            if (task == null && type.isSort()) {
                section.setPendingUpdate(null);
                continue;
            }
            if (task != null) {
                ChunkJobTyped job = this.builder.scheduleTask(task, type.isImportant(), collector::onJobFinished);
                collector.addSubmittedJob(job);
                section.setBuildCancellationToken(job);
                if (!type.isSort()) {
                    section.setSortState(null);
                }
            } else {
                ChunkJobResult<ChunkBuildOutput> result = ChunkJobResult.successfully(new ChunkBuildOutput(section, BuiltSectionInfo.EMPTY, Collections.emptyMap(), frame));
                this.buildResults.add(result);
                section.setBuildCancellationToken(null);
            }
            section.setLastSubmittedFrame(frame);
            section.setPendingUpdate(null);
        }
    }

    @Nullable
    public ChunkBuilderMeshingTask createRebuildTask(RenderSection render, int frame) {
        ChunkRenderContext context = WorldSlice.prepare((Level)this.world, render.getPosition(), this.sectionCache);
        if (context == null) {
            return null;
        }
        return new ChunkBuilderMeshingTask(render, context, frame).withCameraPosition(this.cameraPosition);
    }

    public ChunkBuilderSortTask createSortTask(RenderSection render, int frame) {
        Reference2ReferenceOpenHashMap meshes = new Reference2ReferenceOpenHashMap();
        TranslucentQuadAnalyzer.SortState sortBuffer = render.getSortState();
        if (sortBuffer == null || !sortBuffer.requiresDynamicSorting()) {
            return null;
        }
        meshes.put(DefaultTerrainRenderPasses.TRANSLUCENT, sortBuffer);
        return new ChunkBuilderSortTask(render, (float)this.cameraPosition.x, (float)this.cameraPosition.y, (float)this.cameraPosition.z, frame, (Map<TerrainRenderPass, TranslucentQuadAnalyzer.SortState>)meshes);
    }

    public void markGraphDirty() {
        this.needsUpdate = true;
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    public ChunkBuilder getBuilder() {
        return this.builder;
    }

    public void destroy() {
        this.builder.shutdown();
        for (ChunkBuildOutput result : this.collectChunkBuildResults()) {
            result.delete();
        }
        this.sectionsWithGlobalEntities.clear();
        this.resetRenderLists();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.regions.delete(commandList);
            this.chunkRenderer.delete(commandList);
        }
    }

    public int getTotalSections() {
        return this.sectionByPosition.size();
    }

    public int getVisibleChunkCount() {
        int sections = 0;
        Iterator<ChunkRenderList> iterator = this.renderLists.iterator();
        while (iterator.hasNext()) {
            ChunkRenderList renderList = iterator.next();
            sections += renderList.getSectionsWithGeometryCount();
        }
        return sections;
    }

    private void scheduleRebuildOffThread(int x, int y, int z, boolean important) {
        this.asyncSubmittedTasks.add(() -> this.scheduleRebuild(x, y, z, important));
    }

    public void scheduleRebuild(int x, int y, int z, boolean important) {
        if (Thread.currentThread() != this.renderThread) {
            this.scheduleRebuildOffThread(x, y, z, important);
            return;
        }
        this.sectionCache.invalidate(x, y, z);
        RenderSection section = (RenderSection)this.sectionByPosition.get(SectionPos.asLong((int)x, (int)y, (int)z));
        if (section != null) {
            ChunkUpdateType pendingUpdate = RenderSectionManager.allowImportantRebuilds() && (important || this.shouldPrioritizeRebuild(section)) ? ChunkUpdateType.IMPORTANT_REBUILD : ChunkUpdateType.REBUILD;
            pendingUpdate = ChunkUpdateType.getPromotionUpdateType(section.getPendingUpdate(), pendingUpdate);
            if (pendingUpdate != null) {
                section.setPendingUpdate(pendingUpdate);
                this.needsUpdate = true;
            }
        }
    }

    private boolean shouldPrioritizeRebuild(RenderSection section) {
        return this.lastCameraPosition != null && section.getSquaredDistance(this.lastCameraPosition) < NEARBY_REBUILD_DISTANCE;
    }

    private static boolean allowImportantRebuilds() {
        return !Embeddium.options().performance.alwaysDeferChunkUpdates;
    }

    private float getEffectiveRenderDistance() {
        float[] color = RenderSystem.getShaderFogColor();
        float distance = RenderSystem.getShaderFogEnd();
        float renderDistance = this.getRenderDistance();
        if (!Mth.equal((float)color[3], (float)1.0f)) {
            return renderDistance;
        }
        return Math.min(renderDistance, distance + 0.5f);
    }

    private float getRenderDistance() {
        return (float)this.renderDistance * 16.0f;
    }

    private void connectNeighborNodes(RenderSection render) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj = this.getRenderSection(render.getChunkX() + GraphDirection.x(direction), render.getChunkY() + GraphDirection.y(direction), render.getChunkZ() + GraphDirection.z(direction));
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), render);
            render.setAdjacentNode(direction, adj);
        }
    }

    private void disconnectNeighborNodes(RenderSection render) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj = render.getAdjacent(direction);
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), null);
            render.setAdjacentNode(direction, null);
        }
    }

    private RenderSection getRenderSection(int x, int y, int z) {
        return (RenderSection)this.sectionByPosition.get(SectionPos.asLong((int)x, (int)y, (int)z));
    }

    private Collection<String> getSortingStrings() {
        BlockPos pos;
        RenderSection self;
        HitResult hitResult;
        ArrayList<String> list = new ArrayList<String>();
        int[] sectionCounts = new int[TranslucentQuadAnalyzer.Level.VALUES.length];
        Iterator<ChunkRenderList> it = this.renderLists.iterator();
        while (it.hasNext()) {
            ChunkRenderList renderList = it.next();
            RenderRegion region = renderList.getRegion();
            ByteIterator listIter = renderList.sectionsWithGeometryIterator(false);
            if (listIter == null) continue;
            while (listIter.hasNext()) {
                RenderSection section = region.getSection(listIter.nextByteAsInt());
                if (section == null || !section.containsTranslucentGeometry()) continue;
                TranslucentQuadAnalyzer.SortState data = section.getSortState();
                TranslucentQuadAnalyzer.Level level = data != null ? data.level() : TranslucentQuadAnalyzer.Level.NONE;
                int n = level.ordinal();
                sectionCounts[n] = sectionCounts[n] + 1;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Sorting: ");
        TranslucentQuadAnalyzer.Level[] values = TranslucentQuadAnalyzer.Level.VALUES;
        for (int i = 0; i < values.length; ++i) {
            TranslucentQuadAnalyzer.Level level = values[i];
            sb.append(level.name());
            sb.append('=');
            sb.append(sectionCounts[level.ordinal()]);
            if (i + 1 >= values.length) continue;
            sb.append(", ");
        }
        list.add(sb.toString());
        Entity cameraEntity = Minecraft.getInstance().getCameraEntity();
        if (cameraEntity != null && (hitResult = cameraEntity.pick(20.0, 0.0f, false)) != null && hitResult.getType() == HitResult.Type.BLOCK && (self = this.getRenderSection((pos = ((BlockHitResult)hitResult).getBlockPos()).getX() >> 4, pos.getY() >> 4, pos.getZ() >> 4)) != null && self.containsTranslucentGeometry()) {
            TranslucentQuadAnalyzer.SortState selfData = self.getSortState();
            TranslucentQuadAnalyzer.Level level = selfData != null ? selfData.level() : TranslucentQuadAnalyzer.Level.NONE;
            list.add("Targeted Section: " + level.name());
        }
        return list;
    }

    public Collection<String> getDebugStrings() {
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        int indexCount = 0;
        long deviceUsed = 0L;
        long deviceAllocated = 0L;
        long indexUsed = 0L;
        long indexAllocated = 0L;
        for (RenderRegion region : this.regions.getLoadedRegions()) {
            RenderRegion.DeviceResources resources = region.getResources();
            if (resources == null) continue;
            GlBufferArena buffer = resources.getGeometryArena();
            deviceUsed += buffer.getDeviceUsedMemoryL();
            deviceAllocated += buffer.getDeviceAllocatedMemoryL();
            GlBufferArena indexBuffer = resources.getIndexArena();
            if (indexBuffer != null) {
                indexUsed += indexBuffer.getDeviceUsedMemoryL();
                indexAllocated += indexBuffer.getDeviceAllocatedMemoryL();
                ++indexCount;
            }
            ++count;
        }
        list.add(String.format("Geometry Pool: %d/%d MiB (%d buffers)", MathUtil.toMib(deviceUsed), MathUtil.toMib(deviceAllocated), count));
        if (indexUsed > 0L) {
            list.add(String.format("Index Pool: %d/%d MiB (%d buffers)", MathUtil.toMib(indexUsed), MathUtil.toMib(indexAllocated), indexCount));
        }
        list.add(String.format("Transfer Queue: %s", this.regions.getStagingBuffer().toString()));
        list.add(String.format("Chunk Builder: Permits=%02d | Busy=%02d | Total=%02d", this.builder.getScheduledJobCount(), this.builder.getBusyThreadCount(), this.builder.getTotalThreadCount()));
        list.add(String.format("Chunk Queues: U=%02d (P0=%03d | P1=%03d | P2=%03d)", this.buildResults.size(), this.rebuildLists.get((Object)ChunkUpdateType.IMPORTANT_REBUILD).size(), this.rebuildLists.get((Object)ChunkUpdateType.REBUILD).size(), this.rebuildLists.get((Object)ChunkUpdateType.INITIAL_BUILD).size()));
        if (this.translucencySorting) {
            list.addAll(this.getSortingStrings());
        }
        return list;
    }

    @NotNull
    public SortedRenderLists getRenderLists() {
        return this.renderLists;
    }

    public boolean isSectionBuilt(int x, int y, int z) {
        RenderSection section = this.getRenderSection(x, y, z);
        return section != null && section.isBuilt();
    }

    public void onChunkAdded(int x, int z) {
        for (int y = this.world.getMinSection(); y < this.world.getMaxSection(); ++y) {
            this.onSectionAdded(x, y, z);
        }
    }

    public void onChunkRemoved(int x, int z) {
        for (int y = this.world.getMinSection(); y < this.world.getMaxSection(); ++y) {
            this.onSectionRemoved(x, y, z);
        }
    }

    public Collection<RenderSection> getSectionsWithGlobalEntities() {
        return ReferenceSets.unmodifiable(this.sectionsWithGlobalEntities);
    }

    public ChunkVertexType getVertexType() {
        return this.vertexType;
    }
}

