/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.features.shader.uniform;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.ShaderInstance;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ShaderInstance.class})
public abstract class ShaderProgramMixin {
    @Shadow
    @Final
    private List<String> samplerNames;
    @Shadow
    @Final
    private int programId;
    @Shadow
    @Final
    private List<Uniform> uniforms;
    @Unique
    private Object2IntMap<String> uniformCache;
    private static final int NUM_SAMPLERS = 12;
    private static final String[] SAMPLER_IDS = (String[])IntStream.range(0, 12).mapToObj(i -> "Sampler" + i).toArray(String[]::new);

    @Shadow
    public abstract void setSampler(String var1, Object var2);

    @Redirect(method={"apply"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/shaders/Uniform;glGetUniformLocation(ILjava/lang/CharSequence;)I"))
    private int redirectGetUniformLocation(int program, CharSequence name) {
        int location;
        if (this.uniformCache == null) {
            this.uniformCache = new Object2IntOpenHashMap();
            this.uniformCache.defaultReturnValue(-1);
            for (String samplerName : this.samplerNames) {
                int location2 = Uniform.glGetUniformLocation((int)this.programId, (CharSequence)samplerName);
                if (location2 == -1) continue;
                this.uniformCache.put((Object)samplerName, location2);
            }
        }
        if ((location = this.uniformCache.getInt((Object)name)) == -1) {
            throw new IllegalStateException("Failed to find uniform '%s' during shader bind".formatted(name));
        }
        return location;
    }

    @Redirect(method={"apply"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/ShaderInstance;uniforms:Ljava/util/List;", ordinal=0))
    private List<Uniform> uploadUniforms(ShaderInstance instance) {
        List<Uniform> uniforms = this.uniforms;
        for (int i = 0; i < uniforms.size(); ++i) {
            uniforms.get(i).upload();
        }
        return Collections.emptyList();
    }

    @ModifyConstant(method={"setDefaultUniforms"}, constant={@Constant(intValue=12, ordinal=0)})
    private int setSamplersManually(int constant) {
        for (int i = 0; i < constant; ++i) {
            this.setSampler(SAMPLER_IDS[i], RenderSystem.getShaderTexture((int)i));
        }
        return 0;
    }
}

