/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.features.render.immediate.buffer_builder.intrinsics;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import org.embeddedt.embeddium.api.util.ColorABGR;
import org.embeddedt.embeddium.api.vertex.buffer.VertexBufferWriter;
import org.embeddedt.embeddium.impl.model.quad.ModelQuadView;
import org.embeddedt.embeddium.impl.render.immediate.model.BakedModelEncoder;
import org.embeddedt.embeddium.impl.render.texture.SpriteUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BufferBuilder.class})
public abstract class BufferBuilderMixin
implements VertexConsumer {
    @Shadow
    private boolean fastFormat;

    public void putBulkData(PoseStack.Pose matrices, BakedQuad bakedQuad, float r, float g, float b, float a, int light, int overlay) {
        this.putBulkData(matrices, bakedQuad, r, g, b, a, light, overlay, false);
    }

    public void putBulkData(PoseStack.Pose matrices, BakedQuad bakedQuad, float r, float g, float b, float a, int light, int overlay, boolean colorize) {
        if (!this.fastFormat) {
            super.putBulkData(matrices, bakedQuad, r, g, b, a, light, overlay, colorize);
            SpriteUtil.markSpriteActive(bakedQuad.getSprite());
            return;
        }
        if (bakedQuad.getVertices().length < 32) {
            return;
        }
        VertexBufferWriter writer = VertexBufferWriter.of(this);
        ModelQuadView quad = (ModelQuadView)bakedQuad;
        int color = ColorABGR.pack(r, g, b, a);
        BakedModelEncoder.writeQuadVertices(writer, matrices, quad, color, light, overlay, colorize);
        SpriteUtil.markSpriteActive(quad.getSprite());
    }

    public void putBulkData(PoseStack.Pose matrices, BakedQuad bakedQuad, float[] brightnessTable, float r, float g, float b, float a, int[] light, int overlay, boolean colorize) {
        if (!this.fastFormat) {
            super.putBulkData(matrices, bakedQuad, brightnessTable, r, g, b, a, light, overlay, colorize);
            SpriteUtil.markSpriteActive(bakedQuad.getSprite());
            return;
        }
        if (bakedQuad.getVertices().length < 32) {
            return;
        }
        VertexBufferWriter writer = VertexBufferWriter.of(this);
        ModelQuadView quad = (ModelQuadView)bakedQuad;
        BakedModelEncoder.writeQuadVertices(writer, matrices, quad, r, g, b, a, brightnessTable, colorize, light, overlay);
        SpriteUtil.markSpriteActive(quad.getSprite());
    }
}

