/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.features.gui.hooks.debug;

import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import org.embeddedt.embeddium.impl.Embeddium;
import org.embeddedt.embeddium.impl.render.EmbeddiumWorldRenderer;
import org.embeddedt.embeddium.impl.util.MathUtil;
import org.embeddedt.embeddium.impl.util.NativeBuffer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={DebugScreenOverlay.class})
public abstract class DebugHudMixin {
    @Redirect(method={"getSystemInformation"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList([Ljava/lang/Object;)Ljava/util/ArrayList;", remap=false))
    private ArrayList<String> redirectRightTextEarly(Object[] elements) {
        ArrayList strings = Lists.newArrayList((Object[])((String[])elements));
        strings.add("");
        strings.add("%s%s Renderer (%s)".formatted(DebugHudMixin.getVersionColor(), "Embeddium", Embeddium.getVersion()));
        if (Minecraft.getInstance().showOnlyReducedInfo()) {
            return strings;
        }
        EmbeddiumWorldRenderer renderer = EmbeddiumWorldRenderer.instanceNullable();
        if (renderer != null) {
            strings.addAll(renderer.getDebugStrings());
        }
        for (int i = 0; i < strings.size(); ++i) {
            String str = (String)strings.get(i);
            if (!str.startsWith("Allocated:")) continue;
            strings.add(i + 1, DebugHudMixin.getNativeMemoryString());
            break;
        }
        return strings;
    }

    @Unique
    private static ChatFormatting getVersionColor() {
        String version = Embeddium.getVersion();
        ChatFormatting color = version.contains("git.") ? ChatFormatting.RED : ChatFormatting.GREEN;
        return color;
    }

    @Unique
    private static String getNativeMemoryString() {
        return "Off-Heap: +" + MathUtil.toMib(DebugHudMixin.getNativeMemoryUsage()) + "MB";
    }

    @Unique
    private static long getNativeMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed() + NativeBuffer.getTotalAllocated();
    }
}

