/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.ParticleStatus;
import net.minecraft.network.chat.Component;
import org.embeddedt.embeddium.api.options.binding.compat.VanillaBooleanOptionBinding;
import org.embeddedt.embeddium.api.options.control.ControlValueFormatter;
import org.embeddedt.embeddium.api.options.control.CyclingControl;
import org.embeddedt.embeddium.api.options.control.SliderControl;
import org.embeddedt.embeddium.api.options.control.TickBoxControl;
import org.embeddedt.embeddium.api.options.storage.MinecraftOptionsStorage;
import org.embeddedt.embeddium.api.options.structure.Option;
import org.embeddedt.embeddium.api.options.structure.OptionFlag;
import org.embeddedt.embeddium.api.options.structure.OptionGroup;
import org.embeddedt.embeddium.api.options.structure.OptionImpact;
import org.embeddedt.embeddium.api.options.structure.OptionImpl;
import org.embeddedt.embeddium.api.options.structure.OptionPage;
import org.embeddedt.embeddium.api.options.structure.OptionStorage;
import org.embeddedt.embeddium.api.options.structure.StandardOptions;
import org.embeddedt.embeddium.impl.compat.modernui.MuiGuiScaleHook;
import org.embeddedt.embeddium.impl.compatibility.workarounds.Workarounds;
import org.embeddedt.embeddium.impl.gl.arena.staging.MappedStagingBuffer;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.gui.EmbeddiumOptions;
import org.embeddedt.embeddium.impl.gui.options.storage.EmbeddiumOptionsStorage;
import org.embeddedt.embeddium.impl.render.ShaderModBridge;
import org.embeddedt.embeddium.impl.render.chunk.compile.executor.ChunkBuilder;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;

public class EmbeddiumGameOptionPages {
    private static final EmbeddiumOptionsStorage sodiumOpts = new EmbeddiumOptionsStorage();
    private static final MinecraftOptionsStorage vanillaOpts = MinecraftOptionsStorage.INSTANCE;

    public static OptionPage general() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().setId(StandardOptions.Group.RENDERING).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setId(StandardOptions.Option.RENDER_DISTANCE).setName((Component)Component.translatable((String)"options.renderDistance")).setTooltip((Component)Component.translatable((String)"sodium.options.view_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 2, 32, 1, ControlValueFormatter.translateVariable("options.chunks"))).setBinding((options, value) -> options.renderDistance().set(value), options -> (Integer)options.renderDistance().get()).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setId(StandardOptions.Option.SIMULATION_DISTANCE).setName((Component)Component.translatable((String)"options.simulationDistance")).setTooltip((Component)Component.translatable((String)"sodium.options.simulation_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 5, 32, 1, ControlValueFormatter.translateVariable("options.chunks"))).setBinding((options, value) -> options.simulationDistance().set(value), options -> (Integer)options.simulationDistance().get()).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setId(StandardOptions.Option.BRIGHTNESS).setName((Component)Component.translatable((String)"options.gamma")).setTooltip((Component)Component.translatable((String)"sodium.options.brightness.tooltip")).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 100, 1, ControlValueFormatter.brightness())).setBinding((opts, value) -> opts.gamma().set((Object)((double)value.intValue() * 0.01)), opts -> (int)((Double)opts.gamma().get() / 0.01)).build()).build());
        groups.add(OptionGroup.createBuilder().setId(StandardOptions.Group.WINDOW).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setId(StandardOptions.Option.GUI_SCALE).setName((Component)Component.translatable((String)"options.guiScale")).setTooltip((Component)Component.translatable((String)"sodium.options.gui_scale.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, MuiGuiScaleHook.getMaxGuiScale(), 1, ControlValueFormatter.guiScale())).setBinding((opts, value) -> {
            opts.guiScale().set(value);
            Minecraft client = Minecraft.getInstance();
            client.resizeDisplay();
        }, opts -> (Integer)opts.guiScale().get()).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setId(StandardOptions.Option.FULLSCREEN).setName((Component)Component.translatable((String)"options.fullscreen")).setTooltip((Component)Component.translatable((String)"sodium.options.fullscreen.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.fullscreen().set(value);
            Minecraft client = Minecraft.getInstance();
            Window window = client.getWindow();
            if (window != null && window.isFullscreen() != ((Boolean)opts.fullscreen().get()).booleanValue()) {
                window.toggleFullScreen();
                opts.fullscreen().set((Object)window.isFullscreen());
            }
        }, opts -> (Boolean)opts.fullscreen().get()).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setId(StandardOptions.Option.VSYNC).setName((Component)Component.translatable((String)"options.vsync")).setTooltip((Component)Component.translatable((String)"sodium.options.v_sync.tooltip")).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding((OptionInstance<Boolean>)Minecraft.getInstance().options.enableVsync())).setImpact(OptionImpact.VARIES).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setId(StandardOptions.Option.MAX_FRAMERATE).setName((Component)Component.translatable((String)"options.framerateLimit")).setTooltip((Component)Component.translatable((String)"sodium.options.fps_limit.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 10, 260, 10, ControlValueFormatter.fpsLimit())).setBinding((opts, value) -> {
            opts.framerateLimit().set(value);
            Minecraft.getInstance().getWindow().setFramerateLimit(value.intValue());
        }, opts -> (Integer)opts.framerateLimit().get()).build()).build());
        groups.add(OptionGroup.createBuilder().setId(StandardOptions.Group.INDICATORS).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setId(StandardOptions.Option.VIEW_BOBBING).setName((Component)Component.translatable((String)"options.viewBobbing")).setTooltip((Component)Component.translatable((String)"sodium.options.view_bobbing.tooltip")).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding((OptionInstance<Boolean>)Minecraft.getInstance().options.bobView())).build()).add(OptionImpl.createBuilder(AttackIndicatorStatus.class, vanillaOpts).setId(StandardOptions.Option.ATTACK_INDICATOR).setName((Component)Component.translatable((String)"options.attackIndicator")).setTooltip((Component)Component.translatable((String)"sodium.options.attack_indicator.tooltip")).setControl(opts -> new CyclingControl<AttackIndicatorStatus>((Option<AttackIndicatorStatus>)opts, AttackIndicatorStatus.class, new Component[]{Component.translatable((String)"options.off"), Component.translatable((String)"options.attack.crosshair"), Component.translatable((String)"options.attack.hotbar")})).setBinding((opts, value) -> opts.attackIndicator().set(value), opts -> (AttackIndicatorStatus)opts.attackIndicator().get()).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setId(StandardOptions.Option.AUTOSAVE_INDICATOR).setName((Component)Component.translatable((String)"options.autosaveIndicator")).setTooltip((Component)Component.translatable((String)"sodium.options.autosave_indicator.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> opts.showAutosaveIndicator().set(value), opts -> (Boolean)opts.showAutosaveIndicator().get()).build()).build());
        return new OptionPage(StandardOptions.Pages.GENERAL, (Component)Component.translatable((String)"stat.generalButton"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage quality() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().setId(StandardOptions.Group.GRAPHICS).add(OptionImpl.createBuilder(GraphicsStatus.class, vanillaOpts).setId(StandardOptions.Option.GRAPHICS_MODE).setName((Component)Component.translatable((String)"options.graphics")).setTooltip((Component)Component.translatable((String)"sodium.options.graphics_quality.tooltip")).setControl(option -> new CyclingControl<GraphicsStatus>((Option<GraphicsStatus>)option, GraphicsStatus.class, new Component[]{Component.translatable((String)"options.graphics.fast"), Component.translatable((String)"options.graphics.fancy"), Component.translatable((String)"options.graphics.fabulous")})).setBinding((opts, value) -> opts.graphicsMode().set(value), opts -> (GraphicsStatus)opts.graphicsMode().get()).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().setId(StandardOptions.Group.DETAILS).add(OptionImpl.createBuilder(CloudStatus.class, vanillaOpts).setId(StandardOptions.Option.CLOUDS).setName((Component)Component.translatable((String)"options.renderClouds")).setTooltip((Component)Component.translatable((String)"sodium.options.clouds_quality.tooltip")).setControl(option -> new CyclingControl<CloudStatus>((Option<CloudStatus>)option, CloudStatus.class, new Component[]{Component.translatable((String)"options.off"), Component.translatable((String)"options.graphics.fast"), Component.translatable((String)"options.graphics.fancy")})).setBinding((opts, value) -> {
            RenderTarget framebuffer;
            opts.cloudStatus().set(value);
            if (Minecraft.useShaderTransparency() && (framebuffer = Minecraft.getInstance().levelRenderer.getCloudsTarget()) != null) {
                framebuffer.clear(Minecraft.ON_OSX);
            }
        }, opts -> (CloudStatus)opts.cloudStatus().get()).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(EmbeddiumOptions.GraphicsQuality.class, sodiumOpts).setId(StandardOptions.Option.WEATHER).setName((Component)Component.translatable((String)"soundCategory.weather")).setTooltip((Component)Component.translatable((String)"sodium.options.weather_quality.tooltip")).setControl(option -> new CyclingControl<EmbeddiumOptions.GraphicsQuality>((Option<EmbeddiumOptions.GraphicsQuality>)option, EmbeddiumOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.weatherQuality = value;
        }, opts -> opts.quality.weatherQuality).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(EmbeddiumOptions.GraphicsQuality.class, sodiumOpts).setId(StandardOptions.Option.LEAVES).setName((Component)Component.translatable((String)"sodium.options.leaves_quality.name")).setTooltip((Component)Component.translatable((String)"sodium.options.leaves_quality.tooltip")).setControl(option -> new CyclingControl<EmbeddiumOptions.GraphicsQuality>((Option<EmbeddiumOptions.GraphicsQuality>)option, EmbeddiumOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.leavesQuality = value;
        }, opts -> opts.quality.leavesQuality).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(ParticleStatus.class, vanillaOpts).setId(StandardOptions.Option.PARTICLES).setName((Component)Component.translatable((String)"options.particles")).setTooltip((Component)Component.translatable((String)"sodium.options.particle_quality.tooltip")).setControl(option -> new CyclingControl<ParticleStatus>((Option<ParticleStatus>)option, ParticleStatus.class, new Component[]{Component.translatable((String)"options.particles.all"), Component.translatable((String)"options.particles.decreased"), Component.translatable((String)"options.particles.minimal")})).setBinding((opts, value) -> opts.particles().set(value), opts -> (ParticleStatus)opts.particles().get()).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setId(StandardOptions.Option.SMOOTH_LIGHT).setName((Component)Component.translatable((String)"options.ao")).setTooltip((Component)Component.translatable((String)"sodium.options.smooth_lighting.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> opts.ambientOcclusion().set(value), opts -> (Boolean)opts.ambientOcclusion().get()).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setId(StandardOptions.Option.BIOME_BLEND).setName((Component)Component.translatable((String)"options.biomeBlendRadius")).setTooltip((Component)Component.translatable((String)"sodium.options.biome_blend.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, 7, 1, ControlValueFormatter.biomeBlend())).setBinding((opts, value) -> opts.biomeBlendRadius().set(value), opts -> (Integer)opts.biomeBlendRadius().get()).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setId(StandardOptions.Option.ENTITY_DISTANCE).setName((Component)Component.translatable((String)"options.entityDistanceScaling")).setTooltip((Component)Component.translatable((String)"sodium.options.entity_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 50, 500, 25, ControlValueFormatter.percentage())).setBinding((opts, value) -> opts.entityDistanceScaling().set((Object)((double)value.intValue() / 100.0)), opts -> Math.round(((Double)opts.entityDistanceScaling().get()).floatValue() * 100.0f)).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setId(StandardOptions.Option.ENTITY_SHADOWS).setName((Component)Component.translatable((String)"options.entityShadows")).setTooltip((Component)Component.translatable((String)"sodium.options.entity_shadows.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> opts.entityShadows().set(value), opts -> (Boolean)opts.entityShadows().get()).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setId(StandardOptions.Option.VIGNETTE).setName((Component)Component.translatable((String)"sodium.options.vignette.name")).setTooltip((Component)Component.translatable((String)"sodium.options.vignette.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableVignette = value;
        }, opts -> opts.quality.enableVignette).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().setId(StandardOptions.Group.MIPMAPS).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setId(StandardOptions.Option.MIPMAP_LEVEL).setName((Component)Component.translatable((String)"options.mipmapLevels")).setTooltip((Component)Component.translatable((String)"sodium.options.mipmap_levels.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.multiplier())).setBinding((opts, value) -> opts.mipmapLevels().set(value), opts -> (Integer)opts.mipmapLevels().get()).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().setId(StandardOptions.Group.SORTING).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setId(StandardOptions.Option.TRANSLUCENT_FACE_SORTING).setName((Component)Component.translatable((String)"sodium.options.translucent_face_sorting.name")).setTooltip((Component)Component.translatable((String)"sodium.options.translucent_face_sorting.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.VARIES).setBinding((opts, value) -> {
            opts.performance.useTranslucentFaceSorting = value;
        }, opts -> opts.performance.useTranslucentFaceSorting).setEnabled(!ShaderModBridge.isNvidiumEnabled()).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        return new OptionPage(StandardOptions.Pages.QUALITY, (Component)Component.translatable((String)"sodium.options.pages.quality"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage performance() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().setId(StandardOptions.Group.CHUNK_UPDATES).add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setId(StandardOptions.Option.CHUNK_UPDATE_THREADS).setName((Component)Component.translatable((String)"sodium.options.chunk_update_threads.name")).setTooltip((Component)Component.translatable((String)"sodium.options.chunk_update_threads.tooltip")).setControl(o -> new SliderControl((Option<Integer>)o, 0, ChunkBuilder.getMaxThreadCount(), 1, ControlValueFormatter.quantityOrDisabled("threads", "Default"))).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.chunkBuilderThreads = value;
        }, opts -> opts.performance.chunkBuilderThreads).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setId(StandardOptions.Option.DEFFER_CHUNK_UPDATES).setName((Component)Component.translatable((String)"sodium.options.always_defer_chunk_updates.name")).setTooltip((Component)Component.translatable((String)"sodium.options.always_defer_chunk_updates.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.alwaysDeferChunkUpdates = value;
        }, opts -> opts.performance.alwaysDeferChunkUpdates).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).build());
        groups.add(OptionGroup.createBuilder().setId(StandardOptions.Group.RENDERING_CULLING).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setId(StandardOptions.Option.BLOCK_FACE_CULLING).setName((Component)Component.translatable((String)"sodium.options.use_block_face_culling.name")).setTooltip((Component)Component.translatable((String)"sodium.options.use_block_face_culling.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useBlockFaceCulling = value;
        }, opts -> opts.performance.useBlockFaceCulling).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setId(StandardOptions.Option.COMPACT_VERTEX_FORMAT).setName((Component)Component.translatable((String)"sodium.options.use_compact_vertex_format.name")).setTooltip((Component)Component.translatable((String)"sodium.options.use_compact_vertex_format.tooltip")).setControl(TickBoxControl::new).setEnabled(!ShaderModBridge.areShadersEnabled()).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useCompactVertexFormat = value;
        }, opts -> opts.performance.useCompactVertexFormat).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setId(StandardOptions.Option.FOG_OCCLUSION).setName((Component)Component.translatable((String)"sodium.options.use_fog_occlusion.name")).setTooltip((Component)Component.translatable((String)"sodium.options.use_fog_occlusion.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.performance.useFogOcclusion = value;
        }, opts -> opts.performance.useFogOcclusion).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setId(StandardOptions.Option.ENTITY_CULLING).setName((Component)Component.translatable((String)"sodium.options.use_entity_culling.name")).setTooltip((Component)Component.translatable((String)"sodium.options.use_entity_culling.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useEntityCulling = value;
        }, opts -> opts.performance.useEntityCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setId(StandardOptions.Option.ANIMATE_VISIBLE_TEXTURES).setName((Component)Component.translatable((String)"sodium.options.animate_only_visible_textures.name")).setTooltip((Component)Component.translatable((String)"sodium.options.animate_only_visible_textures.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.animateOnlyVisibleTextures = value;
        }, opts -> opts.performance.animateOnlyVisibleTextures).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setId(StandardOptions.Option.NO_ERROR_CONTEXT).setName((Component)Component.translatable((String)"sodium.options.use_no_error_context.name")).setTooltip((Component)Component.translatable((String)"sodium.options.use_no_error_context.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.LOW).setBinding((opts, value) -> {
            opts.performance.useNoErrorGLContext = value;
        }, opts -> opts.performance.useNoErrorGLContext).setEnabled(EmbeddiumGameOptionPages.supportsNoErrorContext()).setFlags(OptionFlag.REQUIRES_GAME_RESTART).build()).build());
        return new OptionPage(StandardOptions.Pages.PERFORMANCE, (Component)Component.translatable((String)"sodium.options.pages.performance"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    private static boolean supportsNoErrorContext() {
        GLCapabilities capabilities = GL.getCapabilities();
        return (capabilities.OpenGL46 || capabilities.GL_KHR_no_error) && !Workarounds.isWorkaroundEnabled(Workarounds.Reference.NO_ERROR_CONTEXT_UNSUPPORTED);
    }

    public static OptionPage advanced() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().setId(StandardOptions.Group.CPU_SAVING).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setId(StandardOptions.Option.PERSISTENT_MAPPING).setName((Component)Component.translatable((String)"sodium.options.use_persistent_mapping.name")).setTooltip((Component)Component.translatable((String)"sodium.options.use_persistent_mapping.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setEnabled(MappedStagingBuffer.isSupported(RenderDevice.INSTANCE)).setBinding((opts, value) -> {
            opts.advanced.useAdvancedStagingBuffers = value;
        }, opts -> opts.advanced.useAdvancedStagingBuffers).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setId(StandardOptions.Option.CPU_FRAMES_AHEAD).setName((Component)Component.translatable((String)"sodium.options.cpu_render_ahead_limit.name")).setTooltip((Component)Component.translatable((String)"sodium.options.cpu_render_ahead_limit.tooltip")).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 9, 1, ControlValueFormatter.translateVariable("sodium.options.cpu_render_ahead_limit.value"))).setBinding((opts, value) -> {
            opts.advanced.cpuRenderAheadLimit = value;
        }, opts -> opts.advanced.cpuRenderAheadLimit).build()).build());
        return new OptionPage(StandardOptions.Pages.ADVANCED, (Component)Component.translatable((String)"sodium.options.pages.advanced"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionStorage<Options> getVanillaOpts() {
        return vanillaOpts;
    }

    public static OptionStorage<EmbeddiumOptions> getSodiumOpts() {
        return sodiumOpts;
    }
}

