/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public class MIExtraCodecs {
    public static final Codec<Float> FLOAT_01 = Codec.floatRange((float)0.0f, (float)1.0f);
    public static final Codec<Long> NON_NEGATIVE_LONG = MIExtraCodecs.longRange(0L, Long.MAX_VALUE);
    public static final Codec<Long> POSITIVE_LONG = MIExtraCodecs.longRange(1L, Long.MAX_VALUE);

    private static <N extends Number> Function<N, DataResult<N>> checkRange(N minInclusive, N maxInclusive) {
        return value -> {
            if (((Comparable)((Object)value)).compareTo(minInclusive) >= 0 && ((Comparable)((Object)value)).compareTo(maxInclusive) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> "Value " + String.valueOf(value) + " outside of range [" + String.valueOf(minInclusive) + ":" + String.valueOf(maxInclusive) + "]", (Object)value);
        };
    }

    static Codec<Long> longRange(long minInclusive, long maxInclusive) {
        Function<Long, DataResult<Long>> checker = MIExtraCodecs.checkRange(minInclusive, maxInclusive);
        return Codec.LONG.flatXmap(checker, checker);
    }

    public static <T> MapCodec<List<T>> maybeList(Codec<T> elementCodec, String field) {
        Codec listCodec = NeoForgeExtraCodecs.listWithOptionalElements((Codec)ConditionalOps.createConditionalCodec(elementCodec));
        Codec maybeListCodec = Codec.either(elementCodec, (Codec)listCodec).xmap(either -> (List)either.map(List::of, Function.identity()), Either::right);
        return maybeListCodec.optionalFieldOf(field, List.of());
    }

    public static <T> MapCodec<T> optionalFieldAlwaysWrite(Codec<T> baseCodec, String field, T defaultValue) {
        return baseCodec.optionalFieldOf(field).xmap(read -> read.orElse(defaultValue), Optional::of);
    }
}

