/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.thirdparty.fabrictransfer.impl.fluid;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluidVariantImpl
implements FluidVariant {
    private static final Map<Fluid, FluidVariant> noTagCache = new ConcurrentHashMap<Fluid, FluidVariant>();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-transfer-api-v1/fluid");
    private final FluidStack stack;
    private final int hashCode;

    private static Fluid normalizeFluid(Fluid fluid) {
        if (!fluid.isSource(fluid.defaultFluidState()) && fluid != Fluids.EMPTY) {
            if (fluid instanceof FlowingFluid) {
                FlowingFluid flowable = (FlowingFluid)fluid;
                return flowable.getSource();
            }
            ResourceLocation id = BuiltInRegistries.FLUID.getKey((Object)fluid);
            throw new IllegalArgumentException("Cannot convert flowing fluid %s (%s) into a still fluid.".formatted(id, fluid));
        }
        return fluid;
    }

    public static FluidVariant of(Fluid fluid) {
        Objects.requireNonNull(fluid, "Fluid may not be null.");
        return noTagCache.computeIfAbsent(FluidVariantImpl.normalizeFluid(fluid), f -> new FluidVariantImpl(new FluidStack(f, 1)));
    }

    public static FluidVariant of(FluidStack stack) {
        Objects.requireNonNull(stack);
        if (stack.isComponentsPatchEmpty() || stack.isEmpty()) {
            return FluidVariantImpl.of(stack.getFluid());
        }
        return FluidVariantImpl.of(stack);
    }

    public FluidVariantImpl(FluidStack stack) {
        this.stack = stack.copyWithAmount(1);
        this.hashCode = FluidStack.hashFluidAndComponents((FluidStack)stack);
    }

    @Override
    public Fluid getObject() {
        return this.stack.getFluid();
    }

    @Override
    public DataComponentPatch getComponentsPatch() {
        return this.stack.getComponentsPatch();
    }

    @Override
    public boolean matches(FluidStack stack) {
        return FluidStack.isSameFluidSameComponents((FluidStack)this.stack, (FluidStack)stack);
    }

    @Override
    public FluidStack toStack(int count) {
        return this.stack.copyWithAmount(count);
    }

    @Override
    public boolean isBlank() {
        return this.stack.isEmpty();
    }

    public String toString() {
        return "FluidVariant{stack=" + String.valueOf(this.stack) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidVariantImpl fluidVariant = (FluidVariantImpl)o;
        return this.hashCode == fluidVariant.hashCode && this.matches(fluidVariant.stack);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

