/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.item;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.datamaps.ItemPipeUpgrade;
import aztech.modern_industrialization.api.datamaps.MIDataMaps;
import aztech.modern_industrialization.pipes.api.IPipeMenuProvider;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.gui.IPipeScreenHandlerHelper;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import aztech.modern_industrialization.pipes.item.ItemNetwork;
import aztech.modern_industrialization.pipes.item.ItemPipeInterface;
import aztech.modern_industrialization.pipes.item.ItemPipeScreenHandler;
import aztech.modern_industrialization.pipes.item.SavedItemPipeConfig;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.TransferHelper;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;
import org.jetbrains.annotations.Nullable;

public class ItemNetworkNode
extends PipeNetworkNode {
    final List<ItemConnection> connections = new ArrayList<ItemConnection>();
    int inactiveTicks = 0;
    public static final Codec<PipeEndpointType> CONNECTION_TYPE_CODEC = Codec.INT.comapFlatMap(i -> switch (i) {
        case 0 -> DataResult.success((Object)((Object)PipeEndpointType.BLOCK_IN));
        case 1 -> DataResult.success((Object)((Object)PipeEndpointType.BLOCK_IN_OUT));
        case 2 -> DataResult.success((Object)((Object)PipeEndpointType.BLOCK_OUT));
        default -> DataResult.error(() -> "Unknown item pipe connection type: " + i);
    }, ItemNetworkNode::encodeConnectionType);

    @Override
    public void updateConnections(Level world, BlockPos pos) {
        PipeNetworks levelNetworks = PipeNetworks.get((ServerLevel)world);
        this.connections.removeIf(connection -> {
            for (PipeNetworkType type : PipeNetworkType.getTypes().values()) {
                PipeNetworkManager manager = levelNetworks.getOptionalManager(type);
                if (manager == null || !manager.hasLink(pos, connection.direction)) continue;
                connection.dropUpgrades(world, pos);
                return true;
            }
            return false;
        });
    }

    private boolean canConnect(Level world, BlockPos pos, Direction direction) {
        BlockPos adjPos = pos.relative(direction);
        return world.getCapability(Capabilities.ItemHandler.BLOCK, adjPos, (Object)direction.getOpposite()) != null;
    }

    @Override
    public PipeEndpointType[] getConnections(BlockPos pos) {
        PipeEndpointType[] connections = new PipeEndpointType[6];
        for (Direction direction : this.network.manager.getNodeLinks(pos)) {
            connections[direction.get3DDataValue()] = PipeEndpointType.PIPE;
        }
        for (ItemConnection connection : this.connections) {
            connections[connection.direction.get3DDataValue()] = connection.type;
        }
        return connections;
    }

    @Override
    public void removeConnection(Level world, BlockPos pos, Direction direction) {
        for (int i = 0; i < this.connections.size(); ++i) {
            ItemConnection conn = this.connections.get(i);
            if (conn.direction != direction) continue;
            if (conn.type == PipeEndpointType.BLOCK_IN) {
                conn.type = PipeEndpointType.BLOCK_IN_OUT;
            } else if (conn.type == PipeEndpointType.BLOCK_IN_OUT) {
                conn.type = PipeEndpointType.BLOCK_OUT;
            } else {
                conn.dropUpgrades(world, pos);
                this.connections.remove(i);
            }
            return;
        }
    }

    @Override
    public void addConnection(PipeBlockEntity pipe, Player player, Level world, BlockPos pos, Direction direction) {
        for (ItemConnection connection : this.connections) {
            if (connection.direction != direction) continue;
            return;
        }
        if (this.canConnect(world, pos, direction)) {
            ItemConnection conn = new ItemConnection(direction, PipeEndpointType.BLOCK_IN, 0, -10);
            this.connections.add(conn);
            ItemStack offHandItem = player.getOffhandItem();
            if (MIItem.CONFIG_CARD.is(offHandItem)) {
                conn.applyConfig(pipe, (SavedItemPipeConfig)offHandItem.get(MIComponents.SAVED_CONFIG), player);
            }
        }
    }

    @Override
    public CompoundTag toTag(CompoundTag tag, HolderLookup.Provider registries) {
        for (ItemConnection connection : this.connections) {
            CompoundTag connectionTag = new CompoundTag();
            connectionTag.putByte("connections", (byte)ItemNetworkNode.encodeConnectionType(connection.type));
            connectionTag.putBoolean("whitelist", connection.whitelist);
            connectionTag.putInt("insertPriority", connection.insertPriority);
            connectionTag.putInt("extractPriority", connection.extractPriority);
            for (int i = 0; i < 21; ++i) {
                connectionTag.put(Integer.toString(i), connection.stacks[i].saveOptional(registries));
            }
            connectionTag.put("upgradeStack", connection.upgradeStack.saveOptional(registries));
            tag.put(connection.direction.toString(), (Tag)connectionTag);
        }
        tag.putInt("inactiveTicks", this.inactiveTicks);
        return tag;
    }

    @Override
    public void fromTag(CompoundTag tag, HolderLookup.Provider registries) {
        for (Direction direction : Direction.values()) {
            if (!tag.contains(direction.toString())) continue;
            CompoundTag connectionTag = tag.getCompound(direction.toString());
            int insertPriority = connectionTag.getInt("insertPriority");
            int extractPriority = connectionTag.getInt("extractPriority");
            ItemConnection connection = new ItemConnection(direction, ItemNetworkNode.decodeConnectionType(connectionTag.getByte("connections")), insertPriority, extractPriority);
            connection.whitelist = connectionTag.getBoolean("whitelist");
            for (int i = 0; i < 21; ++i) {
                connection.stacks[i] = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)connectionTag.getCompound(Integer.toString(i)));
                if (connection.stacks[i].isEmpty()) continue;
                connection.stacks[i].setCount(1);
            }
            connection.refreshStacksCache();
            connection.upgradeStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)connectionTag.getCompound("upgradeStack"));
            this.connections.add(connection);
        }
        this.inactiveTicks = tag.getInt("inactiveTicks");
    }

    public static PipeEndpointType decodeConnectionType(int i) {
        return i == 0 ? PipeEndpointType.BLOCK_IN : (i == 1 ? PipeEndpointType.BLOCK_IN_OUT : PipeEndpointType.BLOCK_OUT);
    }

    public static int encodeConnectionType(PipeEndpointType connection) {
        return connection == PipeEndpointType.BLOCK_IN ? 0 : (connection == PipeEndpointType.BLOCK_IN_OUT ? 1 : 2);
    }

    @Override
    public IPipeMenuProvider getConnectionGui(Direction guiDirection, IPipeScreenHandlerHelper helper) {
        for (ItemConnection connection : this.connections) {
            if (connection.direction != guiDirection) continue;
            ItemConnection itemConnection = connection;
            Objects.requireNonNull(itemConnection);
            return itemConnection.new ItemConnection.ScreenHandlerFactory(helper, this.getType().getIdentifier());
        }
        return null;
    }

    @Override
    public void appendDroppedStacks(List<ItemStack> droppedStacks) {
        for (ItemConnection conn : this.connections) {
            if (conn.upgradeStack.isEmpty()) continue;
            droppedStacks.add(conn.upgradeStack);
            conn.upgradeStack = ItemStack.EMPTY;
        }
    }

    @Override
    public boolean customUse(PipeBlockEntity pipe, Player player, InteractionHand hand, @Nullable Direction hitDirection) {
        for (ItemConnection conn : this.connections) {
            if (conn.direction != hitDirection) continue;
            ItemStack stack = player.getItemInHand(hand);
            if (!MIItem.CONFIG_CARD.is(stack)) {
                return false;
            }
            if (player.isShiftKeyDown()) {
                stack.remove(MIComponents.CAMOUFLAGE);
                stack.set(MIComponents.SAVED_CONFIG, (Object)conn.getConfig());
                player.displayClientMessage((Component)MIText.ConfigCardSet.text(), true);
            } else if (stack.has(MIComponents.SAVED_CONFIG)) {
                conn.applyConfig(pipe, (SavedItemPipeConfig)stack.get(MIComponents.SAVED_CONFIG), player);
                player.displayClientMessage((Component)MIText.ConfigCardApplied.text(), true);
            }
            return true;
        }
        return false;
    }

    public InGameInfo collectNetworkInfo() {
        ItemNetwork itemNetwork = (ItemNetwork)this.network;
        return new InGameInfo(itemNetwork.lastMovedItems, itemNetwork.inactiveTicks);
    }

    class ItemConnection {
        final Direction direction;
        private PipeEndpointType type;
        boolean whitelist = true;
        int insertPriority;
        int extractPriority;
        final ItemStack[] stacks = new ItemStack[21];
        final Map<Item, List<ItemStack>> stacksCache = new IdentityHashMap<Item, List<ItemStack>>();
        private ItemStack upgradeStack = ItemStack.EMPTY;
        BlockCapabilityCache<IItemHandler, @Nullable Direction> cache = null;

        private ItemConnection(Direction direction, PipeEndpointType type, int insertPriority, int extractPriority) {
            this.direction = direction;
            this.type = type;
            this.insertPriority = insertPriority;
            this.extractPriority = extractPriority;
            for (int i = 0; i < 21; ++i) {
                this.stacks[i] = ItemStack.EMPTY;
            }
        }

        private void refreshStacksCache() {
            this.stacksCache.clear();
            for (ItemStack stack : this.stacks) {
                if (stack.isEmpty()) continue;
                this.stacksCache.computeIfAbsent(stack.getItem(), k -> new ArrayList()).add(stack);
            }
        }

        private boolean isInCache(ItemStack stack) {
            List<ItemStack> list = this.stacksCache.get(stack.getItem());
            if (list == null) {
                return false;
            }
            for (ItemStack cachedStack : list) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)cachedStack, (ItemStack)stack)) continue;
                return true;
            }
            return false;
        }

        boolean canInsert() {
            return this.type == PipeEndpointType.BLOCK_IN || this.type == PipeEndpointType.BLOCK_IN_OUT;
        }

        boolean canExtract() {
            return this.type == PipeEndpointType.BLOCK_OUT || this.type == PipeEndpointType.BLOCK_IN_OUT;
        }

        boolean canStackMoveThrough(ItemStack stack) {
            return this.isInCache(stack) == this.whitelist;
        }

        int getMoves() {
            ItemPipeUpgrade upgradeData = (ItemPipeUpgrade)this.upgradeStack.getItemHolder().getData(MIDataMaps.ITEM_PIPE_UPGRADES);
            int extraExtractedItems = upgradeData == null ? 0 : upgradeData.maxExtractedItems();
            return 16 + extraExtractedItems * this.upgradeStack.getCount();
        }

        private void dropUpgrades(Level world, BlockPos pos) {
            if (!this.upgradeStack.isEmpty()) {
                world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), this.upgradeStack));
                this.upgradeStack = ItemStack.EMPTY;
            }
        }

        SavedItemPipeConfig getConfig() {
            ArrayList<ItemStack> filters = new ArrayList<ItemStack>();
            for (ItemStack itemStack : this.stacks) {
                filters.add(itemStack.copy());
            }
            return new SavedItemPipeConfig(this.type, this.whitelist, this.insertPriority, this.extractPriority, filters, this.upgradeStack.copy());
        }

        void applyConfig(PipeBlockEntity pipe, @Nullable SavedItemPipeConfig config, Player player) {
            if (config == null) {
                return;
            }
            boolean remesh = config.connectionType() != this.type;
            this.type = config.connectionType();
            this.whitelist = config.whitelist();
            this.insertPriority = config.insertPriority();
            this.extractPriority = config.extractPriority();
            List<ItemStack> filterStacks = config.filter();
            for (int i = 0; i < 21; ++i) {
                this.stacks[i] = filterStacks.get(i).copy();
                if (this.stacks[i].isEmpty()) continue;
                this.stacks[i].setCount(1);
            }
            this.refreshStacksCache();
            ItemStack requestedUpgrade = config.upgrade().copy();
            if (player.getAbilities().instabuild) {
                this.upgradeStack = requestedUpgrade;
            } else {
                ItemVariant requestedVariant = ItemVariant.of(requestedUpgrade);
                if (requestedVariant.matches(this.upgradeStack)) {
                    int delta = requestedUpgrade.getCount() - this.upgradeStack.getCount();
                    if (delta > 0) {
                        this.upgradeStack.grow(this.fetchItems(player, requestedVariant, delta));
                    } else {
                        player.getInventory().placeItemBackInInventory(this.upgradeStack.split(-delta));
                    }
                } else {
                    player.getInventory().placeItemBackInInventory(this.upgradeStack);
                    this.upgradeStack = requestedVariant.toStack(this.fetchItems(player, requestedVariant, requestedUpgrade.getCount()));
                }
            }
            pipe.setChanged();
            if (remesh) {
                pipe.sync();
            }
        }

        private int fetchItems(Player player, ItemVariant what, int maxAmount) {
            return TransferHelper.extractMatching((IItemHandler)new PlayerInvWrapper(player.getInventory()), what::matches, maxAmount).getCount();
        }

        private class ScreenHandlerFactory
        implements IPipeMenuProvider {
            private final ItemPipeInterface iface;
            private final ResourceLocation pipeType;

            private ScreenHandlerFactory(final IPipeScreenHandlerHelper helper, ResourceLocation pipeType) {
                this.iface = new ItemPipeInterface(){

                    @Override
                    public boolean isWhitelist() {
                        return ItemConnection.this.whitelist;
                    }

                    @Override
                    public void setWhitelist(boolean whitelist) {
                        ItemConnection.this.whitelist = whitelist;
                        helper.callMarkDirty();
                    }

                    @Override
                    public ItemStack getStack(int slot) {
                        return ItemConnection.this.stacks[slot];
                    }

                    @Override
                    public void setStack(int slot, ItemStack stack) {
                        ItemConnection.this.stacks[slot] = stack;
                        ItemConnection.this.refreshStacksCache();
                        helper.callMarkDirty();
                    }

                    @Override
                    public ItemStack getUpgradeStack() {
                        return ItemConnection.this.upgradeStack;
                    }

                    @Override
                    public void setUpgradeStack(ItemStack stack) {
                        ItemConnection.this.upgradeStack = stack;
                        helper.callMarkDirty();
                    }

                    @Override
                    public int getConnectionType() {
                        return ItemNetworkNode.encodeConnectionType(ItemConnection.this.type);
                    }

                    @Override
                    public void setConnectionType(int type) {
                        if (0 <= type && type < 3) {
                            ItemConnection.this.type = ItemNetworkNode.decodeConnectionType(type);
                            helper.callMarkDirty();
                            helper.callSync();
                        }
                    }

                    @Override
                    public int getPriority(int channel) {
                        return channel == 0 ? ItemConnection.this.insertPriority : ItemConnection.this.extractPriority;
                    }

                    @Override
                    public void setPriority(int channel, int priority) {
                        if (channel == 0) {
                            ItemConnection.this.insertPriority = priority;
                        } else {
                            ItemConnection.this.extractPriority = priority;
                        }
                        helper.callMarkDirty();
                    }

                    @Override
                    public boolean canUse(Player player) {
                        if (!helper.isWithinUseDistance(player)) {
                            return false;
                        }
                        return helper.doesNodeStillExist(ItemNetworkNode.this) && ItemNetworkNode.this.connections.contains(ItemConnection.this);
                    }
                };
                this.pipeType = pipeType;
            }

            public Component getDisplayName() {
                return Component.translatable((String)("item." + this.pipeType.getNamespace() + "." + this.pipeType.getPath()));
            }

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new ItemPipeScreenHandler(syncId, inv, this.iface);
            }

            @Override
            public void writeAdditionalData(RegistryFriendlyByteBuf packetByteBuf) {
                this.iface.toBuf(packetByteBuf);
            }
        }
    }

    public record InGameInfo(long movedItems, int pulse) {
    }
}

