/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.fluid;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.client.DynamicTooltip;
import aztech.modern_industrialization.compat.viewer.ReiDraggable;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.network.pipes.SetNetworkFluidPacket;
import aztech.modern_industrialization.pipes.fluid.FluidPipeInterface;
import aztech.modern_industrialization.pipes.fluid.FluidPipeScreenHandler;
import aztech.modern_industrialization.pipes.gui.PipeScreen;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.RenderHelper;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public class FluidPipeScreen
extends PipeScreen<FluidPipeScreenHandler> {
    private static final ResourceLocation TEXTURE = MI.id("textures/gui/pipe/fluid.png");

    public FluidPipeScreen(FluidPipeScreenHandler handler, Inventory inventory, Component title) {
        super(handler, inventory, title, 153);
    }

    protected void init() {
        super.init();
        this.addNetworkFluidButton();
        this.addConnectionTypeButton(148, 22, ((FluidPipeScreenHandler)this.menu).iface);
        this.addPriorityWidgets(33, 42, ((FluidPipeScreenHandler)this.menu).iface, "transfer", 0);
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return TEXTURE;
    }

    private void addNetworkFluidButton() {
        this.addRenderableWidget((GuiEventListener)new NetworkFluidButton(72 + this.leftPos, 20 + this.topPos, widget -> this.updateNetworkFluid(), () -> {
            ArrayList<Object> lines = new ArrayList<Object>();
            lines.add(FluidHelper.getFluidName(((FluidPipeScreenHandler)this.menu).iface.getNetworkFluid(), false));
            if (!((FluidPipeScreenHandler)this.menu).iface.getNetworkFluid().isBlank()) {
                lines.add(MIText.NetworkFluidHelpClear.text().setStyle(TextHelper.GRAY_TEXT));
            } else {
                lines.add(MIText.NetworkFluidHelpSet.text().setStyle(TextHelper.GRAY_TEXT));
            }
            return lines;
        }, ((FluidPipeScreenHandler)this.menu).iface));
    }

    private void updateNetworkFluid() {
        FluidPipeInterface iface = ((FluidPipeScreenHandler)this.menu).iface;
        FluidVariant targetFluid = null;
        if (iface.getNetworkFluid().isBlank()) {
            FluidVariant fluid = FluidVariant.of(FluidUtil.getFluidContained((ItemStack)((FluidPipeScreenHandler)this.menu).getCarried()).orElse(FluidStack.EMPTY));
            if (fluid != null && !fluid.isBlank()) {
                targetFluid = fluid;
            }
        } else if (FluidPipeScreen.hasShiftDown()) {
            targetFluid = FluidVariant.blank();
        }
        if (targetFluid != null) {
            this.setNetworkFluid(targetFluid);
        }
    }

    private void setNetworkFluid(FluidVariant fluidKey) {
        ((FluidPipeScreenHandler)this.menu).iface.setNetworkFluid(fluidKey);
        new SetNetworkFluidPacket(((FluidPipeScreenHandler)this.menu).containerId, fluidKey).sendToServer();
    }

    private class NetworkFluidButton
    extends Button
    implements ReiDraggable {
        private final Supplier<List<Component>> tooltipSupplier;
        private final FluidPipeInterface iface;

        public NetworkFluidButton(int x, int y, Button.OnPress onPress, Supplier<List<Component>> tooltipSupplier, FluidPipeInterface iface) {
            super(x, y, 16, 16, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
            this.tooltipSupplier = tooltipSupplier;
            this.setTooltip(new DynamicTooltip(tooltipSupplier));
            this.iface = iface;
        }

        public Component getMessage() {
            return this.tooltipSupplier.get().getFirst();
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
            guiGraphics.blit(MachineScreen.SLOT_ATLAS, this.getX() - 1, this.getY() - 1, 18, 0, 18, 18);
            if (!this.iface.getNetworkFluid().isBlank()) {
                RenderHelper.drawFluidInGui(guiGraphics, this.iface.getNetworkFluid(), this.getX(), this.getY());
            }
            if (this.isHoveredOrFocused()) {
                RenderSystem.disableDepthTest();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                guiGraphics.fillGradient(this.getX(), this.getY(), this.getX() + 16, this.getY() + 16, -2130706433, -2130706433);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                RenderSystem.enableDepthTest();
            }
        }

        @Override
        public boolean dragFluid(FluidVariant fluidKey, Simulation simulation) {
            if (simulation.isActing()) {
                FluidPipeScreen.this.setNetworkFluid(fluidKey);
            }
            return true;
        }

        @Override
        public boolean dragItem(ItemVariant itemKey, Simulation simulation) {
            return false;
        }
    }
}

