/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.fluid;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.pipes.api.IPipeMenuProvider;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.fluid.FluidNetwork;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkData;
import aztech.modern_industrialization.pipes.fluid.FluidPipeInterface;
import aztech.modern_industrialization.pipes.fluid.FluidPipeScreenHandler;
import aztech.modern_industrialization.pipes.fluid.FluidTarget;
import aztech.modern_industrialization.pipes.gui.IPipeScreenHandlerHelper;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.IOFluidHandler;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidNetworkNode
extends PipeNetworkNode {
    long amount = 0L;
    private final List<FluidConnection> connections = new ArrayList<FluidConnection>();
    private FluidVariant cachedFluid = FluidVariant.blank();

    void gatherTargetsAndPickFluid(ServerLevel world, BlockPos pos, List<FluidTarget> targets) {
        FluidNetworkData data = (FluidNetworkData)this.network.data;
        FluidNetwork network = (FluidNetwork)this.network;
        if (this.amount > (long)network.nodeCapacity) {
            MI.LOGGER.warn("Fluid amount > nodeCapacity, deleting some fluid!");
            this.amount = network.nodeCapacity;
        }
        if (this.amount > 0L && data.fluid.isBlank()) {
            MI.LOGGER.warn("Amount > 0 but fluid is blank, deleting some fluid!");
            this.amount = 0L;
        }
        for (FluidConnection connection : this.connections) {
            IFluidHandler storage = this.getNeighborStorage(world, pos, connection);
            if (data.fluid.isBlank() && connection.canExtract()) {
                data.fluid = FluidVariant.of(storage.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
            }
            targets.add(new FluidTarget(connection.priority, new IOFluidHandler(storage, connection.canInsert(), connection.canExtract())));
        }
    }

    private IFluidHandler getNeighborStorage(ServerLevel world, BlockPos pos, FluidConnection connection) {
        if (connection.cache == null) {
            connection.cache = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)world, (BlockPos)pos.relative(connection.direction), (Object)connection.direction.getOpposite());
        }
        IFluidHandler storage = (IFluidHandler)connection.cache.getCapability();
        return (IFluidHandler)Objects.requireNonNullElse(storage, EmptyFluidHandler.INSTANCE);
    }

    @Override
    public void updateConnections(Level world, BlockPos pos) {
        PipeNetworks levelNetworks = PipeNetworks.get((ServerLevel)world);
        this.connections.removeIf(connection -> {
            for (PipeNetworkType type : PipeNetworkType.getTypes().values()) {
                PipeNetworkManager manager = levelNetworks.getOptionalManager(type);
                if (manager == null || !manager.hasLink(pos, connection.direction)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public PipeEndpointType[] getConnections(BlockPos pos) {
        PipeEndpointType[] connections = new PipeEndpointType[6];
        for (Direction direction : this.network.manager.getNodeLinks(pos)) {
            connections[direction.get3DDataValue()] = PipeEndpointType.PIPE;
        }
        for (FluidConnection connection : this.connections) {
            connections[connection.direction.get3DDataValue()] = connection.type;
        }
        return connections;
    }

    private boolean canConnect(Level world, BlockPos pos, Direction direction) {
        return world.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(direction), (Object)direction.getOpposite()) != null;
    }

    @Override
    public void removeConnection(Level world, BlockPos pos, Direction direction) {
        for (int i = 0; i < this.connections.size(); ++i) {
            FluidConnection conn = this.connections.get(i);
            if (conn.direction != direction) continue;
            if (conn.type == PipeEndpointType.BLOCK_IN) {
                conn.type = PipeEndpointType.BLOCK_IN_OUT;
            } else if (conn.type == PipeEndpointType.BLOCK_IN_OUT) {
                conn.type = PipeEndpointType.BLOCK_OUT;
            } else {
                this.connections.remove(i);
            }
            return;
        }
    }

    @Override
    public void addConnection(PipeBlockEntity pipe, Player player, Level world, BlockPos pos, Direction direction) {
        for (FluidConnection connection : this.connections) {
            if (connection.direction != direction) continue;
            return;
        }
        if (this.canConnect(world, pos, direction)) {
            this.connections.add(new FluidConnection(direction, PipeEndpointType.BLOCK_IN, 0));
        }
    }

    @Override
    public CompoundTag toTag(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putLong("amount_ftl", this.amount);
        for (FluidConnection connection : this.connections) {
            CompoundTag connectionTag = new CompoundTag();
            connectionTag.putByte("connections", (byte)this.encodeConnectionType(connection.type));
            connectionTag.putInt("priority", connection.priority);
            tag.put(connection.direction.toString(), (Tag)connectionTag);
        }
        return tag;
    }

    @Override
    public void fromTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.amount = tag.getLong("amount_ftl");
        for (Direction direction : Direction.values()) {
            if (!tag.contains(direction.toString())) continue;
            if (tag.getTagType(direction.toString()) == 1) {
                this.connections.add(new FluidConnection(direction, this.decodeConnectionType(tag.getByte(direction.toString())), 0));
                continue;
            }
            CompoundTag connectionTag = tag.getCompound(direction.toString());
            this.connections.add(new FluidConnection(direction, this.decodeConnectionType(connectionTag.getByte("connections")), connectionTag.getInt("priority")));
        }
    }

    private PipeEndpointType decodeConnectionType(int i) {
        return i == 0 ? PipeEndpointType.BLOCK_IN : (i == 1 ? PipeEndpointType.BLOCK_IN_OUT : PipeEndpointType.BLOCK_OUT);
    }

    private int encodeConnectionType(PipeEndpointType connection) {
        return connection == PipeEndpointType.BLOCK_IN ? 0 : (connection == PipeEndpointType.BLOCK_IN_OUT ? 1 : 2);
    }

    @Override
    public IPipeMenuProvider getConnectionGui(Direction guiDirection, IPipeScreenHandlerHelper helper) {
        for (FluidConnection connection : this.connections) {
            if (connection.direction != guiDirection) continue;
            FluidConnection fluidConnection = connection;
            Objects.requireNonNull(fluidConnection);
            return fluidConnection.new FluidConnection.ScreenHandlerFactory(helper, this.getType().getIdentifier());
        }
        return null;
    }

    @Override
    public CompoundTag writeCustomData(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        NbtHelper.putFluid(tag, "fluid", ((FluidNetworkData)this.network.data).fluid, registries);
        return tag;
    }

    public void afterTick(ServerLevel world, BlockPos pos) {
        FluidVariant networkFluid = ((FluidNetworkData)this.network.data).fluid;
        if (!networkFluid.equals(this.cachedFluid)) {
            this.cachedFluid = networkFluid;
            world.getChunkSource().blockChanged(pos);
        }
    }

    private FluidVariant getFluid() {
        return ((FluidNetworkData)this.network.data).fluid;
    }

    public InGameInfo collectNetworkInfo() {
        long stored = 0L;
        long capacity = 0L;
        FluidNetwork fluidNetwork = (FluidNetwork)this.network;
        for (PipeNetwork.PosNode posNode : this.network.iterateTickingNodes()) {
            FluidNetworkNode node = (FluidNetworkNode)posNode.getNode();
            stored += node.amount;
            capacity += (long)fluidNetwork.nodeCapacity;
        }
        return new InGameInfo(this.getFluid(), stored, capacity, fluidNetwork.stats.getValue(), capacity);
    }

    private class FluidConnection {
        private final Direction direction;
        private PipeEndpointType type;
        private int priority;
        private BlockCapabilityCache<IFluidHandler, @Nullable Direction> cache;

        private FluidConnection(Direction direction, PipeEndpointType type, int priority) {
            this.direction = direction;
            this.type = type;
            this.priority = priority;
        }

        private boolean canInsert() {
            return this.type == PipeEndpointType.BLOCK_IN || this.type == PipeEndpointType.BLOCK_IN_OUT;
        }

        private boolean canExtract() {
            return this.type == PipeEndpointType.BLOCK_OUT || this.type == PipeEndpointType.BLOCK_IN_OUT;
        }

        private class ScreenHandlerFactory
        implements IPipeMenuProvider {
            private final FluidPipeInterface iface;
            private final ResourceLocation pipeType;

            private ScreenHandlerFactory(final IPipeScreenHandlerHelper helper, ResourceLocation pipeType) {
                this.iface = new FluidPipeInterface(){

                    @Override
                    public FluidVariant getNetworkFluid() {
                        if (FluidNetworkNode.this.network != null) {
                            return FluidNetworkNode.this.getFluid();
                        }
                        return FluidVariant.blank();
                    }

                    @Override
                    public void setNetworkFluid(FluidVariant fluid) {
                        FluidNetwork network = (FluidNetwork)FluidNetworkNode.this.network;
                        if (network != null && !this.getNetworkFluid().equals(fluid)) {
                            network.clearFluid();
                            if (!fluid.isBlank()) {
                                network.setFluid(fluid);
                            }
                            helper.callMarkDirty();
                        }
                    }

                    @Override
                    public int getConnectionType() {
                        return FluidNetworkNode.this.encodeConnectionType(FluidConnection.this.type);
                    }

                    @Override
                    public void setConnectionType(int type) {
                        if (0 <= type && type < 3) {
                            FluidConnection.this.type = FluidNetworkNode.this.decodeConnectionType(type);
                            helper.callMarkDirty();
                            helper.callSync();
                        }
                    }

                    @Override
                    public int getPriority(int channel) {
                        return FluidConnection.this.priority;
                    }

                    @Override
                    public void setPriority(int channel, int priority) {
                        FluidConnection.this.priority = priority;
                        helper.callMarkDirty();
                    }

                    @Override
                    public boolean canUse(Player player) {
                        if (!helper.isWithinUseDistance(player)) {
                            return false;
                        }
                        return helper.doesNodeStillExist(FluidNetworkNode.this) && FluidNetworkNode.this.connections.contains(FluidConnection.this);
                    }
                };
                this.pipeType = pipeType;
            }

            public Component getDisplayName() {
                return Component.translatable((String)("item." + this.pipeType.getNamespace() + "." + this.pipeType.getPath()));
            }

            @Nullable
            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new FluidPipeScreenHandler(syncId, inv, this.iface);
            }

            @Override
            public void writeAdditionalData(RegistryFriendlyByteBuf buf) {
                this.iface.toBuf(buf);
            }
        }
    }

    public record InGameInfo(FluidVariant fluid, long stored, long capacity, long transfer, long maxTransfer) {
    }
}

