/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network.machines;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.gui.MachineMenuServer;
import aztech.modern_industrialization.machines.guicomponents.ReiSlotLocking;
import aztech.modern_industrialization.network.BasePacket;
import aztech.modern_industrialization.network.MIStreamCodecs;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record ReiLockSlotsPacket(int containedId, ResourceLocation recipeId) implements BasePacket
{
    public static final StreamCodec<ByteBuf, ReiLockSlotsPacket> STREAM_CODEC = StreamCodec.composite(MIStreamCodecs.BYTE, ReiLockSlotsPacket::containedId, (StreamCodec)ResourceLocation.STREAM_CODEC, ReiLockSlotsPacket::recipeId, ReiLockSlotsPacket::new);

    @Override
    public void handle(BasePacket.Context ctx) {
        ctx.assertOnServer();
        AbstractContainerMenu sh = ctx.getPlayer().containerMenu;
        if (sh.containerId == this.containedId && sh instanceof MachineMenuServer) {
            MachineMenuServer screenHandler = (MachineMenuServer)sh;
            ReiSlotLocking.Server slotLocking = (ReiSlotLocking.Server)screenHandler.blockEntity.getComponent(GuiComponents.REI_SLOT_LOCKING);
            if (!slotLocking.allowLocking.get().booleanValue()) {
                return;
            }
            slotLocking.slotLockable.lockSlots(this.recipeId, ctx.getPlayer().getInventory());
        }
    }
}

