/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network.armor;

import aztech.modern_industrialization.items.armor.ActivatableChestItem;
import aztech.modern_industrialization.network.BasePacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record ActivateChestPacket(boolean activated) implements BasePacket
{
    public static final StreamCodec<ByteBuf, ActivateChestPacket> STREAM_CODEC = ByteBufCodecs.BOOL.map(ActivateChestPacket::new, ActivateChestPacket::activated);

    @Override
    public void handle(BasePacket.Context ctx) {
        ActivateChestPacket.activateChest(ctx.getPlayer(), this.activated);
    }

    public static void activateChest(Player player, boolean activated) {
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        Item item = chest.getItem();
        if (item instanceof ActivatableChestItem) {
            ActivatableChestItem activatable = (ActivatableChestItem)item;
            activatable.setActivated(chest, activated);
        }
    }
}

