/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.blocks.OreBlock;
import aztech.modern_industrialization.datagen.dynreg.DynamicRegistryDatagen;
import aztech.modern_industrialization.datagen.loot.MIBlockLoot;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.part.TextureGenParams;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.materials.set.MaterialOreSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class OrePart
implements PartKeyProvider {
    public final boolean deepslate;
    public final PartKey key;

    @Override
    public PartKey key() {
        return this.key;
    }

    public PartTemplate of(int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.of(new OrePartParams(UniformInt.of((int)0, (int)2), set, veinsPerChunk, veinSize, maxYLevel));
    }

    public PartTemplate of(UniformInt xpProvider, int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.of(new OrePartParams(xpProvider, set, veinsPerChunk, veinSize, maxYLevel));
    }

    public PartTemplate of(UniformInt xpProvider, MaterialOreSet set) {
        return this.of(new OrePartParams(xpProvider, set));
    }

    public PartTemplate of(MaterialOreSet set) {
        return this.of(new OrePartParams(UniformInt.of((int)0, (int)0), set));
    }

    public OrePart(boolean deepslate) {
        this.key = new PartKey(deepslate ? "ore_deepslate" : "ore");
        this.deepslate = deepslate;
    }

    public PartTemplate of(OrePartParams oreParams) {
        return new PartTemplate(this.deepslate ? "Deepslate %s Ore" : "Ore", this.key).withRegister((partContext, part, itemPath, itemId, itemTag, englishName) -> {
            String loot;
            PartKey mainPartKey = partContext.get(MaterialProperty.MAIN_PART).key();
            if (mainPartKey.equals(MIParts.INGOT.key())) {
                loot = partContext.getMaterialPart(MIParts.RAW_METAL).getItemId();
            } else if (mainPartKey.equals(MIParts.DUST.key())) {
                loot = partContext.getMaterialPart(MIParts.DUST).getItemId();
            } else if (mainPartKey.equals(MIParts.GEM.key())) {
                loot = partContext.getMaterialPart(MIParts.GEM).getItemId();
            } else {
                throw new UnsupportedOperationException("Could not find matching main part.");
            }
            BlockDefinition<OreBlock> oreBlockBlockDefinition = MIBlock.block(englishName, itemPath, MIBlock.BlockDefinitionParams.defaultStone().withBlockConstructor(s -> new OreBlock((BlockBehaviour.Properties)s, oreParams, partContext.getMaterialName())).withLoot(new MIBlockLoot.Ore(loot)).addMoreTags(List.of(Tags.Blocks.ORES)).sortOrder(SortOrder.ORES.and((Comparable)((Object)partContext.getMaterialName()))).destroyTime(this.deepslate ? 4.5f : 3.0f).explosionResistance(3.0f).sound(this.deepslate ? SoundType.DEEPSLATE : SoundType.STONE));
            if (mainPartKey.equals(MIParts.INGOT.key()) != (oreParams.xpDropped.getMaxValue() == 0)) {
                throw new IllegalArgumentException("Mismatch between raw ore and xp drops for material: " + partContext.getMaterialName());
            }
            String tag = "c:ores/" + partContext.getMaterialName();
            TagsToGenerate.generateTag(tag, oreBlockBlockDefinition, partContext.getMaterialEnglishName() + " Ores");
            TagsToGenerate.addTagToTag(tag, Tags.Items.ORES.location().toString(), "Ores");
            if (oreParams.generate) {
                ResourceLocation oreGenId = MI.id((this.deepslate ? "deepslate_" : "") + "ore_generator_" + partContext.getMaterialName());
                ResourceKey featureKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)oreGenId);
                ResourceKey placedFeatureKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)oreGenId);
                ResourceKey modifierKey = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)oreGenId);
                DynamicRegistryDatagen.addAction(() -> {
                    TagMatchTest ruleTest = new TagMatchTest(this.deepslate ? BlockTags.DEEPSLATE_ORE_REPLACEABLES : BlockTags.STONE_ORE_REPLACEABLES);
                    List<OreConfiguration.TargetBlockState> target = List.of(OreConfiguration.target((RuleTest)ruleTest, (BlockState)((OreBlock)((Object)((Object)((Object)oreBlockBlockDefinition.asBlock())))).defaultBlockState()));
                    DynamicRegistryDatagen.add(Registries.CONFIGURED_FEATURE, context -> FeatureUtils.register((BootstrapContext)context, (ResourceKey)featureKey, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(target, oreParams.veinSize)));
                    DynamicRegistryDatagen.add(Registries.PLACED_FEATURE, context -> {
                        Holder.Reference holder = context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(featureKey);
                        List placement = OrePlacements.commonOrePlacement((int)oreParams.veinsPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)oreParams.maxYLevel)));
                        PlacementUtils.register((BootstrapContext)context, (ResourceKey)placedFeatureKey, (Holder)holder, (List)placement);
                    });
                    DynamicRegistryDatagen.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
                        BiomeModifiers.AddFeaturesBiomeModifier modifier = new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.lookup(Registries.BIOME).getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(placedFeatureKey)}), GenerationStep.Decoration.UNDERGROUND_ORES);
                        context.register(modifierKey, (Object)modifier);
                    });
                });
            }
        }).withTexture(new TextureGenParams.Ore(this.deepslate, oreParams.set)).withCustomPath((this.deepslate ? "deepslate_" : "") + "%s_ore", "ores/%s");
    }

    public List<PartTemplate> ofAll(OrePartParams params) {
        return List.of(MIParts.ORE_DEEPSLATE.of(params), MIParts.ORE.of(params));
    }

    public List<PartTemplate> ofAll(UniformInt xpProvider, int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.ofAll(new OrePartParams(xpProvider, set, veinsPerChunk, veinSize, maxYLevel));
    }

    public List<PartTemplate> ofAll(int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.ofAll(new OrePartParams(UniformInt.of((int)0, (int)0), set, veinsPerChunk, veinSize, maxYLevel));
    }

    public static class OrePartParams {
        public final UniformInt xpDropped;
        public final MaterialOreSet set;
        public final boolean generate;
        public final int veinsPerChunk;
        public final int veinSize;
        public final int maxYLevel;

        private OrePartParams(UniformInt xpDropped, MaterialOreSet set, boolean generate, int veinsPerChunk, int veinSize, int maxYLevel) {
            this.xpDropped = xpDropped;
            this.set = set;
            this.generate = generate;
            this.veinsPerChunk = veinsPerChunk;
            this.veinSize = veinSize;
            this.maxYLevel = maxYLevel;
        }

        public OrePartParams(UniformInt xpDropped, MaterialOreSet set) {
            this(xpDropped, set, false, 0, 0, 0);
        }

        public OrePartParams(UniformInt xpDropped, MaterialOreSet set, int veinsPerChunk, int veinSize, int maxYLevel) {
            this(xpDropped, set, true, veinsPerChunk, veinSize, maxYLevel);
        }
    }
}

