/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.recipe.condition.AdjacentBlockProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.BiomeProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.CustomProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.DimensionProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.MapCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class MachineProcessConditions {
    private static final BiMap<ResourceLocation, MapCodec<? extends MachineProcessCondition>> MAP = HashBiMap.create();

    public static void register(ResourceLocation id, MapCodec<? extends MachineProcessCondition> serializer) {
        if (MAP.get((Object)id) != null || MAP.inverse().get(serializer) != null) {
            throw new IllegalArgumentException("Duplicate registration for process condition " + String.valueOf(id));
        }
        MAP.put((Object)id, serializer);
    }

    @Nullable
    public static MapCodec<? extends MachineProcessCondition> get(ResourceLocation id) {
        return (MapCodec)MAP.get((Object)id);
    }

    public static ResourceLocation getId(MapCodec<? extends MachineProcessCondition> serializer) {
        return (ResourceLocation)MAP.inverse().get(serializer);
    }

    static {
        MachineProcessConditions.register(MI.id("dimension"), DimensionProcessCondition.CODEC);
        MachineProcessConditions.register(MI.id("adjacent_block"), AdjacentBlockProcessCondition.CODEC);
        MachineProcessConditions.register(MI.id("biome"), BiomeProcessCondition.CODEC);
        MachineProcessConditions.register(MI.id("custom"), CustomProcessCondition.CODEC);
    }
}

