/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.RelativePosition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;

public record AdjacentBlockProcessCondition(Block block, RelativePosition relativePosition) implements MachineProcessCondition
{
    static final MapCodec<AdjacentBlockProcessCondition> CODEC = RecordCodecBuilder.mapCodec(g -> g.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(c -> c.block), (App)StringRepresentable.fromEnum(RelativePosition::values).fieldOf("position").forGetter(c -> c.relativePosition)).apply((Applicative)g, AdjacentBlockProcessCondition::new));

    @Override
    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        BlockPos checkPos = switch (this.relativePosition) {
            default -> throw new MatchException(null, null);
            case RelativePosition.BELOW -> context.getBlockEntity().getBlockPos().below();
            case RelativePosition.BEHIND -> {
                Direction direction = context.getBlockEntity().orientation.facingDirection;
                yield context.getBlockEntity().getBlockPos().relative(direction.getOpposite());
            }
        };
        return context.getLevel().getBlockState(checkPos).is(this.block);
    }

    @Override
    public void appendDescription(List<Component> list) {
        MIText text = switch (this.relativePosition) {
            default -> throw new MatchException(null, null);
            case RelativePosition.BELOW -> MIText.RequiresBlockBelow;
            case RelativePosition.BEHIND -> MIText.RequiresBlockBehind;
        };
        list.add((Component)text.text(this.block.getName()));
    }

    @Override
    public MapCodec<? extends MachineProcessCondition> codec(boolean syncToClient) {
        return CODEC;
    }
}

