/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe;

import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class MIRecipeJson<T extends MIRecipeJson<?>> {
    protected final MachineRecipe recipe;

    protected MIRecipeJson(MachineRecipeType machineRecipeType, int eu, int duration) {
        this.recipe = new MachineRecipe(machineRecipeType);
        this.recipe.eu = eu;
        this.recipe.duration = duration;
    }

    protected MIRecipeJson(MIRecipeJson<?> otherWithSameData) {
        this((MachineRecipeType)otherWithSameData.recipe.getType(), otherWithSameData.recipe.eu, otherWithSameData.recipe.duration);
        this.recipe.itemInputs.addAll(otherWithSameData.recipe.itemInputs);
        this.recipe.fluidInputs.addAll(otherWithSameData.recipe.fluidInputs);
        this.recipe.itemOutputs.addAll(otherWithSameData.recipe.itemOutputs);
        this.recipe.fluidOutputs.addAll(otherWithSameData.recipe.fluidOutputs);
    }

    public static MIRecipeJson<MIRecipeJson<?>> create(MachineRecipeType machineRecipeType, int eu, int duration) {
        return new MIRecipeJson(machineRecipeType, eu, duration);
    }

    public T addItemInput(TagKey<Item> tag, int amount) {
        return this.addItemInput("#" + tag.location().toString(), amount);
    }

    public T addItemInput(String maybeTag, int amount) {
        return this.addItemInput(maybeTag, amount, 1.0f);
    }

    public T addItemInput(ItemLike item, int amount, float probability) {
        return this.addItemInput(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).toString(), amount, probability);
    }

    public T addItemInput(ItemLike item, int amount) {
        return this.addItemInput((ItemLike)item.asItem(), amount, 1.0f);
    }

    public T addItemInput(String maybeTag, int amount, float probability) {
        Ingredient ing;
        if (maybeTag.startsWith("#")) {
            ing = Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)maybeTag.substring(1))));
        } else {
            if (!BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)maybeTag))) {
                throw new RuntimeException("Could not find item " + maybeTag);
            }
            ing = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)maybeTag))});
        }
        return this.addItemInput(ing, amount, probability);
    }

    public T addItemInput(Ingredient ingredient, int amount, float probability) {
        this.recipe.itemInputs.add(new MachineRecipe.ItemInput(ingredient, amount, probability));
        return (T)this;
    }

    public T addItemOutput(String itemId, int amount) {
        return this.addItemOutput(itemId, amount, 1.0f);
    }

    public T addItemOutput(String itemId, int amount, float probability) {
        this.recipe.itemOutputs.add(new MachineRecipe.ItemOutput(ItemVariant.of((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemId))), amount, probability));
        return (T)this;
    }

    public T addItemOutput(ItemLike item, int amount, float probability) {
        return this.addItemOutput(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).toString(), amount, probability);
    }

    public T addItemOutput(ItemLike item, int amount) {
        return this.addItemOutput(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).toString(), amount);
    }

    public T addItemOutput(Item item, int amount) {
        return this.addItemOutput((ItemLike)item, amount, 1.0f);
    }

    public T addFluidInput(String fluid, int amount) {
        return this.addFluidInput(fluid, amount, 1.0f);
    }

    public T addFluidInput(String fluid, int amount, float probability) {
        this.recipe.fluidInputs.add(new MachineRecipe.FluidInput((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)fluid)), amount, probability));
        return (T)this;
    }

    public T addFluidInput(Fluid fluid, int amount, float probability) {
        ResourceLocation id = BuiltInRegistries.FLUID.getKey((Object)fluid);
        if (id.equals((Object)BuiltInRegistries.FLUID.getDefaultKey())) {
            throw new RuntimeException("Could not find id for fluid " + String.valueOf(fluid));
        }
        return this.addFluidInput(id.toString(), amount, probability);
    }

    public T addFluidInput(FluidLike fluid, int amount, float probability) {
        return this.addFluidInput(fluid.asFluid(), amount, probability);
    }

    public T addFluidInput(FluidLike fluid, int amount) {
        return this.addFluidInput(fluid.asFluid(), amount);
    }

    public T addFluidInput(Fluid fluid, int amount) {
        return this.addFluidInput(fluid, amount, 1.0f);
    }

    public T addFluidOutput(String fluid, int amount) {
        return this.addFluidOutput(fluid, amount, 1.0f);
    }

    public T addFluidOutput(FluidLike fluid, int amount) {
        return this.addFluidOutput(fluid.asFluid(), amount);
    }

    public T addFluidOutput(String fluid, int amount, float probability) {
        this.recipe.fluidOutputs.add(new MachineRecipe.FluidOutput((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)fluid)), amount, probability));
        return (T)this;
    }

    public T addFluidOutput(Fluid fluid, int amount) {
        return this.addFluidOutput(fluid, amount, 1.0f);
    }

    public T addFluidOutput(Fluid fluid, int amount, float probability) {
        return this.addFluidOutput(BuiltInRegistries.FLUID.getKey((Object)fluid).toString(), amount, probability);
    }

    public static MIRecipeJson<?> assemblerFromShaped(ShapedRecipe recipe) {
        return MIRecipeJson.fromShaped(MIMachineRecipeTypes.ASSEMBLER, 8, 200, 1, recipe.result, (String[])((ShapedRecipePattern.Data)recipe.pattern.data.get()).pattern().toArray(String[]::new), ((ShapedRecipePattern.Data)recipe.pattern.data.get()).key());
    }

    public static MIRecipeJson<?> fromShaped(MachineRecipeType machine, int eu, int duration, int division, ItemStack result, String[] pattern, Map<Character, Ingredient> key) {
        if (result.getCount() % division != 0) {
            throw new IllegalArgumentException("Output must be divisible by division");
        }
        MIRecipeJson<?> assemblerJson = MIRecipeJson.create(machine, eu, duration).addItemOutput(result.getItem(), result.getCount() / division);
        for (Map.Entry<Character, Ingredient> entry : key.entrySet()) {
            int count = 0;
            for (String row : pattern) {
                for (char c : row.toCharArray()) {
                    if (c != entry.getKey().charValue()) continue;
                    ++count;
                }
            }
            if (count % division != 0) {
                throw new IllegalArgumentException("Input must be divisible by division");
            }
            Ingredient input = entry.getValue();
            assemblerJson.addItemInput(input, count / division, 1.0f);
        }
        return assemblerJson;
    }
}

