/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.models;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.models.MachineBakedModel;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

public class MachineUnbakedModel
implements IUnbakedGeometry<MachineUnbakedModel> {
    public static final ResourceLocation LOADER_ID = MI.id("machine");
    public static final IGeometryLoader<MachineUnbakedModel> LOADER = (jsonObject, deserializationContext) -> new MachineUnbakedModel(jsonObject);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
    private final MachineCasing baseCasing;
    private final Material[] defaultOverlays;
    private final Map<String, Material[]> tieredOverlays = new HashMap<String, Material[]>();

    private MachineUnbakedModel(JsonObject obj) {
        this.baseCasing = MachineCasings.get(GsonHelper.getAsString((JsonObject)obj, (String)"casing"));
        OverlaysJson defaultOverlaysJson = OverlaysJson.parse(GsonHelper.getAsJsonObject((JsonObject)obj, (String)"default_overlays"), null);
        this.defaultOverlays = defaultOverlaysJson.toSpriteIds();
        JsonObject tieredOverlays = GsonHelper.getAsJsonObject((JsonObject)obj, (String)"tiered_overlays", (JsonObject)new JsonObject());
        for (String casingTier : tieredOverlays.keySet()) {
            OverlaysJson casingOverlaysJson = OverlaysJson.parse(GsonHelper.getAsJsonObject((JsonObject)tieredOverlays, (String)casingTier), defaultOverlaysJson);
            this.tieredOverlays.put(casingTier, casingOverlaysJson.toSpriteIds());
        }
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        TextureAtlasSprite[] defaultOverlays = MachineUnbakedModel.loadSprites(spriteGetter, this.defaultOverlays);
        HashMap<String, TextureAtlasSprite[]> tieredOverlays = new HashMap<String, TextureAtlasSprite[]>();
        for (Map.Entry<String, Material[]> entry : this.tieredOverlays.entrySet()) {
            tieredOverlays.put(entry.getKey(), MachineUnbakedModel.loadSprites(spriteGetter, entry.getValue()));
        }
        return new MachineBakedModel(this.baseCasing, defaultOverlays, tieredOverlays);
    }

    private static TextureAtlasSprite[] loadSprites(Function<Material, TextureAtlasSprite> textureGetter, Material[] ids) {
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            sprites[i] = textureGetter.apply(ids[i]);
        }
        return sprites;
    }

    private static class OverlaysJson {
        private ResourceLocation top;
        private ResourceLocation top_active;
        private ResourceLocation side;
        private ResourceLocation side_active;
        private ResourceLocation bottom;
        private ResourceLocation bottom_active;
        private ResourceLocation front;
        private ResourceLocation front_active;
        private ResourceLocation left;
        private ResourceLocation left_active;
        private ResourceLocation right;
        private ResourceLocation right_active;
        private ResourceLocation back;
        private ResourceLocation back_active;
        private ResourceLocation top_s;
        private ResourceLocation top_s_active;
        private ResourceLocation top_w;
        private ResourceLocation top_w_active;
        private ResourceLocation top_n;
        private ResourceLocation top_n_active;
        private ResourceLocation top_e;
        private ResourceLocation top_e_active;
        private ResourceLocation bottom_s;
        private ResourceLocation bottom_s_active;
        private ResourceLocation bottom_w;
        private ResourceLocation bottom_w_active;
        private ResourceLocation bottom_n;
        private ResourceLocation bottom_n_active;
        private ResourceLocation bottom_e;
        private ResourceLocation bottom_e_active;
        private ResourceLocation output;
        private ResourceLocation item_auto;
        private ResourceLocation fluid_auto;

        private OverlaysJson() {
        }

        private static OverlaysJson parse(JsonObject json, @Nullable OverlaysJson defaultOverlay) {
            OverlaysJson overlays = (OverlaysJson)GSON.fromJson((JsonElement)json, OverlaysJson.class);
            if (defaultOverlay != null) {
                try {
                    for (Field field : OverlaysJson.class.getDeclaredFields()) {
                        if (field.get(overlays) != null) continue;
                        field.set(overlays, field.get(defaultOverlay));
                    }
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Failed to copy fields from default overlay", ex);
                }
            }
            return overlays;
        }

        private Material[] toSpriteIds() {
            return new Material[]{OverlaysJson.select(this.front, this.side), OverlaysJson.select(this.front_active, this.front, this.side_active, this.side), OverlaysJson.select(this.left, this.side), OverlaysJson.select(this.left_active, this.left, this.side_active, this.side), OverlaysJson.select(this.back, this.side), OverlaysJson.select(this.back_active, this.back, this.side_active, this.side), OverlaysJson.select(this.right, this.side), OverlaysJson.select(this.right_active, this.right, this.side_active, this.side), OverlaysJson.select(this.top_s, this.top), OverlaysJson.select(this.top_s_active, this.top_s, this.top_active, this.top), OverlaysJson.select(this.top_w, this.top), OverlaysJson.select(this.top_w_active, this.top_w, this.top_active, this.top), OverlaysJson.select(this.top_n, this.top), OverlaysJson.select(this.top_n_active, this.top_n, this.top_active, this.top), OverlaysJson.select(this.top_e, this.top), OverlaysJson.select(this.top_e_active, this.top_e, this.top_active, this.top), OverlaysJson.select(this.bottom_s, this.bottom), OverlaysJson.select(this.bottom_s_active, this.bottom_s, this.bottom_active, this.bottom), OverlaysJson.select(this.bottom_w, this.bottom), OverlaysJson.select(this.bottom_w_active, this.bottom_w, this.bottom_active, this.bottom), OverlaysJson.select(this.bottom_n, this.bottom), OverlaysJson.select(this.bottom_n_active, this.bottom_n, this.bottom_active, this.bottom), OverlaysJson.select(this.bottom_e, this.bottom), OverlaysJson.select(this.bottom_e_active, this.bottom_e, this.bottom_active, this.bottom), OverlaysJson.select(this.output), OverlaysJson.select(this.item_auto), OverlaysJson.select(this.fluid_auto)};
        }

        @Nullable
        private static Material select(ResourceLocation ... candidates) {
            for (ResourceLocation id : candidates) {
                if (id == null) continue;
                return new Material(InventoryMenu.BLOCK_ATLAS, id);
            }
            return null;
        }
    }
}

